/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.image.util;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.ImageIO;

public class PngUtil {
    public static void merge(OutputStream os, List<InputStream[]> imageISs, int[] backgroundColorRgba, int totalWidth, int totalHeight, int compression) throws IOException {
        PngUtil.merge(os, imageISs, backgroundColorRgba, totalWidth, totalHeight, compression, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void merge(OutputStream os, List<InputStream[]> imageISs, int[] backgroundColorRgba, int totalWidth, int totalHeight, int compression, InputStream rightmostImageIS) throws IOException {
        int pixel;
        CRC32 crc = new CRC32();
        byte[] id = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13};
        PngUtil.write(os, crc, id);
        crc.reset();
        PngUtil.write(os, crc, "IHDR".getBytes());
        PngUtil.write(os, crc, totalWidth);
        PngUtil.write(os, crc, totalHeight);
        byte[] head = null;
        head = new byte[]{8, 6, 0, 0, 0};
        PngUtil.write(os, crc, head);
        PngUtil.write(os, crc, (int)crc.getValue());
        ByteArrayOutputStream compressedOS = new ByteArrayOutputStream(65536);
        BufferedOutputStream bos = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)compressedOS, new Deflater(compression)));
        BufferedImage rightmostImage = null;
        int rImageWidth = 0;
        int rImageHeight = 0;
        if (rightmostImageIS != null) {
            rightmostImage = ImageIO.read(rightmostImageIS);
            rImageWidth = rightmostImage.getWidth();
            rImageHeight = rightmostImage.getHeight();
        }
        int leftImageWidth = totalWidth - rImageWidth;
        int preImageHeightSum = 0;
        int yReal = 0;
        InputStream[] oneRowImageInputs = null;
        for (int i = 0; i < imageISs.size(); ++i) {
            try {
                oneRowImageInputs = imageISs.get(i);
                int oneRowImageCount = oneRowImageInputs.length;
                BufferedImage[] oneRowImages = new BufferedImage[oneRowImageCount];
                for (int c = 0; c < oneRowImageCount; ++c) {
                    oneRowImages[c] = ImageIO.read(oneRowImageInputs[c]);
                }
                int height = oneRowImages[0].getHeight(null);
                for (int y = 0; y < height; ++y) {
                    int x;
                    bos.write(0);
                    int widthSum = 0;
                    for (int c = 0; c < oneRowImageCount; ++c) {
                        int width = oneRowImages[c].getWidth(null);
                        for (int x2 = 0; x2 < width; ++x2) {
                            pixel = oneRowImages[c].getRGB(x2, y);
                            bos.write((byte)(pixel >> 16 & 0xFF));
                            bos.write((byte)(pixel >> 8 & 0xFF));
                            bos.write((byte)(pixel & 0xFF));
                            bos.write((byte)(pixel >> 24 & 0xFF));
                        }
                        widthSum += width;
                    }
                    for (x = widthSum; x < leftImageWidth; ++x) {
                        bos.write(backgroundColorRgba[0]);
                        bos.write(backgroundColorRgba[1]);
                        bos.write(backgroundColorRgba[2]);
                        bos.write(backgroundColorRgba[3]);
                    }
                    yReal = preImageHeightSum + y;
                    if (yReal < rImageHeight && rightmostImage != null) {
                        for (x = 0; x < rImageWidth; ++x) {
                            pixel = rightmostImage.getRGB(x, yReal);
                            bos.write((byte)(pixel >> 16 & 0xFF));
                            bos.write((byte)(pixel >> 8 & 0xFF));
                            bos.write((byte)(pixel & 0xFF));
                            bos.write((byte)(pixel >> 24 & 0xFF));
                        }
                        continue;
                    }
                    for (x = 0; x < rImageWidth; ++x) {
                        bos.write(backgroundColorRgba[0]);
                        bos.write(backgroundColorRgba[1]);
                        bos.write(backgroundColorRgba[2]);
                        bos.write(backgroundColorRgba[3]);
                    }
                }
                preImageHeightSum += height;
                continue;
            }
            finally {
                if (oneRowImageInputs != null) {
                    for (int j = 0; j < oneRowImageInputs.length; ++j) {
                        if (oneRowImageInputs[j] == null) continue;
                        oneRowImageInputs[j].close();
                    }
                }
            }
        }
        if (yReal < rImageHeight) {
            for (int y = yReal; y < totalHeight; ++y) {
                int x;
                bos.write(0);
                for (x = 0; x < leftImageWidth; ++x) {
                    bos.write(backgroundColorRgba[0]);
                    bos.write(backgroundColorRgba[1]);
                    bos.write(backgroundColorRgba[2]);
                    bos.write(backgroundColorRgba[3]);
                }
                if (y < rImageHeight && rightmostImage != null) {
                    for (x = 0; x < rImageWidth; ++x) {
                        pixel = rightmostImage.getRGB(x, y);
                        bos.write((byte)(pixel >> 16 & 0xFF));
                        bos.write((byte)(pixel >> 8 & 0xFF));
                        bos.write((byte)(pixel & 0xFF));
                        bos.write((byte)(pixel >> 24 & 0xFF));
                    }
                    continue;
                }
                for (x = 0; x < rImageWidth; ++x) {
                    bos.write(backgroundColorRgba[0]);
                    bos.write(backgroundColorRgba[1]);
                    bos.write(backgroundColorRgba[2]);
                    bos.write(backgroundColorRgba[3]);
                }
            }
        }
        bos.close();
        PngUtil.write(os, crc, compressedOS.size());
        crc.reset();
        PngUtil.write(os, crc, "IDAT".getBytes());
        PngUtil.write(os, crc, compressedOS.toByteArray());
        PngUtil.write(os, crc, (int)crc.getValue());
        PngUtil.write(os, crc, 0);
        crc.reset();
        PngUtil.write(os, crc, "IEND".getBytes());
        PngUtil.write(os, crc, (int)crc.getValue());
        os.flush();
    }

    private static void write(OutputStream data, CRC32 crc, int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        PngUtil.write(data, crc, b);
    }

    private static void write(OutputStream data, CRC32 crc, byte[] b) throws IOException {
        data.write(b);
        crc.update(b);
    }
}

