/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf;

import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.export.common.exception.ExportIOException;
import com.kingdee.bos.qing.export.common.exception.ExportNoContentException;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.pdf.QingPdfWriter;
import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.comp.Paper;
import com.kingdee.bos.qing.export.pdf.model.SetupModel;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PdfExport {
    private static int SAVEPAGEROW = 500;
    private static int SAVEPAGECOUNT = 5;
    private static final long MAX_EXPORT_SIZE = 314572800L;
    private Map<Integer, List<ColumnText>> mapCT = new TreeMap<Integer, List<ColumnText>>();

    public void export(final TableViewExportJob exportJob, final String fileName) throws ExportNoContentException, ExportIOException {
        IQingFile exportFile = exportJob.getExportFile();
        final Document document = this.initDocument(exportJob);
        try {
            exportFile.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    try {
                        PdfDocument pdf = new PdfDocument();
                        document.addDocListener((DocListener)pdf);
                        QingPdfWriter writer = new QingPdfWriter(pdf, outputStream);
                        pdf.addWriter((PdfWriter)writer);
                        document.open();
                        PdfExport.this.exporting(writer, document, exportJob);
                        PdfExport.this.setOpenHundredPercent(writer, exportJob);
                    }
                    catch (UserStoppedException e) {
                        throw new IOException((Throwable)((Object)e));
                    }
                    catch (DocumentException e) {
                        throw new IOException(e);
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                    finally {
                        document.addTitle(fileName);
                        if (document != null) {
                            document.close();
                        }
                    }
                }
            }, true);
        }
        catch (IOException e) {
            throw new ExportIOException(e);
        }
    }

    private Document initDocument(TableViewExportJob exportJob) throws ExportNoContentException {
        SetupModel model = exportJob.getModel();
        float width = UnitUtil.lomToPt(model.getPaperWidth());
        float height = UnitUtil.lomToPt(model.getPaperHeight());
        Rectangle rc = new Rectangle(width, height);
        float topM = model.getMarginTop();
        float bottomM = model.getMarginBottom();
        float leftM = model.getMarginLeft();
        float rightM = model.getMarginRight();
        float topPt = UnitUtil.lomToPt(topM);
        float bottomPt = UnitUtil.lomToPt(bottomM);
        float leftPt = UnitUtil.lomToPt(leftM);
        float rightPt = UnitUtil.lomToPt(rightM);
        int pageCount = exportJob.getPageCount();
        if (pageCount == -1) {
            throw new ExportNoContentException("no content can be exported");
        }
        return new Document(rc, leftPt, rightPt, topPt, bottomPt);
    }

    private void exporting(QingPdfWriter pdfWriter, Document document, TableViewExportJob exportJob) throws UserStoppedException, DocumentException {
        List<ColumnText> listCT;
        Paper paper;
        int index;
        PdfContentByte contentByte = pdfWriter.getDirectContent();
        int pageRowCount = exportJob.getTableAdapter().getRowCount() / exportJob.getPageCount();
        int savePageCount = pageRowCount > SAVEPAGEROW ? 1 : SAVEPAGECOUNT;
        int lastPageIndex = exportJob.getPageCount() - 1;
        boolean isLegendInOnePage = exportJob.isLegendInOnePage();
        boolean exceedMaxSize = false;
        for (index = 0; !(index == lastPageIndex && isLegendInOnePage || (paper = exportJob.createPaper(index)) == null); ++index) {
            long currentSize;
            listCT = paper.createContent(contentByte);
            if (this.mapCT != null) {
                this.mapCT.put(index, listCT);
            }
            if (index % savePageCount == 0) {
                this.saveToFile(document, exportJob);
            }
            if ((currentSize = pdfWriter.getCurrentDocumentSize()) < 314572800L) continue;
            exceedMaxSize = true;
            break;
        }
        if (exceedMaxSize) {
            return;
        }
        if (isLegendInOnePage && (paper = exportJob.createPaper(index)) != null) {
            listCT = paper.createContentOfLengend(contentByte);
            if (this.mapCT != null) {
                this.mapCT.put(index, listCT);
            }
        }
        this.saveToFile(document, exportJob);
    }

    private void saveToFile(Document document, TableViewExportJob exportJob) throws DocumentException {
        for (Map.Entry<Integer, List<ColumnText>> entry : this.mapCT.entrySet()) {
            List<ColumnText> cts = entry.getValue();
            for (ColumnText ct : cts) {
                ct.go();
            }
            document.newPage();
            exportJob.removePageScope(entry.getKey());
        }
        this.mapCT.clear();
    }

    private void setOpenHundredPercent(PdfWriter pdfWriter, TableViewExportJob exportJob) {
        float height = UnitUtil.lomToPt(exportJob.getModel().getPaperHeight());
        PdfDestination pdfDest = new PdfDestination(0, 0.0f, height, 1.0f);
        PdfAction action = PdfAction.gotoLocalPage((int)1, (PdfDestination)pdfDest, (PdfWriter)pdfWriter);
        pdfWriter.setOpenAction(action);
    }
}

