/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf;

import com.kingdee.bos.qing.export.common.diagonal.DiagonalUtil;
import com.kingdee.bos.qing.export.common.model.ExFont;
import com.kingdee.bos.qing.export.common.model.IExportAdapter;
import com.kingdee.bos.qing.export.common.model.LegendAlign;
import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.pdf.ExFontMapper;
import com.kingdee.bos.qing.export.pdf.TableViewExportPagination;
import com.kingdee.bos.qing.export.pdf.comp.HeaderFooter;
import com.kingdee.bos.qing.export.pdf.comp.PageBody;
import com.kingdee.bos.qing.export.pdf.comp.Paper;
import com.kingdee.bos.qing.export.pdf.comp.WaterMark;
import com.kingdee.bos.qing.export.pdf.model.SetupModel;
import com.kingdee.bos.qing.export.pdf.model.ZoomScaleModel;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.util.LogUtil;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfTemplate;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableViewExportJob {
    public static final int UNKONW = -1;
    private int pageCount = -1;
    private IQingFile exportFile;
    private SetupModel model;
    private IExportAdapter tableAdapter;
    private TableViewExportPagination tablePagination;
    private Map<String, String> mapHFVar;
    private DiagonalCellEvent diagonalCellEvent;
    private com.lowagie.text.Font noramlFont;
    private com.lowagie.text.Font scaleFont;
    private Font scaleAwtFont;
    private static ExFontMapper fontMapper = new ExFontMapper();

    public TableViewExportJob(SetupModel model, IExportAdapter tableAdapter) {
        this.model = model;
        this.tableAdapter = tableAdapter;
        this.tablePagination = new TableViewExportPagination(model, tableAdapter);
        this.preHandleModel();
        this.noramlFont = this.createFont();
        float scale = model.getScaleModel().getScale();
        this.scaleFont = new com.lowagie.text.Font(this.noramlFont.getBaseFont(), this.noramlFont.getSize() * scale);
    }

    private com.lowagie.text.Font createFont() {
        int fontSizePx = ExFontMapper.getDefaultFontSizeOfPx();
        ExFont font = this.getTableAdapter().getFont();
        this.scaleAwtFont = new Font(ExFontMapper.getDefaultFontName(), font.getFontStyle(), fontSizePx);
        BaseFont baseFont = fontMapper.awtToPdf(this.scaleAwtFont);
        fontMapper.setLoggedFontErrorMsg(false);
        return new com.lowagie.text.Font(baseFont, (float)fontSizePx);
    }

    private void preHandleModel() {
        ZoomScaleModel scaleModel;
        if (this.model.isLandscape()) {
            float width = this.model.getPaperWidth();
            this.model.setPaperWidth(this.model.getPaperHeight());
            this.model.setPaperHeight(width);
        }
        if (!(scaleModel = this.model.getScaleModel()).isAutoFit()) {
            float scale = scaleModel.getScale();
            if (scale <= 0.0f) {
                scale = 100.0f;
            }
            scaleModel.setScale(scale / 100.0f);
        } else {
            float scale;
            float scaleHorizontal;
            int w = scaleModel.getAutoFitWidth();
            int h = scaleModel.getAutoFitHeight();
            Rectangle2D.Float pageRect = TableViewExportJob.createBodyRect(this.model);
            float scaleWVertical = 1.0f;
            float scaleHVertical = 1.0f;
            float scaleWHorizontal = 1.0f;
            float scaleHHorizontal = 1.0f;
            if (w > 0) {
                int widthInt = this.tableAdapter.getAllColWidth();
                if (w > 1) {
                    widthInt += this.tableAdapter.getColWidth(this.tableAdapter.getColCount() - 1) * w;
                }
                float verticalLegendWidth = UnitUtil.pixelToPt(this.tableAdapter.getVerticalLegendWidth());
                float width = UnitUtil.pixelToPt((long)widthInt + (long)this.tableAdapter.getLegendGap()) + verticalLegendWidth;
                if (width != 0.0f) {
                    scaleWVertical = pageRect.width * (float)w / width;
                }
                if (scaleWVertical > 1.0f) {
                    scaleWVertical = 1.0f;
                }
                float horizontalLegendWidth = UnitUtil.pixelToPt(this.tableAdapter.getHorizontalLegendWidth());
                width = UnitUtil.pixelToPt((long)widthInt + (long)this.tableAdapter.getLegendGap()) + horizontalLegendWidth;
                if (width != 0.0f) {
                    scaleWHorizontal = pageRect.width * (float)w / width;
                }
                if (scaleWHorizontal > 1.0f) {
                    scaleWHorizontal = 1.0f;
                }
            }
            if (h > 0) {
                float horizontalLegendHeight;
                float maxHeight;
                int heightInt = this.tableAdapter.getAllRowHeight();
                if (h > 1) {
                    heightInt += this.tableAdapter.getRowHeight(this.tableAdapter.getRowCount() - 1) * h;
                }
                float verticalLegendHeight = UnitUtil.pixelToPt(this.tableAdapter.getVerticalLegendHeight());
                float heightIntPt = UnitUtil.pixelToPt(heightInt);
                float f = maxHeight = heightIntPt > verticalLegendHeight ? heightIntPt : verticalLegendHeight;
                if (maxHeight != 0.0f) {
                    scaleHVertical = pageRect.height * (float)h / maxHeight;
                }
                if (scaleHVertical > 1.0f) {
                    scaleHVertical = 1.0f;
                }
                float f2 = maxHeight = heightIntPt > (horizontalLegendHeight = UnitUtil.pixelToPt(this.tableAdapter.getHorizontalLegendHeight())) ? heightIntPt : horizontalLegendHeight;
                if (maxHeight != 0.0f) {
                    scaleHHorizontal = pageRect.height * (float)h / maxHeight;
                }
                if (scaleHHorizontal > 1.0f) {
                    scaleHHorizontal = 1.0f;
                }
            }
            float scaleVertical = scaleWVertical > scaleHVertical ? scaleHVertical : scaleWVertical;
            float f = scaleHorizontal = scaleWHorizontal > scaleHHorizontal ? scaleHHorizontal : scaleWHorizontal;
            if (scaleVertical >= scaleHorizontal) {
                scale = scaleVertical;
                this.model.setLegendAlign(LegendAlign.RIGHT_VERTICAL);
            } else {
                scale = scaleHorizontal;
                this.model.setLegendAlign(LegendAlign.RIGHT_HORIZONTAL);
            }
            scaleModel.setScale(scale);
        }
    }

    public int getPageCount() {
        if (this.pageCount == -1) {
            this.pageCount = this.tablePagination.pageCount();
        }
        return this.pageCount;
    }

    public boolean isLegendInOnePage() {
        return this.tablePagination.isLegendInOnePage();
    }

    public boolean isLegendInOneCol() {
        return this.tablePagination.isLegendInOneCol();
    }

    public Paper createPaper(int index) {
        if (index >= this.pageCount) {
            return null;
        }
        Paper paper = this.createNewPaper(index);
        this.setPage(index, paper);
        this.setHeaderFooter(index, paper);
        this.setWaterMark(paper);
        return paper;
    }

    private Paper createNewPaper(int index) {
        Paper paper = new Paper(this);
        paper.setWidth(UnitUtil.lomToPt(this.model.getPaperWidth()));
        paper.setHeight(UnitUtil.lomToPt(this.model.getPaperHeight()));
        paper.setFont(this.scaleFont);
        paper.setAwtFont(this.scaleAwtFont);
        return paper;
    }

    private void setPage(int index, Paper paper) {
        PageBody page = new PageBody(this, this.tablePagination.getMapPagescope().get(index));
        Rectangle2D.Float rect = TableViewExportJob.createBodyRect(this.model);
        page.setX(rect.x);
        page.setY(rect.y);
        page.setWidth(rect.width);
        page.setHeight(rect.height);
        page.setFont(paper.getFont());
        page.setAwtFont(paper.getAwtFont());
        page.setPageIndex(index);
        paper.setPage(page);
    }

    public static Rectangle2D.Float createBodyRect(SetupModel model) {
        float x = UnitUtil.lomToPt(model.getMarginLeft());
        float y = UnitUtil.lomToPt(model.getMarginBottom());
        float width = UnitUtil.lomToPt(model.getPaperWidth() - (model.getMarginLeft() + model.getMarginRight()));
        float height = UnitUtil.lomToPt(model.getPaperHeight() - (model.getMarginBottom() + model.getMarginTop()));
        return new Rectangle2D.Float(x, y, width, height);
    }

    private void setHeaderFooter(int index, Paper paper) {
        HeaderFooter header = null;
        float x = UnitUtil.lomToPt(this.model.getMarginLeft());
        float width = paper.getWidth() - (x + UnitUtil.lomToPt(this.model.getMarginRight()));
        if (!this.isHeaderFooterEmpty(this.model.getListHeaderRow())) {
            header = new HeaderFooter(index, true, this);
            header.setX(x);
            header.setY(paper.getHeight() - UnitUtil.lomToPt(this.model.getMarginTop()));
            header.setWidth(width);
            header.setFont(this.noramlFont);
            paper.setHeader(header);
        }
        if (!this.isHeaderFooterEmpty(this.model.getListFooterRow())) {
            HeaderFooter footer = new HeaderFooter(index, false, this);
            footer.setX(x);
            footer.setY(UnitUtil.lomToPt(this.model.getMarginBottom()));
            footer.setWidth(width);
            footer.setFont(this.noramlFont);
            paper.setFooter(footer);
        }
    }

    private boolean isHeaderFooterEmpty(List<String[]> hfRows) {
        if (hfRows == null || hfRows.isEmpty()) {
            return true;
        }
        for (String[] row : hfRows) {
            if (row == null || row.length <= 0) continue;
            for (String hf : row) {
                if (hf == null || hf.trim().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private void setWaterMark(Paper paper) {
        if (this.model.getWaterMark() == null || this.model.getWaterMark().trim().isEmpty()) {
            return;
        }
        WaterMark waterMark = new WaterMark(this);
        paper.setWaterMark(waterMark);
        waterMark.setFont(this.noramlFont);
    }

    public void removePageScope(int index) {
        this.tablePagination.removePageScope(index);
    }

    public SetupModel getModel() {
        return this.model;
    }

    public IExportAdapter getTableAdapter() {
        return this.tableAdapter;
    }

    public Map<String, String> getMapHFVar() {
        if (this.mapHFVar == null) {
            this.mapHFVar = new HashMap<String, String>();
        }
        return this.mapHFVar;
    }

    public DiagonalCellEvent getDiagonalCellEvent() {
        if (this.diagonalCellEvent == null) {
            this.diagonalCellEvent = new DiagonalCellEvent();
        }
        return this.diagonalCellEvent;
    }

    public void setExportFile(IQingFile exportUuid) {
        this.exportFile = exportUuid;
    }

    public IQingFile getExportFile() {
        return this.exportFile;
    }

    public static ExFontMapper getFontMapper() {
        return fontMapper;
    }

    class DiagonalCellEvent
    implements PdfPCellEvent {
        private PdfTemplate diagonalTemplate;

        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            PdfContentByte canvas = canvases[1];
            if (this.diagonalTemplate == null) {
                float scale = TableViewExportJob.this.model.getScaleModel().getScale();
                this.diagonalTemplate = canvas.createTemplate(position.getWidth(), position.getHeight());
                PdfGraphics2D graphics2d = new PdfGraphics2D((PdfContentByte)this.diagonalTemplate, position.getWidth(), position.getHeight(), (FontMapper)fontMapper, false, false, 0.0f);
                int fontSize = (int)((float)TableViewExportJob.this.scaleAwtFont.getSize() * scale);
                if (fontSize == 0) {
                    fontSize = 1;
                }
                Font font = new Font(ExFontMapper.getDefaultFontName(), TableViewExportJob.this.scaleAwtFont.getStyle(), fontSize);
                graphics2d.setFont(font);
                graphics2d.scale(72.0f / UnitUtil.getCurrentDpi(), 72.0f / UnitUtil.getCurrentDpi());
                DiagonalUtil.draw((Graphics)graphics2d, scale, TableViewExportJob.this.getTableAdapter());
                graphics2d.dispose();
                try {
                    canvas.getPdfWriter().releaseTemplate(this.diagonalTemplate);
                }
                catch (Exception e) {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
            }
            canvas.addTemplate(this.diagonalTemplate, position.getLeft(), position.getBottom());
        }
    }
}

