/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf.comp;

import com.kingdee.bos.qing.export.common.util.UnitUtil;
import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.comp.BasicPainter;
import com.kingdee.bos.qing.export.pdf.model.SetupModel;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.List;

public class WaterMark
extends BasicPainter {
    private static PdfGState gs = new PdfGState();

    public WaterMark(TableViewExportJob exportJob) {
        super(exportJob);
        gs.setFillOpacity(0.5f);
    }

    @Override
    public List<ColumnText> createContent(PdfContentByte pdfContentByte) {
        PdfPTable table = new PdfPTable(1);
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setCellEvent((PdfPCellEvent)new WatrMarkEvent(this.model));
        table.addCell(cell);
        ColumnText ct = new ColumnText(pdfContentByte);
        ct.setSimpleColumn(0.0f, 0.0f, UnitUtil.lomToPt(this.model.getPaperWidth()), UnitUtil.lomToPt(this.model.getPaperHeight()));
        ct.addElement((Element)table);
        ArrayList<ColumnText> cts = new ArrayList<ColumnText>();
        cts.add(ct);
        return cts;
    }

    class WatrMarkEvent
    implements PdfPCellEvent {
        private SetupModel model;

        public WatrMarkEvent(SetupModel model) {
            this.model = model;
        }

        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            PdfContentByte canvas = canvases[3];
            canvas.saveState();
            canvas.setGState(gs);
            Font font = WaterMark.this.getFont();
            Phrase p = new Phrase(this.model.getWaterMark(), font);
            float textWidth = ((Chunk)p.getChunks().get(0)).getWidthPoint();
            float offset = textWidth / 2.282f;
            ColumnText.showTextAligned((PdfContentByte)canvas, (int)0, (Phrase)p, (float)(UnitUtil.lomToPt(this.model.getPaperWidth()) / 2.0f - offset), (float)(UnitUtil.lomToPt(this.model.getPaperHeight()) / 2.0f - offset), (float)45.0f);
            canvas.restoreState();
        }
    }
}

