/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map;

import com.kingdee.bos.qing.map.builder.ConfigBuilder;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class MapLoader {
    private static IMapLibraryLoader MapLibraryLoader;

    public static void hookMapLibraryLoader(IMapLibraryLoader loader) {
        MapLibraryLoader = loader;
    }

    private static IMapLibraryLoader getMapLib() {
        if (MapLibraryLoader == null) {
            throw new RuntimeException("hookMapLibraryLoader() required.");
        }
        return MapLibraryLoader;
    }

    private static boolean isArchaic(Reference reference) {
        return "map20180808_china".equals(reference.getRefToId());
    }

    public static InputStream loadTemplate(Reference reference) throws MapNotFoundException, MapLoaderException {
        InputStream inStm;
        if (MapLoader.isArchaic(reference)) {
            inStm = MapLoader.class.getResourceAsStream("china.svg");
            if (inStm == null) {
                throw new MapNotFoundException("Map not found: china.svg");
            }
        } else {
            inStm = MapLoader.getMapLib().loadSvg(reference);
        }
        return inStm;
    }

    public static String loadTemplateContent(Reference reference) throws MapNotFoundException, MapLoaderException {
        String string;
        InputStream inStm = null;
        try {
            inStm = MapLoader.loadTemplate(reference);
            string = MapLoader.toStringContent(inStm);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{inStm});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inStm});
        return string;
    }

    public static BackImage loadBackImageDescription(Reference reference) throws MapNotFoundException, MapLoaderException {
        Element xmlRoot;
        if (MapLoader.isArchaic(reference)) {
            return null;
        }
        InputStream inStm = MapLoader.getMapLib().loadConfig(reference);
        try {
            xmlRoot = XmlUtil.loadRootElement((InputStream)inStm);
        }
        catch (JDOMException ex) {
            throw new MapLoaderException(ex, "Parse config error.");
        }
        catch (IOException ex) {
            throw new MapLoaderException(ex, "Parse config error.");
        }
        if (ConfigBuilder.isBackImageDisplay(xmlRoot)) {
            int width = ConfigBuilder.getBackImagePageWidth(xmlRoot);
            int height = ConfigBuilder.getBackImagePageHeight(xmlRoot);
            BackImage backImage = new BackImage();
            backImage.setUrl(MapLoader.getMapLib().getBackImageUrl(reference));
            backImage.setPageSize(width, height);
            return backImage;
        }
        return null;
    }

    public static InputStream loadBackImage(Reference reference) throws MapNotFoundException, MapLoaderException {
        return MapLoader.getMapLib().loadBackImage(reference);
    }

    public static String toStringContent(InputStream inStm) throws MapLoaderException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int size;
            byte[] part = new byte[4096];
            while ((size = inStm.read(part)) > 0) {
                baos.write(part, 0, size);
            }
        }
        catch (IOException ex) {
            throw new MapLoaderException(ex, "");
        }
        String content = null;
        try {
            content = new String(baos.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new MapLoaderException(ex, "");
        }
        return content;
    }

    public static class BackImage {
        private String url;
        private int pageWidth;
        private int pageHeight;

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setPageSize(int pageWidth, int pageHeight) {
            this.pageWidth = pageWidth;
            this.pageHeight = pageHeight;
        }

        public int getPageWidth() {
            return this.pageWidth;
        }

        public int getPageHeight() {
            return this.pageHeight;
        }
    }

    public static class MapNotFoundException
    extends Exception {
        public MapNotFoundException(Throwable cause, String message) {
            super(message, cause);
        }

        public MapNotFoundException(String message) {
            super(message);
        }
    }

    public static class MapLoaderException
    extends Exception {
        public MapLoaderException(Throwable cause, String message) {
            super(message, cause);
        }

        public MapLoaderException(String message) {
            super(message);
        }
    }

    public static interface IMapLibraryLoader {
        public InputStream loadSvg(Reference var1) throws MapNotFoundException, MapLoaderException;

        public InputStream loadConfig(Reference var1) throws MapNotFoundException, MapLoaderException;

        public String getBackImageUrl(Reference var1) throws MapNotFoundException, MapLoaderException;

        public InputStream loadBackImage(Reference var1) throws MapNotFoundException, MapLoaderException;
    }

    public static class Reference {
        private String _refToId;
        private String _fullPath;

        public Reference(String refToId, String refToFullPath) {
            this._refToId = refToId;
            this._fullPath = refToFullPath;
        }

        public String getRefToId() {
            return this._refToId;
        }

        public String getRefToFullPath() {
            return this._fullPath;
        }
    }
}

