/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.builder;

import com.kingdee.bos.qing.map.designer.model.AreaOutputStyle;
import com.kingdee.bos.qing.map.designer.model.DesigntimeMapModel;
import com.kingdee.bos.qing.map.designer.model.Layer;
import com.kingdee.bos.qing.map.designer.model.Page;
import com.kingdee.bos.qing.map.designer.model.Path;
import com.kingdee.bos.qing.map.designer.model.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class ThumbnailBuilder {
    private BufferedImage _backImage;
    private DesigntimeMapModel _model;
    private Color _fillColor;
    private Color _strokeColor;
    private boolean _isAnything;

    public void setBackImage(BufferedImage img) {
        this._backImage = img;
    }

    public void setDesignModel(DesigntimeMapModel model) {
        this._model = model;
    }

    public BufferedImage build(int thumbWidth, int thumbHeight) {
        BufferedImage dest = new BufferedImage(thumbWidth, thumbHeight, 2);
        Rectangle rect = this.confirmRectangle(thumbWidth, thumbHeight);
        if (this._backImage != null && this._model.getPage().getOutputConfig().isBackImageOutputable()) {
            this.drawBackImage(dest, rect);
        }
        Graphics2D g2d = dest.createGraphics();
        this.drawLayers(g2d, rect);
        if (!this._isAnything) {
            int d = Math.max(10, Math.min(rect.width, rect.height) - 40);
            int x = rect.x + (rect.width - d) / 2;
            int y = rect.y + (rect.height - d) / 2;
            int lw = Math.min(20, (int)((double)d * 0.2));
            g2d.setColor(new Color(230, 230, 230));
            g2d.setStroke(new BasicStroke(lw));
            g2d.drawOval(x, y, d, d);
        }
        return dest;
    }

    private Rectangle confirmRectangle(int thumbWidth, int thumbHeight) {
        int pageWidth = this._model.getPage().getWidth();
        int pageHeight = this._model.getPage().getHeight();
        float pageWToHRatio = (float)pageWidth / (float)pageHeight;
        float thumbWToHRatio = (float)thumbWidth / (float)thumbHeight;
        int x = 0;
        int y = 0;
        int width = thumbWidth;
        int height = thumbHeight;
        if (pageWToHRatio > thumbWToHRatio) {
            height = Math.round((float)thumbWidth / pageWToHRatio);
            y = Math.round((thumbHeight - height) / 2);
        } else {
            width = Math.round((float)thumbHeight * pageWToHRatio);
            x = Math.round((thumbWidth - width) / 2);
        }
        return new Rectangle(x, y, width, height);
    }

    private void drawBackImage(BufferedImage dest, Rectangle rect) {
        double xscale = rect.getWidth() / (double)this._backImage.getWidth();
        double yscale = rect.getHeight() / (double)this._backImage.getHeight();
        double xmove = rect.getX();
        double ymove = rect.getY();
        AffineTransform transform = new AffineTransform(xscale, 0.0, 0.0, yscale, xmove, ymove);
        AffineTransformOp op = new AffineTransformOp(transform, null);
        op.filter(this._backImage, dest);
        this._isAnything = true;
    }

    private void drawLayers(Graphics2D g2d, Rectangle rect) {
        Page page = this._model.getPage();
        this.configColor(page.getOutputConfig().getCommonStyle());
        double scale = rect.getWidth() / (double)page.getWidth();
        int c = page.getLayersCount();
        for (int i = 0; i < c; ++i) {
            Layer layer = page.getLayer(i);
            this.drawLayer(layer, g2d, rect, scale);
        }
    }

    private void configColor(AreaOutputStyle style) {
        String fillColor = style.getFillColor();
        if (fillColor == null) {
            this._fillColor = null;
        } else {
            int opacity = style.getFillOpacity();
            int alpha = (int)((float)opacity / 100.0f * 255.0f);
            Color color = Color.decode(fillColor);
            this._fillColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
        String borderColor = style.getBorderColor();
        if (borderColor == null) {
            this._strokeColor = null;
        } else {
            int opacity = style.getBorderOpacity();
            int alpha = (int)((float)opacity / 100.0f * 255.0f);
            Color color = Color.decode(borderColor);
            this._strokeColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }
    }

    private void drawLayer(Layer layer, Graphics2D g2d, Rectangle rect, double scale) {
        int c = layer.getPathsCount();
        for (int i = 0; i < c; ++i) {
            Path path = layer.getPath(i);
            if (!path.isClosed()) continue;
            this.drawPath(path, g2d, rect, scale);
        }
    }

    private void drawPath(Path path, Graphics2D g2d, Rectangle rect, double scale) {
        int count = path.getPointsCount();
        int[] xs = new int[count];
        int[] ys = new int[count];
        for (int i = 0; i < count; ++i) {
            Point point = path.getPoint(i);
            xs[i] = rect.x + (int)((double)point.getX() * 0.01 * scale + 0.5);
            ys[i] = rect.y + (int)((double)point.getY() * 0.01 * scale + 0.5);
        }
        if (this._fillColor != null) {
            g2d.setColor(this._fillColor);
            g2d.fillPolygon(xs, ys, count);
            this._isAnything = true;
        }
        if (this._strokeColor != null) {
            g2d.setColor(this._strokeColor);
            g2d.drawPolygon(xs, ys, count);
            this._isAnything = true;
        }
        if (this._fillColor == null && this._strokeColor == null) {
            g2d.setColor(Color.ORANGE);
            g2d.drawPolygon(xs, ys, count);
            this._isAnything = true;
        }
    }
}

