/**
 * 图表导出，服务端绘制图表的js。
 */
 
 
var NS = com.kingdee.bos.qing.chart.render;

var SizeLegendRender = NS.SizeLegendRender;
var ContinuousColorLegendRender = NS.ContinuousColorLegendRender;
var DiscreteColorLegendRender = NS.DiscreteColorLegendRender;
//完整
var PieChartRender = NS.PieChartRender;
var LineChartRender = NS.LineChartRender;
var RectTreeRender = NS.RectTreeRender;
var ColumnChartRender = NS.ColumnChartRender;
var BarChartRender = NS.BarChartRender;
var AreaChartRender = NS.AreaChartRender;
var KPICardChartRender = NS.KPICardChartRender;
var RadarChartRender = NS.RadarChartRender;
var ProgressBarChartRender = NS.ProgressBarChartRender;
var ProgressColumnChartRender = NS.ProgressColumnChartRender;
var ProgressCircleChartRender = NS.ProgressCircleChartRender;
var CompositeChartRender = NS.CompositeChartRender;
var GridChartRender = NS.GridChartRender;
var WaterfallChartRender = NS.WaterfallChartRender;
var FunnelChartRender = NS.FunnelChartRender;
var DialChartRender = NS.DialChartRender;
var ScatterChartRender = NS.ScatterChartRender;
var SunburstRender = NS.SunburstRender;
var CustomListChartRender = NS.CustomListChartRender;
//分片
var SeparatedVBarRender = NS.SeparatedVBarRender;
var SeparatedHBarRender = NS.SeparatedHBarRender;
var SeparatedAreaChartRender = NS.SeparatedAreaChartRender;
var SeparatedHeatMapRender = NS.SeparatedHeatMapRender;
var SeparatedLineChartRender = NS.SeparatedLineChartRender;
var SeparatedScatterChartRender = NS.SeparatedScatterChartRender;

NS = com.kingdee.bos.qing.chart.model;
var DiscreteColorLegendModel = NS.DiscreteColorLegendModel;
var ContinuousColorLegendModel = NS.ContinuousColorLegendModel;
var GridChartModel = NS.GridChartModel;
var NormalChartModel = NS.NormalChartModel;
var TreeChartModel = NS.TreeChartModel;

var PieAttr = NS.PieAttr;
var YNXSAttr = NS.YNXSAttr;
var YSXNAttr = NS.YSXNAttr;
var LineAttr = NS.LineAttr;
var ScatterAttr = NS.ScatterAttr;
var CommonAttr = NS.CommonAttr;
var RadarAttr = NS.RadarAttr;
var ProgressBarAttr = NS.ProgressBarAttr;
var ProgressColumnAttr = NS.ProgressColumnAttr;
var ProgressCircleAttr = NS.ProgressCircleAttr;
var DialAttr = NS.DialAttr;
var CompositeAttr = NS.CompositeAttr;
var GridAttr = NS.GridAttr;
var WaterfallAttr = NS.WaterfallAttr;
var FunnelAttr = NS.FunnelAttr;
var RectTreeAttr = NS.RectTreeAttr;
var SunburstAttr = NS.SunburstAttr;
var CustomListAttr = NS.CustomListAttr;

/** 
 *  饼图
 */
var drawPie = function(oCtx, iWidth, iHeight, oModel, sSize, bShowLabel, bIgnoreNegative, iLabelType)
{
	//TODO iDiameter由参数传入
    var iDiameter = parseInt(Math.min(iWidth, iHeight) * 0.8);//*0.8要和图例一致
	if(sSize)
	{
		var fRatio = parseFloat(sSize);
		iDiameter = parseInt(iDiameter * fRatio);
	}
	var oAttr = new PieAttr();
	oAttr.setDataLabelType(iLabelType); 
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setIgnoreNegative(bIgnoreNegative);
	var oRender = new PieChartRender(oCtx, oModel, oAttr, iDiameter>>1); 
    oRender.drawChart();
};

/**
 * 画竖柱子
 */
var drawVerticalBar = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bStackMode)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oBarRender = new SeparatedVBarRender(oCtx, oModel, oAttr);
	oBarRender.setStackMode(bStackMode);
	oBarRender.drawChart();
};


/**
 * 画纵坐标轴
 */
var drawVerticalAxis = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bStackMode, sAxisTitle)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oBarRender = new SeparatedVBarRender(oCtx, oModel, oAttr);
	oBarRender.setStackMode(bStackMode);
	oBarRender.drawNumberAxis(sAxisTitle);
};

/**
 * 画横坐标轴
 */
var drawHorizontalAxis = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bStackMode, sAxisTitle)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oBarRender = new SeparatedHBarRender(oCtx, oModel, oAttr);
	oBarRender.setStackMode(bStackMode);
	oBarRender.drawNumberAxis(sAxisTitle);
};

/**
 * 画横柱子
 */
var drawHorizontalBar = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bStackMode)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oBarRender = new SeparatedHBarRender(oCtx, oModel, oAttr);
	oBarRender.setStackMode(bStackMode);
	oBarRender.drawChart();
};

/**
 * 画折线图
 */
var drawSeparatedLineChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel)
{
	var oAttr = new LineAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oLineChartRender = new SeparatedLineChartRender(oCtx, oModel, oAttr);
	oLineChartRender.drawChart();
};

var drawSeparatedLineChartNumberAxis = function(oCtx, iWidth, iHeight, oModel, bShowLabel, sAxisTitle)
{
	var oAttr = new LineAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oLineChartRender = new SeparatedLineChartRender(oCtx, oModel, oAttr);
	oLineChartRender.drawNumberAxis(sAxisTitle);
};

var drawSeparatedLineChartCategoryAxis = function(oCtx, iWidth, iHeight, oModel, bShowLabel)
{
	var oAttr = new LineAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oLineChartRender = new SeparatedLineChartRender(oCtx, oModel, oAttr);
	oLineChartRender.drawCategoryAxis();
}; 

/**
 * 画面积图
 */
var drawSeparatedAreaChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	var oChartRender = new SeparatedAreaChartRender(oCtx, oModel, oAttr);
	oChartRender.drawChart();
};

var drawSeparatedAreaChartNumberAxis = function(oCtx, iWidth, iHeight, oModel, sAxisTitle)
{
	var oAttr = new YNXSAttr();
	var oChartRender = new SeparatedAreaChartRender(oCtx, oModel, oAttr);
	oChartRender.drawNumberAxis(sAxisTitle);
};

var drawSeparatedAreaChartCategoryAxis = function(oCtx, iWidth, iHeight, oModel)
{
	var oAttr = new YNXSAttr();
	var oChartRender = new SeparatedAreaChartRender(oCtx, oModel, oAttr);
	oChartRender.drawCategoryAxis();
}; 

/**
 * 热力图-drawShape
 */
var drawHeatMap = function(oCtx, iWidth, iHeight, sColor, sSize)
{
    if(sSize)
    {
    	var fRatio = parseFloat(sSize);	
	    var iDiameter = parseInt(Math.min(iWidth, iHeight) * 0.8 * fRatio);//*0.8要和图例一致
		var oHeatMapRender = new SeparatedHeatMapRender(oCtx, sColor, iDiameter);
		oHeatMapRender.drawShape();
    }
    else
    {
    	var oHeatMapRender = new SeparatedHeatMapRender(oCtx, sColor);
		oHeatMapRender.drawColorRect();
    }
};

var drawRectTree = function(oCtx, iWidth, iHeight, oModel, bShowLabel, isHideNegative)
{
	var oAttr = new RectTreeAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setIgnoreNegative(isHideNegative);
	var oRectTreeRender = new RectTreeRender(oCtx, oModel, oAttr);
	oRectTreeRender.drawChart();
};

var drawSunburst = function(oCtx, iWidth, iHeight, oModel, bShowLabel, isHideNegative)
{
	var oAttr = new SunburstAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setIgnoreNegative(isHideNegative);
	var oSunburstRender = new SunburstRender(oCtx, oModel, oAttr);
	oSunburstRender.drawChart();
};

/**
 * 散点图/气泡图
 */
var drawScatterXAxis = function(oCtx, iWidth, iHeight, oModel, sAxisTitle)
{
	var oAttr = new ScatterAttr();
	var oScatterRender = new SeparatedScatterChartRender(oCtx, oModel, oAttr);
	oScatterRender.drawXAxis(sAxisTitle);
}
var drawScatterYAxis = function(oCtx, iWidth, iHeight, oModel, sAxisTitle)
{
	var oAttr = new ScatterAttr();
	var oScatterRender = new SeparatedScatterChartRender(oCtx, oModel, oAttr);
	oScatterRender.drawYAxis(sAxisTitle);
}
var drawScatterChart = function(oCtx, iWidth, iHeight, oModel)
{
	var oAttr = new ScatterAttr();
	var oScatterRender = new SeparatedScatterChartRender(oCtx, oModel, oAttr);
	oScatterRender.drawChart();
}

/**
 * 画以大小为标识的图例
 */
var drawSizeLegend = function(oCtx, iWidth, arrRatio, arrText, iBaseDiameter)
{
	var oRender = new SizeLegendRender();
	oRender.draw(oCtx, iBaseDiameter, iWidth, arrRatio, arrText);
};

/**
 * 画以连续颜色为标识的图例
 */
var drawContinuousColorLegend = function(oCtx, iWidth, iHeight, sMinText, sMaxText, arrSegmentColor, sColor1, sColor2, sPos, sColor3, sColor4)
{
	var oRender = new ContinuousColorLegendRender();
	var oModel = new ContinuousColorLegendModel();
	if(arrSegmentColor)
	{
		oModel.prepareSegment(sMinText, sMaxText, arrSegmentColor);
	}
	else
	{
		var numPos = (sPos ? parseFloat(sPos) : null);
		oModel.prepareGradient(sMinText, sMaxText, sColor1, sColor2, numPos, sColor3, sColor4);
	}
	oRender.draw(oCtx, iWidth, oModel);
};

/**
 * 画以离散颜色为标识的图例
 */
var drawDiscreteColorLegend = function(oCtx, iWidth, iHeight, arrColor, arrText, arrCaption, sOthersText)
{
	var oRender = new DiscreteColorLegendRender();
	var oModel = new DiscreteColorLegendModel();
	if(sOthersText != null)
	{
		arrColor.push("rgba(0,0,0,0)");
		arrText.push(sOthersText);
		arrCaption && arrCaption.push("");
	}
	oModel.prepare(arrColor, arrText, arrCaption, 0);
	oRender.draw(oCtx, oModel);
};



// 斗方


var drawLineChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sYFormat, bSmooth, bPaintPoint, bNullAsZero)
{
	var oAttr = new LineAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setYFormat(sYFormat);
	oAttr.setSmooth(bSmooth);
	oAttr.setPaintingPoint(bPaintPoint);
	oAttr.setZeroInsteadNull(bNullAsZero);
	var oRender = new LineChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawColumnChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sYFormat, sYRulerScale, sYRulerStart, sUnitText)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setYFormat(sYFormat);
	oAttr.setYRulerScale(sYRulerScale);
	oAttr.setYRulerStart(sYRulerStart);
	oAttr.setYUnitText(sUnitText);
	var oRender = new ColumnChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawStackColumnChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sYFormat)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setYFormat(sYFormat);
	var oRender = new ColumnChartRender(oCtx, oModel, oAttr);
	oRender.setMode(ColumnChartRender.MODE_STACKED);
	oRender.drawChart();
}

var drawPercentStackedColumnChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sYFormat)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setYFormat(sYFormat);
	var oRender = new ColumnChartRender(oCtx, oModel, oAttr);
	oRender.setMode(ColumnChartRender.MODE_PERCENT_STACKED);
	oRender.drawChart();
}

var drawBarChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sXFormat, sXRulerScale, sXRulerStart)
{
	var oAttr = new YSXNAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setXFormat(sXFormat);
	oAttr.setXRulerScale(sXRulerScale);
	oAttr.setXRulerStart(sXRulerStart);
	var oRender = new BarChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawStackedBarChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sXFormat)
{
	var oAttr = new YSXNAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setXFormat(sXFormat);
	var oRender = new BarChartRender(oCtx, oModel, oAttr);
	oRender.setMode(BarChartRender.MODE_STACKED);
	oRender.drawChart();
}

var drawPercentStackedBarChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sXFormat)
{
	var oAttr = new YSXNAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setXFormat(sXFormat);
	var oRender = new BarChartRender(oCtx, oModel, oAttr);
	oRender.setMode(BarChartRender.MODE_PERCENT_STACKED);
	oRender.drawChart();
}

var drawAreaChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sYFormat)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setYFormat(sYFormat);
	var oRender = new AreaChartRender(oCtx, oModel, oAttr);
	oRender.setPercentMode(false);
	oRender.drawChart();
}

var drawPercentAreaChart = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, sYFormat)
{
	var oAttr = new YNXSAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setYFormat(sYFormat);
	var oRender = new AreaChartRender(oCtx, oModel, oAttr);
	oRender.setPercentMode(true);
	oRender.drawChart();
}

var drawKPI = function(oCtx, iWidth, iHeight, oModel, sCaption,
				sPrimaryString, sSecondaryString)
{
	var oRender = new KPICardChartRender(oModel, oCtx, iWidth, iHeight);
	var oAttr = new CommonAttr();
	
	oRender.setAttr(oAttr);
	oRender.drawChart();
}

var drawRadar = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sRulerFormat, bShowRulerMarkLabel, bFillColor)
{
	var oAttr = new RadarAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setRadarFormat(sRulerFormat);
	oAttr.setShowRulerMarkLabel(bShowRulerMarkLabel);
	oAttr.setFillColor(bFillColor);
	var oRender = new RadarChartRender(oCtx, oModel, oAttr, iWidth, iHeight);
	oRender.drawChart();
}

var drawProgressBar = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, iLabelType, sXFormat, iThicknessPercent)
{
	var oAttr = new ProgressBarAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setLabelType(iLabelType);
	oAttr.setXFormat(sXFormat);
	oAttr.setOverlapShrinkingPercent(iThicknessPercent);
	var oRender = new ProgressBarChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawProgressColumn = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, sLabelFormat, iLabelType, sYFormat, iThicknessPercent)
{
	var oAttr = new ProgressColumnAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setLabelType(iLabelType);
	oAttr.setYFormat(sYFormat);
	oAttr.setOverlapShrinkingPercent(iThicknessPercent);
	var oRender = new ProgressColumnChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawSquarePie = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, iLabelType, bHideNegative)
{
	var iDiameter = parseInt(Math.min(iWidth, iHeight) * 0.8);
	var oAttr = new PieAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelType(iLabelType); 
	oAttr.setIgnoreNegative(bHideNegative);
	var oRender = new PieChartRender(oCtx, oModel, oAttr, iDiameter>>1); 
    oRender.drawChart();
}

var drawSquareRing = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, iLabelType, bHideNegative, bShowTotal)
{
	var iDiameter = parseInt(Math.min(iWidth, iHeight) * 0.8);
	var oAttr = new PieAttr();
	oAttr.setHollow(true);
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelType(iLabelType);
	oAttr.setIgnoreNegative(bHideNegative);
	oAttr.setShowTotalWhenHollow(bShowTotal);
	var oRender = new PieChartRender(oCtx, oModel, oAttr, iDiameter>>1); 
    oRender.drawChart();
}

var drawSquareRose = function(oCtx, iWidth, iHeight, oModel, bShowLabel, bLabelOverlappable, iLabelType, bHideNegative, bAverageAngle)
{
	var iDiameter = parseInt(Math.min(iWidth, iHeight) * 0.8);
	var oAttr = new PieAttr();
	oAttr.setShowDataLabel(bShowLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelType(iLabelType);
	oAttr.setIgnoreNegative(bHideNegative);
	oAttr.setPresentByRadius(true);
	oAttr.setPresentByAngle(!bAverageAngle);
	var oRender = new PieChartRender(oCtx, oModel, oAttr, iDiameter>>1);
	oRender.drawChart();
}

var drawProgressCircle = function(oCtx, iWidth, iHeight, oModel, iPercentageDigit, bPercentageCeiling, iDataEmptyPercentageInstead, sLabelDesc, iThicknessPercent)
{
	var oAttr = new ProgressCircleAttr();
	oAttr.setPercentageDecimalDigit(iPercentageDigit);
	oAttr.setPercentageCeiling(bPercentageCeiling);
	oAttr.setDataEmptyPercentageInstead(iDataEmptyPercentageInstead);
	oAttr.setLabelDesc(sLabelDesc);
	oAttr.setOverlapShrinkingPercent(iThicknessPercent);
	var oRender = new ProgressCircleChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawDial = function(oCtx, iWidth, iHeight, oModel,
		bPanStyleWithTrack, iArcDegree, iRotateDegree, bShowRulerLabel, sRulerLabelFormat,
		arrShowPointerLabel, sPointerName, sPointerNumberFormat)
{
	var iPointerLabelType = 0;
	arrShowPointerLabel[0] && (iPointerLabelType |= DialAttr.SHOW_LABEL_NAME);
	arrShowPointerLabel[1] && (iPointerLabelType |= DialAttr.SHOW_LABEL_NUMBER);
	arrShowPointerLabel[2] && (iPointerLabelType |= DialAttr.SHOW_LABEL_PERCENT);
	
	var oAttr = new DialAttr();
	oAttr.setPanStyle(bPanStyleWithTrack ? DialAttr.PAN_STYLE_WITH_TRACK : DialAttr.PAN_STYLE_ONLY_MARK);
	oAttr.setArcDegree(iArcDegree);
	oAttr.setRotate(iRotateDegree);
	oAttr.setShowRulerMarkLabel(bShowRulerLabel);
	oAttr.setRulerMarkLabelFormat(sRulerLabelFormat);
	
	oAttr.setPointerLabelType(iPointerLabelType);
	oAttr.setPointerName(sPointerName);
	oAttr.setPointerNumberFormat(sPointerNumberFormat);
	
	var oRender = new DialChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawComposite = function(oCtx, iWidth, iHeight, oModel,
		sLeftUnitText, sLeftFormat, sLeftRulerStart, sLeftRulerScale,
		sRightUnitText, sRightFormat, sRightRulerStart, sRightRulerScale,
		bShowLeftLabel, bShowRightLabel, bLabelOverlappable, sLabelFormat, bSmooth, bPaintPoint)
{
	var oAttr = new CompositeAttr();
	oAttr.setPYUnitText(sLeftUnitText);
	oAttr.setPYFormat(sLeftFormat);
	oAttr.setPYRulerStart(sLeftRulerStart);
	oAttr.setPYRulerScale(sLeftRulerScale);
	
	oAttr.setSYUnitText(sRightUnitText);
	oAttr.setSYFormat(sRightFormat);
	oAttr.setSYRulerStart(sRightRulerStart);
	oAttr.setSYRulerScale(sRightRulerScale);
	
	oAttr.setShowDataLabel(bShowLeftLabel, bShowRightLabel);
	oAttr.setDataLabelOverlappable(bLabelOverlappable);
	oAttr.setDataLabelFormat(sLabelFormat);
	oAttr.setSmooth(bSmooth);
	oAttr.setPaintingPoint(bPaintPoint);
	
	var oRender = new CompositeChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawGrid = function(oCtx, iWidth, iHeight, oModel, bShowHeader)
{
	var oAttr = new GridAttr();
	oAttr.setShowHeader(bShowHeader);
	var oRender = new GridChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawCustomList = function(oCtx, iWidth, iHeight, oModel, oJsonAttr)
{
	var bMiddleAlign = oJsonAttr["bodyMiddleAlign"];
	var sSplitLineColor = oJsonAttr["splitLineColor"];
	var iDesigningWidth = oJsonAttr["designingWidth"];
	var oJsonContent = oJsonAttr["content"];
	var oJsonHead = oJsonAttr["head"];
	var oJsonTail = oJsonAttr["tail"];
	
	var oAttr = new CustomListAttr();
	oAttr.setSplitLineColor(sSplitLineColor);
	oAttr.setBodyMiddleAlign(bMiddleAlign);
	var iHeaderHeight = (oJsonHead ? oJsonHead["rowHeight"] : 0);
	var iFooterHeight = (oJsonTail ? oJsonTail["rowHeight"] : 0);
	oAttr.setDesigntimeRowSize(iDesigningWidth, oJsonContent["rowHeight"], iHeaderHeight, iFooterHeight);
	var arrJsonArea = oJsonContent["areas"];
	for(var i = 0; i < arrJsonArea.length; i++)
	{
		var oJsonArea = arrJsonArea[i];
		oAttr.addDesigntimeRect(oJsonArea["x"], oJsonArea["y"], oJsonArea["width"], oJsonArea["height"]);
	}
	if(oJsonHead)
	{
		oAttr.setHeaderBackgroundColor(oJsonHead["backgroundColor"]);
		var arrJsonArea = oJsonHead["areas"];
		for(var i = 0; i < arrJsonArea.length; i++)
		{
			var oJsonArea = arrJsonArea[i];
			oAttr.addDesigntimeHeaderRect(oJsonArea["x"], oJsonArea["y"], oJsonArea["width"], oJsonArea["height"]);
		}
	}
	if(oJsonTail)
	{
		oAttr.setFooterBackgroundColor(oJsonTail["backgroundColor"]);
		var arrJsonArea = oJsonTail["areas"];
		for(var i = 0; i < arrJsonArea.length; i++)
		{
			var oJsonArea = arrJsonArea[i];
			oAttr.addDesigntimeFooterRect(oJsonArea["x"], oJsonArea["y"], oJsonArea["width"], oJsonArea["height"]);
		}
	}
	
	var oRender = new CustomListChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var drawWaterfall = function(oCtx, iWidth, iHeight, oModel, sYUnitText, sYFormat)
{
	var oAttr = new WaterfallAttr();
	oAttr.setYUnitText(sYUnitText);
	oAttr.setYFormat(sYFormat);
	var oRender = new WaterfallChartRender(oCtx, oModel, oAttr);
	oRender.drawChart(-1);
}

var drawFunnel = function(oCtx, iWidth, iHeight, oModel,
	  	bLadderPerfect, iLabelNamePosition, iLabelValuePosition, iLabelPercentPosition,
	  	sRadioBy, sPercentageFormat)
{
	var oAttr = new FunnelAttr();
    oAttr.setLadderPerfect(bLadderPerfect);
    oAttr.setLabelNamePosition(iLabelNamePosition);
    oAttr.setLabelValuePosition(iLabelValuePosition);
    oAttr.setLabelPercentPosition(iLabelPercentPosition);

    (sRadioBy == "STEP") && oAttr.markRatioByStep();
    (sRadioBy == "START") && oAttr.markRatioByStart();
    (sRadioBy == "TOTAL") && oAttr.markRatioByTotal();
    oAttr.setPercentageFormat(sPercentageFormat);

	var oRender = new FunnelChartRender(oCtx, oModel, oAttr);
    oRender.drawChart(-1);
}

var drawScatter = function(oCtx, iWidth, iHeight, oModel,
		sXUnitText, sXFormat, sXRulerStart, sYUnitText, sYFormat, sYRulerStart)
{
	var oAttr = new ScatterAttr();
	oAttr.setXUnitText(sXUnitText);
	oAttr.setXFormat(sXFormat);
	oAttr.setXRulerStart(sXRulerStart);
	
	oAttr.setYUnitText(sYUnitText);
	oAttr.setYFormat(sYFormat);
	oAttr.setYRulerStart(sYRulerStart);
	var oRender = new ScatterChartRender(oCtx, oModel, oAttr);
	oRender.drawChart();
}

var ModelParseFunMap = 
{
	"GridChartModel":GridChartModel.createFromJson,
	"SingleSeriesChartModel":NormalChartModel.createFromJson,
	"MultiSeriesChartModel":NormalChartModel.createFromJson,
	"TreeChartModel":TreeChartModel.createFromJson
}
var changeStringToJsModel = function(sModelType, sModel)
{
	var funParser = ModelParseFunMap[sModelType];
	if (funParser)
	{
		var oJsonModel = JSON.parse(sModel);
		return funParser(oJsonModel);
	}
	throw new Error(sModelType + " not found");
}