/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class LoadMapping {
    public static final String COMMENT_TOKEN = "#";
    public static final String PREFIX_PROPERTY = "[P]";
    public static final String PREFIX_PK0 = "[PK0]";
    public static final String PREFIX_PK1 = "[PK1]";
    public static final String PREFIX_PK2 = "[PK2]";
    public static final String PREFIX_PK3 = "[PK3]";
    private static LoadMapping instance = null;
    private Properties propertis = new Properties();
    private Properties pk0Set = new Properties();
    private Properties pk1Set = new Properties();
    private Properties pk2Set = new Properties();
    private Properties pk3Set = new Properties();

    public static LoadMapping getInstance() {
        instance = new LoadMapping();
        InputStream resourceAsStream = null;
        try {
            resourceAsStream = LoadMapping.class.getResourceAsStream("all.loadmapping");
            instance.loadMapping(resourceAsStream);
        }
        catch (IOException e) {
            LogTool.logError("\u88c5\u8f7d\u914d\u7f6e\u6587\u4ef6all.loadmapping\u65f6\u51fa\u9519", e);
            instance = null;
        }
        finally {
            FileUtils.close(resourceAsStream);
        }
        return instance;
    }

    private void loadMapping(InputStream input) throws IOException {
        if (input == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[1024];
        int len = input.read(bs);
        while (len != -1) {
            sb.append(new String(bs, 0, len));
            len = input.read(bs);
        }
        input.close();
        String[] items = sb.toString().split("\n");
        for (int i = 0; i < items.length; ++i) {
            String item = items[i].trim();
            int index = item.indexOf(COMMENT_TOKEN);
            if (index != -1) {
                item = item.substring(0, index).trim();
            }
            if (item.length() == 0) continue;
            String prefix = null;
            Properties prop = null;
            if (item.startsWith(PREFIX_PROPERTY)) {
                prefix = PREFIX_PROPERTY;
                prop = this.propertis;
            } else if (item.startsWith(PREFIX_PK0)) {
                prefix = PREFIX_PK0;
                prop = this.pk0Set;
            } else if (item.startsWith(PREFIX_PK1)) {
                prefix = PREFIX_PK1;
                prop = this.pk1Set;
            } else if (item.startsWith(PREFIX_PK2)) {
                prefix = PREFIX_PK2;
                prop = this.pk2Set;
            } else if (item.startsWith(PREFIX_PK3)) {
                prefix = PREFIX_PK3;
                prop = this.pk3Set;
            }
            item = item.substring(prefix.length()).trim();
            String[] its = item.split("=");
            if (its.length == 1) {
                prop.put(item, item);
                continue;
            }
            prop.put(its[0].trim(), its[1].trim());
        }
    }

    public Properties getPropertis() {
        return this.propertis;
    }

    public Properties getPk0Set() {
        return this.pk0Set;
    }

    public Properties getPk1Set() {
        return this.pk1Set;
    }

    public Properties getPk2Set() {
        return this.pk2Set;
    }

    public Properties getPk3Set() {
        return this.pk3Set;
    }

    public static void main(String[] args) {
    }
}

