/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.command;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.I18nResourceInfo;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionCollection;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.StatusCollection;
import com.kingdee.bos.metadata.ui.StatusInfo;
import com.kingdee.bos.metadata.ui.StatusItemCollection;
import com.kingdee.bos.metadata.ui.StatusItemInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.dao.ICommand;
import com.kingdee.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class MDCopyCommand
implements ICommand {
    private IMDFile oldFile;
    private String name;
    private String pkName;
    private boolean needDelteOldFile;

    public MDCopyCommand(IMDFile oldFile, String packageName, String name) {
        this.oldFile = oldFile;
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        this.name = name;
        this.pkName = packageName;
    }

    @Override
    public void exec(IProgressMonitor monitor) {
        try {
            int i;
            IDevMetadataLoader loader;
            UIObjectInfo model = null;
            if (this.oldFile.getExtension().equalsIgnoreCase("ui")) {
                loader = this.oldFile.getMDProject().getMetadataLoader();
                model = loader.loadAssmebledUIObject((IMetaDataPK)this.oldFile.getMetaDataPK());
            } else if (this.oldFile.getExtension().equalsIgnoreCase("webui")) {
                loader = this.oldFile.getMDProject().getMetadataLoader();
                model = loader.loadAssmebledWebUIObject((IMetaDataPK)this.oldFile.getMetaDataPK());
            } else {
                model = (AbstractMetaDataValue)MDORMUtil.load(this.oldFile);
            }
            String oldFullName = ((AbstractMetaDataValue)model).getFullName();
            ((AbstractMetaDataValue)model).setPackage(this.pkName);
            ((AbstractMetaDataValue)model).setName(this.name);
            String fullName = this.getFullName(this.pkName, this.name);
            if (model instanceof BusinessObjectInfo) {
                ((BusinessObjectInfo)model).setBusinessImplName(this.genBizImplName(this.pkName, this.name));
                ((BusinessObjectInfo)model).setBusinessControllerName(this.genControllerName(this.pkName, this.name));
                BusinessObjectInfo bo = (BusinessObjectInfo)model;
                if (!oldFullName.equals(fullName)) {
                    bo.remove("bosType");
                }
                int n = bo.getMethods().size();
                MethodInfo method = null;
                for (i = 0; i < n; ++i) {
                    method = bo.getMethods().get(i);
                    if (method.getString("innerID") == null) continue;
                    method.setString("innerID", null);
                }
            } else if (model instanceof BizEnumInfo) {
                ((BizEnumInfo)model).setClassName(fullName);
            } else if (model instanceof BizExceptionInfo) {
                ((BizExceptionInfo)model).setClassName(fullName);
            } else if (model instanceof I18nResourceInfo) {
                ((I18nResourceInfo)model).setClassName(fullName);
            } else if (model instanceof AbstractUIObjectInfo) {
                ((AbstractUIObjectInfo)model).setReleaseClass(this.name);
                ((AbstractUIObjectInfo)model).setReleasePackage(this.pkName);
            }
            MDORMUtil.createFile(this.oldFile.getMDProject(), (IObjectValue)model, monitor);
            if (model instanceof BusinessObjectInfo) {
                this.updateMethodRef((BusinessObjectInfo)model, oldFullName);
            }
            if (!ToolCommonPlugin.isDevelopVersion()) {
                ((AbstractMetaDataValue)model).setUserDefined(true);
                if (model instanceof AbstractUIObjectInfo) {
                    ActionCollection ac = ((AbstractUIObjectInfo)model).getActions();
                    int size = ac.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        ActionInfo ai = ac.get(i2);
                        ai.setUserDefined(true);
                    }
                    ComponentCollection cc = ((AbstractUIObjectInfo)model).getComponents();
                    int size2 = cc.size();
                    for (int i3 = 0; i3 < size2; ++i3) {
                        ComponentInfo ci = cc.get(i3);
                        PropertyBindingCollection pbc = ci.getPropertyBindings();
                        int pbSize = pbc.size();
                        for (int j = 0; j < pbSize; ++j) {
                            PropertyBindingInfo pbi = pbc.get(j);
                            pbi.setUserDefined(true);
                        }
                        ci.setUserDefined(true);
                    }
                    DataObjectCollection dc = ((AbstractUIObjectInfo)model).getDataObjects();
                    int size3 = dc.size();
                    for (i = 0; i < size3; ++i) {
                        DataObjectInfo di = dc.get(i);
                        di.setUserDefined(true);
                    }
                    StatusCollection sc = ((AbstractUIObjectInfo)model).getStatuses();
                    int size4 = sc.size();
                    for (int i4 = 0; i4 < size4; ++i4) {
                        StatusInfo si = sc.get(i4);
                        StatusItemCollection sic = si.getStatusItems();
                        int siSize = sic.size();
                        for (int j = 0; j < siSize; ++j) {
                            StatusItemInfo sii = sic.get(j);
                            sii.setUserDefined(true);
                        }
                        si.setUserDefined(true);
                    }
                }
            }
            MDORMUtil.store(this.oldFile.getMDProject(), (IObjectValue)model, monitor);
            IMDFile newFile = MDResourceUtil.getFile(this.oldFile.getMDProject(), (IObjectValue)model);
            MDResourceUtil.fireResourceCreated(newFile);
            if (this.needDelteOldFile && this.oldFile.toFile().exists()) {
                this.oldFile.toFile().delete();
                MDResourceUtil.fireResourceDeleted(this.oldFile);
            }
        }
        catch (Exception e) {
            LogTool.logError("", e);
        }
    }

    private void updateMethodRef(BusinessObjectInfo model, String oldFullName) {
        MethodCollection mc = model.getMethods();
        String newFullName = model.getFullName();
        for (int i = 0; i < mc.size(); ++i) {
            MethodInfo mInfo = mc.get(i);
            if (mInfo.getMetaDataRef().equals(oldFullName)) {
                mInfo.setMetadataRef(newFullName);
            }
            if (oldFullName.equals(mInfo.getReturnValueType().metaDataRef)) {
                mInfo.getReturnValueType().metaDataRef = newFullName;
            }
            ParameterCollection pc = mInfo.getParameters();
            for (int j = 0; j < pc.size(); ++j) {
                ParameterInfo pInfo = pc.get(j);
                if (!pInfo.getMetaDataRef().equals(oldFullName)) continue;
                pInfo.setMetadataRef(newFullName);
            }
        }
    }

    private String genBizImplName(String pkName, String name) {
        String s = null;
        s = s == null ? "" : s;
        if ((s = s + pkName).equals("app") || s.endsWith(".app")) {
            s = s.length() == "app".length() ? "" : s.substring(0, s.lastIndexOf("app") - 1);
        }
        if (s.length() > 0 && !StringUtils.isEmpty((String)name)) {
            s = s + ".";
        }
        s = s + name;
        return s;
    }

    private String genControllerName(String pkName, String name) {
        return this.getFullName(pkName, name) + "Controller";
    }

    private String getFullName(String pkName, String name) {
        String fName = name;
        if (!StringUtils.isEmpty((String)pkName)) {
            fName = pkName + "." + fName;
        }
        return fName;
    }

    protected void setNeedDeleteOldFile(boolean deleteOldFile) {
        this.needDelteOldFile = deleteOldFile;
    }
}

