/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.BaseMetasFolder;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.IResourceChangeListener;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import com.kingdee.bos.md.mdfs.MDProject;
import com.kingdee.bos.md.mdfs.ResourceChangeDispatcher;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class MDResourceUtil {
    public static final String INVALID_TAG_FILE = "metadata.invalid";
    private static ResourceChangeDispatcher dispatcher = new ResourceChangeDispatcher();
    public static final Map<String, IMDProject> MDPROJECTS = new HashMap<String, IMDProject>();
    private static String[] METADATA_DIR = new String[]{"sp", "patch_industry", "industry", "patch", "bos", "mri", "eas"};
    private static IMDProject latestProject;

    public static boolean isValidMDProject(IProject project) {
        if (project == null || !project.isOpen()) {
            return false;
        }
        return MDResourceUtil.isValidMDProject(project.getLocation().toFile());
    }

    public static boolean isValidMDProject(File root) {
        if (root == null || !root.exists()) {
            return false;
        }
        File file = new File(root, INVALID_TAG_FILE);
        return !file.exists();
    }

    public static void addResourceUpdateListener(IResourceChangeListener listener) {
        dispatcher.addResourceUpdateListener(listener);
    }

    public static void removeResourceUpdateListener(IResourceChangeListener listener) {
        dispatcher.removeResourceUpdateListener(listener);
    }

    public static void fireResourceUpdated(IMDObject[] resources) {
        dispatcher.fireResourceUpdated(resources);
    }

    public static void fireResourceCreated(IMDObject[] resource) {
        dispatcher.fireResourceCreated(resource);
    }

    public static void fireResourceDeleted(IMDObject[] resource) {
        dispatcher.fireResourceDeleted(resource);
    }

    public static void fireResourceUpdated(IMDObject resources) {
        MDResourceUtil.fireResourceUpdated(new IMDObject[]{resources});
    }

    public static void fireResourceCreated(IMDObject resource) {
        MDResourceUtil.fireResourceCreated(new IMDObject[]{resource});
    }

    public static void fireResourceDeleted(IMDObject resource) {
        MDResourceUtil.fireResourceDeleted(new IMDObject[]{resource});
    }

    public static void fireWorkspaceUpdate() {
        dispatcher.fireWorkspaceUpdate();
    }

    public static IMDProject[] listMDProject() {
        return MDPROJECTS.values().toArray(new IMDProject[0]);
    }

    public static String getProjectKey(IMDProject project) {
        return MDResourceUtil.getProjectKey(project.toFile(), project.getBaseMetadataDir(), project.getSrcMetadataDir());
    }

    public static String getProjectKey(File projectRoot) {
        return MDResourceUtil.getProjectKey(projectRoot, new File(projectRoot, "basemetas"), new File(projectRoot, "metadata"));
    }

    public static String getProjectKey(File projectRoot, File baseMetadataDir, File srcMetdadataDir) {
        return projectRoot.getAbsolutePath();
    }

    public static void addMDProject(IMDProject project) {
        MDPROJECTS.put(MDResourceUtil.getProjectKey(project), project);
    }

    public static void removeMDProject(File root) {
        MDPROJECTS.remove(MDResourceUtil.getProjectKey(root));
    }

    public static String getMDPath(IMDProject project, String path) {
        if (StringUtils.isEmpty((String)path)) {
            return path;
        }
        return MDResourceUtil.getMDPath(project, path, path.indexOf(46) == -1);
    }

    public static String getMDPath(IMDProject project, IResource resource) {
        return MDResourceUtil.getMDPath(project, resource.getLocation().toOSString(), resource instanceof IFolder);
    }

    public static String getMDPath(IMDProject project, File file) {
        return MDResourceUtil.getMDPath(project, file.getAbsolutePath(), file.isDirectory());
    }

    public static String getMDPath(IMDProject project, String path, boolean isFolder) {
        if (StringUtils.isEmpty((String)path) || project.getSrcMetadataDir() == null || project.getBaseMetadataDir() == null) {
            return path;
        }
        String srcPath = project.getSrcMetadataDir().getAbsolutePath().toLowerCase(Locale.ENGLISH);
        if (path.toLowerCase(Locale.ENGLISH).startsWith(srcPath)) {
            path = path.substring(srcPath.length());
        } else {
            srcPath = project.getBaseMetadataDir().getAbsolutePath().toLowerCase(Locale.ENGLISH);
            if (path.toLowerCase(Locale.ENGLISH).startsWith(srcPath)) {
                path = path.substring(srcPath.length());
            }
        }
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!StringUtils.isEmpty((String)path) && isFolder && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static IMDFile getFile(IMDProject project, IMetaDataPK pk, BOSObjectType bosType) {
        return MDResourceUtil.getFile(project, pk.getFullName(), bosType);
    }

    public static IMDFile getFile(IMDProject project, String pk, BOSObjectType type) {
        String path = StringUtils.replace((String)pk, (String)".", (String)"/");
        path = path + Utils.getMetaDataSuffix((BOSObjectType)type);
        return project.getRoot().getChildFile(path);
    }

    public static IMDFile getFile(IMDProject project, IObjectValue value) {
        BOSObjectType type = value.getBOSType();
        MetaDataPK pk = new MetaDataPK(value.getString("package"), value.getString("name"));
        return MDResourceUtil.getFile(project, (IMetaDataPK)pk, type);
    }

    public static IMDFile getFile(IMDProject project, MetaDataInfo value) {
        BOSObjectType type = BOSObjectType.create((String)value.getMetaDataType());
        MetaDataPK pk = new MetaDataPK(value.getString("package"), value.getString("name"));
        return MDResourceUtil.getFile(project, (IMetaDataPK)pk, type);
    }

    public static IMDFile[] listChildren(IMDResource[] resources, boolean listAll) {
        ArrayList<IMDResource> list = new ArrayList<IMDResource>();
        for (int i = 0; i < resources.length; ++i) {
            int j;
            IMDResource r = resources[i];
            if (r instanceof IMDFile) {
                if (list.contains(r)) continue;
                list.add(r);
                continue;
            }
            IMDFolder folder = (IMDFolder)r;
            if (listAll) {
                IMDFile[] files = folder.listAllFile(null);
                for (j = 0; j < files.length; ++j) {
                    if (list.contains(files[j])) continue;
                    list.add(files[j]);
                }
                continue;
            }
            IMDResource[] rs = folder.listChildren(null);
            for (j = 0; j < rs.length; ++j) {
                if (!(rs[j] instanceof IMDFile) || list.contains(rs[j])) continue;
                list.add(rs[j]);
            }
        }
        return list.toArray(new IMDFile[0]);
    }

    public static IMDObject[] getTopResources(IMDObject[] resources) {
        if (resources == null || resources.length == 0) {
            return new IMDObject[0];
        }
        ArrayList<IMDObject> list = new ArrayList<IMDObject>();
        list.addAll(Arrays.asList(resources));
        for (int i = 0; i < list.size() - 1; ++i) {
            if (list.get(i) instanceof IMDProject) {
                return new IMDObject[]{(IMDProject)list.get(i)};
            }
            String path = ((IMDResource)list.get(i)).getPath();
            boolean isChild = false;
            for (int j = i + 1; j < list.size(); ++j) {
                IMDFolder consj;
                if (list.get(j) instanceof IMDProject) {
                    return new IMDObject[]{(IMDProject)list.get(j)};
                }
                if (!(list.get(j) instanceof IMDFolder) || !(consj = (IMDFolder)list.get(j)).isParentOf(path, false)) continue;
                isChild = true;
                break;
            }
            if (!isChild) continue;
            list.remove(i);
            --i;
        }
        return list.toArray(new IMDObject[list.size()]);
    }

    public static IMDResource[] listSelectedResource(IStructuredSelection selection) {
        ArrayList result = new ArrayList(selection.size());
        for (Object element : selection) {
            if (element instanceof IMDResource) {
                result.add(element);
                continue;
            }
            if (!(element instanceof IMDProject)) continue;
            return new IMDResource[]{((IMDProject)element).getRoot()};
        }
        if (result.size() > 1) {
            block1: for (int i = 0; i < result.size(); ++i) {
                IMDResource resource = (IMDResource)result.get(i);
                for (IMDFolder p = resource.getParent(); p != null; p = p.getParent()) {
                    if (!result.contains(p)) continue;
                    result.remove(i);
                    --i;
                    continue block1;
                }
            }
        }
        return result.toArray(new IMDResource[result.size()]);
    }

    public static IMDFile[] listChildFiles(IMDObject[] resources) {
        return MDResourceUtil.listChildFiles(resources, null);
    }

    public static IMDFile[] listChildFiles(IMDObject[] resources, String suffix) {
        if (resources == null || resources.length == 0) {
            return new IMDFile[0];
        }
        IMDObject[] objs = MDResourceUtil.getTopResources(resources);
        ArrayList<IMDObject> list = new ArrayList<IMDObject>();
        for (int i = 0; i < objs.length; ++i) {
            IMDFolder folder;
            if (objs[i] instanceof IMDFile) {
                if (suffix != null && !suffix.equalsIgnoreCase(((IMDFile)objs[i]).getExtension())) continue;
                list.add(objs[i]);
                continue;
            }
            if (objs[i] instanceof IMDFolder) {
                folder = (IMDFolder)objs[i];
                list.addAll(Arrays.asList(folder.listAllFile(suffix)));
                continue;
            }
            if (!(objs[i] instanceof IMDProject)) continue;
            folder = ((IMDProject)objs[i]).getRoot();
            list.addAll(Arrays.asList(folder.listAllFile(suffix)));
        }
        return list.toArray(new IMDFile[list.size()]);
    }

    public static IFile toIFile(IMDFile file) {
        IFolder folder = MDResourceUtil.toIFolder(file.getParent());
        IFile f = folder.getFile(file.getName());
        if (!f.exists() && file.toFile().exists()) {
            try {
                folder.refreshLocal(2, null);
                f = folder.getFile(file.getName());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (!f.exists() && file.exists()) {
            try {
                InputStream input = file.getContent();
                if (input != null) {
                    f.create(input, true, null);
                    input.close();
                } else {
                    f.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                }
            }
            catch (Exception e) {
                LogTool.logError("", e);
            }
        }
        return f;
    }

    public static IResource toIResource(IMDObject resource) {
        if (resource instanceof IMDFile) {
            return MDResourceUtil.toIFile((IMDFile)resource);
        }
        if (resource instanceof IMDFolder) {
            return MDResourceUtil.toIFolder((IMDFolder)resource);
        }
        return MDResourceUtil.toIProject((IMDProject)resource);
    }

    public static IProject toIProject(IMDProject project) {
        if (project == null) {
            return null;
        }
        String name = project.getName();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].getName().equalsIgnoreCase(name)) continue;
            return projects[i];
        }
        return null;
    }

    public static IFolder toIFolder(IMDFolder folder) {
        if (folder instanceof BaseMetasFolder) {
            return MDResourceUtil.toIProject(folder.getMDProject()).getFolder("basemetas");
        }
        IFolder root = MDResourceUtil.toIProject(folder.getMDProject()).getFolder("metadata");
        if (!folder.toFile().exists()) {
            root = root.getFolder(folder.getPath());
            return root;
        }
        root = root.getFolder(folder.getPath());
        return root;
    }

    public static IMDFolder toMDFolder(IFolder folder) {
        IMDProject project = MDResourceUtil.toMDProject(folder.getProject());
        return project.getRoot().getChildFolder(folder.getLocation().toOSString());
    }

    public static IMDFile toMDFile(IFile file) {
        IMDProject project = MDResourceUtil.toMDProject(file.getProject());
        return project.getRoot().getChildFile(file.getLocation().toOSString());
    }

    public static IMDProject getMDProject(File root) {
        assert (root.isDirectory());
        String key = MDResourceUtil.getProjectKey(root);
        IMDProject mdp = MDPROJECTS.get(key);
        if (mdp == null) {
            mdp = new MDProject(root, root.getName());
        } else if (mdp.isDisposed()) {
            MDResourceUtil.removeMDProject(root);
            mdp = new MDProject(root, root.getName());
            LogTool.logWarn("re_create mdproject" + root.getName(), null);
        }
        return mdp;
    }

    public static IMDProject getMDProject(File root, File baseMetaDir, File srcMetaDir) {
        String key = MDResourceUtil.getProjectKey(root, baseMetaDir, srcMetaDir);
        IMDProject mdp = MDPROJECTS.get(key);
        if (mdp == null) {
            mdp = new MDProject(root, root.getName(), baseMetaDir, srcMetaDir);
        }
        return mdp;
    }

    public static IMDProject getMDProject(IResource resource) {
        if (!resource.getProject().isOpen()) {
            return null;
        }
        return MDResourceUtil.getMDProject(resource.getProject().getLocation().toFile());
    }

    public static IMDProject getMDProject(String projectName) {
        IMDProject[] ps = MDResourceUtil.listMDProject();
        for (int i = 0; i < ps.length; ++i) {
            if (!ps[i].getName().equalsIgnoreCase(projectName)) continue;
            return ps[i];
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].getName().equalsIgnoreCase(projectName)) continue;
            return MDResourceUtil.getMDProject(projects[i].getLocation().toFile());
        }
        return null;
    }

    public static boolean isExistMDProject(String projectName) {
        IMDProject[] ps;
        for (IMDProject prj : ps = MDResourceUtil.listMDProject()) {
            if (!prj.toFile().getName().equalsIgnoreCase(projectName)) continue;
            return true;
        }
        return false;
    }

    public static IMDProject getExistMDProject(String projectName) {
        IMDProject[] ps;
        for (IMDProject prj : ps = MDResourceUtil.listMDProject()) {
            if (!prj.toFile().getName().equalsIgnoreCase(projectName)) continue;
            return prj;
        }
        return null;
    }

    public static IMDProject toMDProject(IProject project) {
        if (!MDResourceUtil.isValidMDProject(project)) {
            return null;
        }
        if (project.getLocation() == null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            for (int i = 0; i < projects.length; ++i) {
                if (!projects[i].getName().equalsIgnoreCase(project.getName())) continue;
                project = projects[i];
            }
        }
        return MDResourceUtil.getMDProject(project.getLocation().toFile());
    }

    public static IMDObject toMDResource(IResource resource) {
        if (resource instanceof IFolder) {
            return MDResourceUtil.toMDFolder((IFolder)resource);
        }
        if (resource instanceof IFile) {
            return MDResourceUtil.toMDFile((IFile)resource);
        }
        if (resource instanceof IProject) {
            return MDResourceUtil.toMDProject(resource.getProject());
        }
        return null;
    }

    public static String getMetadataPath(IMDProject project, boolean includeSrc, boolean useWildcard) {
        File file;
        File root = project.getBaseMetadataDir();
        ArrayList<File> list = new ArrayList<File>();
        StringBuffer sb = new StringBuffer();
        if (includeSrc && (file = project.getSrcMetadataDir()).exists()) {
            sb.append(file.getAbsolutePath() + ";");
        }
        if (new File(root, "sp-industry-metas.jar").exists()) {
            sb.append(new File(root, "sp-industry-metas.jar").getAbsolutePath() + ";");
        }
        if (useWildcard) {
            int i;
            for (i = 0; i < METADATA_DIR.length; ++i) {
                File file2 = new File(root, METADATA_DIR[i]);
                MDResourceUtil.listMetadata(list, file2, true);
            }
            MDResourceUtil.listMetadata(list, root, true);
            for (i = 0; i < list.size(); ++i) {
                sb.append(((File)list.get(i)).getAbsolutePath() + "/*.jar;");
            }
        } else {
            File[] fs = MDResourceUtil.listMetadataLib(project);
            for (int i = 0; i < fs.length; ++i) {
                sb.append(fs[i].getAbsolutePath() + ";");
            }
        }
        return sb.toString();
    }

    public static File[] listMetadataLib(IMDProject project) {
        File root = project.getBaseMetadataDir();
        ArrayList<File> list = new ArrayList<File>();
        if (new File(root, "sp-industry-metas.jar").exists()) {
            list.add(new File(root, "sp-industry-metas.jar"));
        }
        if (new File(root, "bos/package-metas.jar").exists()) {
            list.add(new File(root, "bos/package-metas.jar"));
        }
        for (int i = 0; i < METADATA_DIR.length; ++i) {
            File file = new File(root, METADATA_DIR[i]);
            MDResourceUtil.listMetadata(list, file, false);
        }
        MDResourceUtil.listMetadata(list, root, false);
        if (!new File(root, "bim_templates.zip").exists()) {
            list.add(new File(MDResourceUtil.getBimTemplateZipPath()));
        }
        return list.toArray(new File[0]);
    }

    private static void listMetadata(List<File> list, File root, boolean dir) {
        if (root == null || !root.exists()) {
            return;
        }
        if (root.isFile()) {
            if (!dir && !list.contains(root) && (root.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || root.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip"))) {
                list.add(root);
            }
        } else {
            if (dir && !list.contains(root)) {
                list.add(root);
            }
            File[] fs = root.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                MDResourceUtil.listMetadata(list, fs[i], dir);
            }
        }
    }

    public static void setLatestProject(IMDProject project) {
        latestProject = project;
    }

    public static IMDProject getLatestProject() {
        if (latestProject != null && !MDResourceUtil.toIProject(latestProject).exists()) {
            latestProject = null;
        }
        return latestProject;
    }

    public static IMDProject getActiveProject() {
        ISelection selection;
        IWorkbenchPart view;
        IWorkbenchPage page = ToolCommonPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IMDFileEditorInput) {
                return ((IMDFileEditorInput)input).getFile().getMDProject();
            }
            if (input instanceof IFileEditorInput) {
                IProject p = ((IFileEditorInput)input).getFile().getProject();
                return MDResourceUtil.toMDProject(p);
            }
        }
        if ((view = page.getActivePart()) instanceof IViewPart && view.getSite().getSelectionProvider() != null && !(selection = view.getSite().getSelectionProvider().getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof IMDObject) {
                return ((IMDObject)object).getMDProject();
            }
            if (object instanceof IResource) {
                return MDResourceUtil.getMDProject((IResource)object);
            }
            if (object instanceof MDObjectAdapter) {
                return ((MDObjectAdapter)object).getModel().getMDProject();
            }
        }
        return null;
    }

    public static String getBimTemplateZipPath() {
        try {
            return new File(FileLocator.resolve((URL)Platform.getBundle((String)"com.kingdee.bos.solutiontemplate").getEntry("/")).toURI()) + File.separator + "templates" + File.separator + "bim_templates.zip";
        }
        catch (Exception e) {
            LogTool.logError("\u83b7\u53d6\u4e1a\u52a1\u6a21\u677f\u6587\u4ef6\u5931\u8d25", e);
            return "";
        }
    }

    public static XMLLoader getXMLLoader(Context ctx) {
        if (ctx.get((Object)"DEVMETADATALOADER") != null && ctx.get((Object)"DEVMETADATALOADER") instanceof IDevMetadataLoader) {
            IDevMetadataLoader loader = (IDevMetadataLoader)ctx.get((Object)"DEVMETADATALOADER");
            return loader.getMetametaLoader();
        }
        try {
            return XMLAccessEngine.getXMLLoader((Context)ctx);
        }
        catch (DataAccessException e) {
            LogTool.logError("XMLAccessEngine.getXMLLoader(ctx) failure", e);
            return null;
        }
    }
}

