/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.config;

import com.kingdee.bos.tool.ToolCommonPlugin;
import com.kingdee.bos.tool.config.ActionExtendPropertyInfo;
import com.kingdee.bos.tool.config.StatusItem;
import com.kingdee.bos.tool.config.Theme;
import com.kingdee.bos.tool.config.UIExtendPropertyInfo;
import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.util.SAXBuilderFactory;
import com.kingdee.util.StringUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ConfigManager {
    private String configFile = "ToolConfig.xml";
    private static ConfigManager instance;
    private static final String STATUSES = "statuses";
    private static final String STATUS = "status";
    private static final String NAME = "name";
    private static final String ALIAS = "alias";
    private static final String DESCRIPTION = "description";
    private static final String ACTIONS = "actions";
    private static final String ACTION = "action";
    private static final String ACTION_KEY = "key";
    private static final String ACTION_VALUE = "value";
    private static final String ACTION_ALIAS = "alias";
    private static final String ACTION_DESCRIPTION = "description";
    private static final String SERVICES = "services";
    private static final String SERVICE = "service";
    private static final String CLASS = "class";
    private static final String COMPULSORY = "compulsory";
    private static final String DEFAULTSELECTED = "defaultselected";
    private static final String TYPE = "type";
    private static final String THEMES = "themes";
    private static final String THEME = "theme";
    private static final String RESOURCE = "resource";
    private static final String DEFAULT = "default";
    private static SAXBuilder sb;
    private static final Logger logger;
    private Vector statusesVector = new Vector();
    private Vector actionExtPropVector = new Vector();
    private Vector serviceVector = new Vector();
    private Vector themeVector = new Vector();
    private Vector uiExtPropVector = new Vector();

    private ConfigManager() {
        this.init();
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public StatusItem[] getStatusItems() {
        return this.statusesVector.toArray(new StatusItem[this.statusesVector.size()]);
    }

    public UIExtendPropertyInfo[] getUIExtProps() {
        return this.uiExtPropVector.toArray(new UIExtendPropertyInfo[this.uiExtPropVector.size()]);
    }

    public ActionExtendPropertyInfo[] getActionExtProps() {
        return this.actionExtPropVector.toArray(new ActionExtendPropertyInfo[this.actionExtPropVector.size()]);
    }

    public ServiceItem[] getServiceItems(String type) {
        ArrayList<ServiceItem> list = new ArrayList<ServiceItem>();
        for (ServiceItem item : this.serviceVector) {
            if (!item.getType().equals(type)) continue;
            list.add(item);
        }
        return list.toArray(new ServiceItem[list.size()]);
    }

    public ServiceItem[] getServiceItems() {
        return this.getServiceItems("gui");
    }

    public ServiceItem[] getCompulsoryServiceItems(String type) {
        Iterator iter = this.serviceVector.iterator();
        ArrayList<ServiceItem> ret = new ArrayList<ServiceItem>();
        while (iter.hasNext()) {
            ServiceItem item = (ServiceItem)iter.next();
            if (!item.isCompulsory() || !item.getType().equals(type)) continue;
            ret.add(item);
        }
        return ret.toArray(new ServiceItem[ret.size()]);
    }

    public ServiceItem[] getCompulsoryServiceItems() {
        return this.getCompulsoryServiceItems("gui");
    }

    public ServiceItem[] getDefaultSelectedServiceItems(String type) {
        Iterator iter = this.serviceVector.iterator();
        ArrayList<ServiceItem> ret = new ArrayList<ServiceItem>();
        while (iter.hasNext()) {
            ServiceItem item = (ServiceItem)iter.next();
            if (item.isCompulsory() && item.getType().equals(type)) {
                ret.add(item);
                continue;
            }
            if (!item.isDefaultSelected() || !item.getType().equals(type)) continue;
            ret.add(item);
        }
        return ret.toArray(new ServiceItem[ret.size()]);
    }

    public ServiceItem[] getDefaultSelectedServiceItems() {
        return this.getDefaultSelectedServiceItems("gui");
    }

    public Theme[] getThemes() {
        return this.themeVector.toArray(new Theme[this.themeVector.size()]);
    }

    public Theme getDefaultTheme() {
        Theme t2 = null;
        for (Theme t2 : this.themeVector) {
            if (!t2.isDefaultTheme()) continue;
            return t2;
        }
        if (this.themeVector.size() > 0) {
            return (Theme)this.themeVector.get(0);
        }
        return null;
    }

    private void init() {
        Element root;
        try {
            URL url = ToolCommonPlugin.getPlugInURL(this.configFile);
            Document doc = sb.build(url.openStream());
            root = doc.getRootElement();
            if (root == null) {
                return;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
            return;
        }
        List children = root.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (STATUSES.equalsIgnoreCase(itemname)) {
                this.initStatuses(item);
                continue;
            }
            if (ACTIONS.equalsIgnoreCase(itemname)) {
                this.initActionExtProps(item);
                continue;
            }
            if (SERVICES.equalsIgnoreCase(itemname)) {
                this.initServices(item);
                continue;
            }
            if (THEMES.equalsIgnoreCase(itemname)) {
                this.initThemes(item);
                continue;
            }
            if (!"uiExtendProperties".equalsIgnoreCase(itemname)) continue;
            this.initUIExtProps(item);
        }
    }

    private void initThemes(Element themesRoot) {
        List children = themesRoot.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (!THEME.equalsIgnoreCase(itemname)) continue;
            this.initTheme(item);
        }
    }

    private void initTheme(Element themeElement) {
        List children = themeElement.getChildren();
        Iterator iter = children.iterator();
        Theme theme = new Theme();
        while (iter.hasNext()) {
            Element item = (Element)iter.next();
            String itemname = item.getName();
            if (NAME.equalsIgnoreCase(itemname)) {
                theme.setName(item.getTextTrim());
                continue;
            }
            if ("alias".equalsIgnoreCase(itemname)) {
                theme.setAlias(item.getTextTrim());
                continue;
            }
            if (RESOURCE.equalsIgnoreCase(itemname)) {
                theme.setResource(item.getTextTrim());
                continue;
            }
            if (!DEFAULT.equalsIgnoreCase(itemname)) continue;
            theme.setDefaultTheme(Boolean.valueOf(item.getTextTrim()));
        }
        if (children.size() > 0) {
            this.themeVector.add(theme);
        }
    }

    private void initStatuses(Element statusRoot) {
        List children = statusRoot.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (!STATUS.equalsIgnoreCase(itemname)) continue;
            this.initStatus(item);
        }
    }

    private void initStatus(Element statusElement) {
        List children = statusElement.getChildren();
        Iterator iter = children.iterator();
        StatusItem status = new StatusItem();
        while (iter.hasNext()) {
            Element item = (Element)iter.next();
            String itemname = item.getName();
            if (NAME.equalsIgnoreCase(itemname)) {
                status.setName(item.getTextTrim());
                continue;
            }
            if ("alias".equalsIgnoreCase(itemname)) {
                status.setAlias(item.getTextTrim());
                continue;
            }
            if (!"description".equalsIgnoreCase(itemname)) continue;
            status.setDescription(item.getTextTrim());
        }
        if (children.size() > 0) {
            this.statusesVector.add(status);
        }
    }

    private void initActionExtProps(Element actionsRoot) {
        List children = actionsRoot.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (!ACTION.equalsIgnoreCase(itemname)) continue;
            this.initActionExtProp(item);
        }
    }

    private void initUIExtProps(Element uisRoot) {
        List children = uisRoot.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (!"uiExtendProperty".equalsIgnoreCase(itemname)) continue;
            this.initUIExtProp(item);
        }
    }

    private void initActionExtProp(Element actionElement) {
        List children = actionElement.getChildren();
        Iterator iter = children.iterator();
        ActionExtendPropertyInfo extPropInfo = new ActionExtendPropertyInfo();
        while (iter.hasNext()) {
            Element item = (Element)iter.next();
            String itemname = item.getName();
            if (ACTION_KEY.equalsIgnoreCase(itemname)) {
                extPropInfo.setKey(item.getTextTrim());
                continue;
            }
            if (ACTION_VALUE.equalsIgnoreCase(itemname)) {
                extPropInfo.setValue(item.getTextTrim());
                continue;
            }
            if ("description".equalsIgnoreCase(itemname)) {
                extPropInfo.setDescription(item.getTextTrim());
                continue;
            }
            if (!"alias".equalsIgnoreCase(itemname)) continue;
            extPropInfo.setAlias(item.getTextTrim());
        }
        if (children.size() > 0 && !StringUtils.isEmpty((String)extPropInfo.getKey())) {
            this.actionExtPropVector.add(extPropInfo);
        }
    }

    private void initUIExtProp(Element uiElement) {
        List children = uiElement.getChildren();
        Iterator iter = children.iterator();
        UIExtendPropertyInfo extPropInfo = new UIExtendPropertyInfo();
        while (iter.hasNext()) {
            Element item = (Element)iter.next();
            String itemname = item.getName();
            if (ACTION_KEY.equalsIgnoreCase(itemname)) {
                extPropInfo.setKey(item.getTextTrim());
                continue;
            }
            if (ACTION_VALUE.equalsIgnoreCase(itemname)) {
                extPropInfo.setValue(item.getTextTrim());
                continue;
            }
            if ("description".equalsIgnoreCase(itemname)) {
                extPropInfo.setDescription(item.getTextTrim());
                continue;
            }
            if (!"alias".equalsIgnoreCase(itemname)) continue;
            extPropInfo.setAlias(item.getTextTrim());
        }
        if (children.size() > 0 && !StringUtils.isEmpty((String)extPropInfo.getKey())) {
            this.uiExtPropVector.add(extPropInfo);
        }
    }

    private void initServices(Element servicesRoot) {
        List children = servicesRoot.getChildren();
        for (Element item : children) {
            String itemname = item.getName();
            if (!SERVICE.equalsIgnoreCase(itemname)) continue;
            this.initService(item);
        }
    }

    private void initService(Element serviceElement) {
        List children = serviceElement.getChildren();
        Iterator iter = children.iterator();
        ServiceItem service = new ServiceItem();
        while (iter.hasNext()) {
            Element item = (Element)iter.next();
            String itemname = item.getName();
            if (NAME.equalsIgnoreCase(itemname)) {
                service.setName(item.getTextTrim());
                continue;
            }
            if ("alias".equalsIgnoreCase(itemname)) {
                service.setAlias(item.getTextTrim());
                continue;
            }
            if ("description".equalsIgnoreCase(itemname)) {
                service.setDescription(item.getTextTrim());
                continue;
            }
            if (CLASS.equalsIgnoreCase(itemname)) {
                service.setServiceClass(item.getTextTrim());
                continue;
            }
            if (COMPULSORY.equalsIgnoreCase(itemname)) {
                service.setCompulsory(Boolean.valueOf(item.getTextTrim()).booleanValue());
                continue;
            }
            if (DEFAULTSELECTED.equalsIgnoreCase(itemname)) {
                service.setDefaultSelected(Boolean.valueOf(item.getTextTrim()).booleanValue());
                continue;
            }
            if (!TYPE.equalsIgnoreCase(itemname)) continue;
            service.setType(item.getTextTrim());
        }
        if (children.size() > 0) {
            if (service.isCompulsory()) {
                service.setDefaultSelected(true);
            }
            this.serviceVector.add(service);
        }
    }

    static {
        sb = SAXBuilderFactory.create();
        logger = Logger.getLogger((String)"com.kingdee.bos.tool.config.ConfigManager");
    }
}

