/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.connection;

import com.kingdee.bos.tool.connection.IConnection;
import com.kingdee.bos.tool.connection.IGroup;
import com.kingdee.bos.tool.connection.Property;
import com.kingdee.bos.tool.properties.BooleanPropertyDescriptor;
import com.kingdee.bos.tool.properties.EnumeratePropertyDescriptor;
import com.kingdee.bos.tool.properties.IntegerPropertyDescriptor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConnectionProxy
implements IPropertySource {
    private IConnection connection;
    private IGroup group;

    public ConnectionProxy(IConnection connection, IGroup group) {
        this.connection = connection;
        this.group = group;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        int length = this.group.getProperties().length;
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[length];
        for (int i = 0; i < length; ++i) {
            Property prop = this.group.getProperties()[i];
            String id = prop.getId();
            String name = prop.getName();
            if (prop.getType().equalsIgnoreCase("int")) {
                descriptors[i] = new IntegerPropertyDescriptor((Object)id, name);
                continue;
            }
            if (prop.getType().equalsIgnoreCase("string")) {
                descriptors[i] = new TextPropertyDescriptor((Object)id, name);
                continue;
            }
            if (prop.getType().equalsIgnoreCase("boolean")) {
                descriptors[i] = new BooleanPropertyDescriptor((Object)id, name);
                continue;
            }
            String type = prop.getType();
            StringTokenizer token = new StringTokenizer(type, ",");
            ArrayList<String> list = new ArrayList<String>();
            while (token.hasMoreElements()) {
                list.add(token.nextToken());
            }
            descriptors[i] = new EnumeratePropertyDescriptor((Object)id, name, list);
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.group.getProperties().length; ++i) {
            Property prop = this.group.getProperties()[i];
            list.add(prop.getId());
        }
        if (!list.contains(id)) {
            return null;
        }
        return this.connection.getValue((String)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        Hashtable<String, Property> hs = new Hashtable<String, Property>();
        for (int i = 0; i < this.group.getProperties().length; ++i) {
            Property prop = this.group.getProperties()[i];
            hs.put(prop.getId(), prop);
        }
        if (!hs.containsKey(id)) {
            return;
        }
        this.connection.setValue((String)id, value);
    }
}

