/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleDAOUtil {
    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        String sql = "Select TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME = ?";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, tableName.toUpperCase());
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            return null;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        AbstractTableInfo table = new AbstractTableInfo();
        table.setName(tableName);
        OracleDAOUtil.fillColumnInfo(cn, table);
        OracleDAOUtil.fillPKInfo(cn, table);
        OracleDAOUtil.fillIndexInfo(cn, table);
        OracleDAOUtil.fillFKInfo(cn, table);
        return table;
    }

    private static void fillColumnInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase();
        String sql = "SELECT * FROM USER_TAB_COLUMNS WHERE TABLE_NAME=?";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, tableName.toUpperCase());
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ColumnInfo col = new ColumnInfo();
            col.setName(rs.getString("COLUMN_NAME"));
            String typeName = rs.getString("DATA_TYPE");
            if (typeName.equals("NUMBER") && rs.getInt("DATA_SCALE") == 0) {
                typeName = "LONG";
            }
            SQLType dataType = OracleDAOUtil.getSQLType(typeName);
            col.setTypeName(dataType);
            String strDef = rs.getString("DATA_DEFAULT");
            if ("null".equalsIgnoreCase(strDef)) {
                strDef = null;
            }
            if (strDef != null && strDef.length() != 0 && (strDef = strDef.trim()).startsWith("( ") && strDef.endsWith(" )")) {
                strDef = "(" + strDef.substring(2, strDef.length() - 4).trim() + ")";
            }
            col.setDefaultValue(strDef);
            int length = rs.getInt("DATA_LENGTH");
            if (typeName.equals("NVARCHAR2") || typeName.equals("NCHAR") || typeName.equals("NCLOB")) {
                length = rs.getInt("CHAR_LENGTH");
            }
            col.setLength(length);
            col.setNullable(rs.getString("NULLABLE").equals("Y"));
            col.setPrecision(rs.getInt("DATA_PRECISION"));
            col.setScale(rs.getInt("DATA_SCALE"));
            table.getColumns().add(col);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillPKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase();
        String sql = "/*dialect*/ select oc.name as \"CONSTRAINT_NAME\", o.name as \"TABLE_NAME\", \tdecode(ac.name, null, col.name, ac.name) as \"COLUMN_NAME\", cc.pos# as \"POSITION\" from sys.con$ oc, sys.col$ col, sys.ccol$ cc, sys.cdef$ c,   \tsys.obj$ o, sys.attrcol$ ac where oc.con# = c.con#  \tand c.type# = 2  \tand c.con# = cc.con#  \tand cc.obj# = col.obj#  \tand cc.intcol# = col.intcol#  \tand cc.obj# = o.obj#  \tand oc.owner# = userenv('SCHEMAID')  \tand col.obj# = ac.obj#(+)  \tand col.intcol# = ac.intcol#(+)  \tand o.name = '" + tableName + "' order by cc.pos# ";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            PrimaryKeyInfo pk = new PrimaryKeyInfo();
            pk.setName(rs.getString("CONSTRAINT_NAME"));
            table.setPrimaryKey(pk);
            ColumnInfo col = DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME"));
            PKColumnInfo pkcol = new PKColumnInfo();
            pkcol.setColumn(col);
            pk.getPKColumns().add(pkcol);
            while (rs.next()) {
                col = DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME"));
                pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillIndexInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase();
        String sql = "SELECT INDEX_NAME,UNIQUENESS,INDEX_TYPE FROM USER_INDEXES WHERE INDEX_TYPE<>'LOB' AND TABLE_NAME=?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = new IndexInfo();
            index.setName(rs.getString("INDEX_NAME"));
            index.setUnique(rs.getString("UNIQUENESS").equals("UNIQUE"));
            sql = "SELECT col.column_name COLUMN_NAME,col.descend DESCEND,exp.column_expression EXPRESSION FROM USER_IND_COLUMNS col LEFT OUTER JOIN user_ind_expressions exp ON col.table_name = exp.table_name AND col.index_name = exp.index_name AND col.column_position = exp.column_position WHERE col.table_name = ? AND col.index_name =?";
            PreparedStatement substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{tableName, index.getName().toUpperCase()});
            ResultSet subrs = substmt.executeQuery();
            while (subrs.next()) {
                IndexColumnInfo indexColumn = new IndexColumnInfo();
                String name = subrs.getString("COLUMN_NAME");
                if (name.startsWith("SYS_NC")) {
                    name = subrs.getString("EXPRESSION").replaceAll("\"", "");
                }
                ColumnInfo colInfo = new ColumnInfo();
                colInfo.setName(name);
                indexColumn.setColumn(colInfo);
                if (subrs.getString("DESCEND").equals("DESC")) {
                    indexColumn.setSortType(SortType.DESCEND);
                }
                index.getIndexColumns().add(indexColumn);
            }
            sql = "SELECT 1 FROM USER_CONSTRAINTS WHERE CONSTRAINT_NAME = ? AND TABLE_NAME = ?";
            substmt = DBUtils.createPreparedStatement(cn, sql, new String[]{index.getName(), tableName});
            subrs = substmt.executeQuery();
            if (subrs.next()) {
                index.setExtendedProperty("HAS_CONSTRAINT", index.getName());
            }
            SQLUtils.cleanup((ResultSet)subrs, (Statement)substmt);
            table.getIndexes().add(index);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillFKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase();
        String sql = "/*dialect*/select oc.name as \"CONSTRAINT_NAME\"\r\n       ,o.name as \"TABLE_NAME\"\r\n      ,decode(ac.name, null, col.name, ac.name) as \"COLUMN_NAME\"\r\n      ,rc.name as \"R_CONSTRAINT_NAME\"\r\n      ,o1.name as \"R_TABLE_NAME\"\r\n      ,decode(ac1.name, null, col1.name, ac1.name) as \"R_COLUMN_NAME\"\r\nfrom sys.con$ oc, sys.con$ rc, sys.obj$ o, sys.cdef$ c\r\n    ,sys.obj$ o1,sys.cdef$ c1, sys.col$ col, sys.ccol$ cc\r\n     ,sys.attrcol$ ac, sys.col$ col1, sys.ccol$ cc1,sys.attrcol$ ac1\r\n    \r\nwhere oc.con# = c.con#\r\n  and c.obj# = o.obj#\r\n  and c.rcon# = rc.con#(+)\r\n  and o.owner# = userenv('SCHEMAID')\r\n  and c.type#=4\r\n  and rc.con# =c1.con#\r\n  and c1.obj# = o1.obj#  \r\n  and c1.type#=2\r\n  and c.con# = cc.con#\r\n  and cc.obj# = col.obj#\r\n  and cc.intcol# = col.intcol#\r\n  and cc.obj# = o.obj#\r\n  and oc.owner# = userenv('SCHEMAID')\r\n  and col.obj# = ac.obj#(+)\r\n  and col.intcol# = ac.intcol#(+)  \r\n  and cc.pos# = cc1.pos#  \r\n  and c1.con# = cc1.con#\r\n  and cc1.obj# = col1.obj#\r\n  and cc1.intcol# = col1.intcol#\r\n  and cc1.obj# = o1.obj#\r\n  and rc.owner# = userenv('SCHEMAID')\r\n  and col1.obj# = ac1.obj#(+)\r\n  and col1.intcol# = ac1.intcol#(+)\r\n  and o.name = '" + tableName.toUpperCase() + "'";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
        ResultSet rs = stmt.executeQuery();
        ForeignKeyInfo prevFK = null;
        while (rs.next()) {
            String fkName = rs.getString("CONSTRAINT_NAME");
            FKColumnPairInfo fkcol = new FKColumnPairInfo();
            fkcol.setForeignKeyColumn(DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME")));
            ColumnInfo pkcolumn = new ColumnInfo();
            pkcolumn.setName(rs.getString("R_COLUMN_NAME"));
            fkcol.setPrimaryKeyColumn(pkcolumn);
            if (prevFK != null && prevFK.getName().equals(fkName)) {
                prevFK.getFKColumnPairs().add(fkcol);
                continue;
            }
            prevFK = new ForeignKeyInfo();
            AbstractTableInfo refTable = new AbstractTableInfo();
            refTable.setName(rs.getString("R_TABLE_NAME"));
            prevFK.setRefTable(refTable);
            prevFK.setName(fkName);
            prevFK.getFKColumnPairs().add(fkcol);
            table.getForeignKeys().add(prevFK);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("VARCHAR2")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("NVARCHAR2")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("NUMBER")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("LONG")) {
            return SQLType.INT;
        }
        if (typeName.equals("DATE")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("TIMESTAMP(6)")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("CHAR")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("NCHAR")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("CLOB")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("NCLOB")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BLOB")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("RAW")) {
            return SQLType.BINARY;
        }
        if (typeName.equals("LONG RAW")) {
            return SQLType.VARBINARY;
        }
        LogTool.logError("Unknown SQL TYPE:" + typeName + ", Treat as NVARCHAR", new Exception("Unknown SQL TYPE"));
        return SQLType.NVARCHAR;
    }

    public static void adjustTables(Connection cn, AbstractTableInfo[] tables) throws SQLException {
        for (int i = 0; i < tables.length; ++i) {
            OracleDAOUtil.adjustTable(cn, tables[i]);
        }
    }

    public static void adjustTable(Connection cn, AbstractTableInfo table) throws SQLException {
    }
}

