/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.multipageeditor;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.multipageeditor.IMDSourceEditor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dialog.SelectMetaDataDialog;
import com.kingdee.bos.tool.multipageeditor.ExceptionHandler;
import com.kingdee.bos.tool.multipageeditor.IObjectValueBindedListener;
import com.kingdee.bos.tool.multipageeditor.IObjectValueContainer;
import com.kingdee.bos.tool.multipageeditor.IObjectValueValidator;
import com.kingdee.bos.tool.multipageeditor.Messages;
import com.kingdee.bos.tool.multipageeditor.ObjectValueBindedEvent;
import com.kingdee.bos.tool.utils.CheckUtils;
import com.kingdee.bos.tool.widgets.HrefText;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ObjectValueBindedItem {
    private Text text;
    private HrefText hrefText;
    private Button btn;
    private IObjectValueContainer container;
    private String key;
    private BOSObjectType type;
    private FocusAdapter focusListener = new InnerFocusListener();
    private SelectionAdapter selectionListener = new InnerSelectionAdapter();
    private IObjectValueValidator validator;
    private String defaultPackagePath;
    boolean readonly;
    private IMDSourceEditor editor;
    private List listeners = new ArrayList();

    public ObjectValueBindedItem(Text text, Button btn, boolean readonly) {
        this.text = text;
        this.btn = btn;
        this.readonly = readonly;
    }

    public ObjectValueBindedItem(HrefText text, Button btn, boolean readonly) {
        this.hrefText = text;
        this.btn = btn;
        this.readonly = readonly;
    }

    public void bind(IObjectValueContainer container, String key, BOSObjectType type) {
        this.container = container;
        this.key = key;
        this.type = type;
        if (this.text != null) {
            this.text.addFocusListener((FocusListener)this.focusListener);
        } else if (this.hrefText != null) {
            this.hrefText.addFocusListener((FocusListener)this.focusListener);
        }
        this.btn.addSelectionListener((SelectionListener)this.selectionListener);
        if (this.readonly) {
            if (this.text != null) {
                this.text.setEnabled(false);
            } else if (this.hrefText != null) {
                this.hrefText.setEnabled(false);
            }
        }
    }

    public void refreshControl() {
        if (this.container == null || this.container.getObjectValue() == null) {
            if (this.text != null) {
                this.text.setText("");
            } else if (this.hrefText != null) {
                this.hrefText.setText("");
                this.hrefText.setHref(null);
            }
        } else {
            IObjectValue newModel = (IObjectValue)this.container.getObjectValue().get(this.key);
            this.setTextLabel(newModel);
        }
    }

    protected void textFocusLost(FocusEvent e) {
        boolean result;
        ObjectValueBindedEvent event;
        IObjectValue newModel;
        block18: {
            if (this.container.getObjectValue() == null) {
                return;
            }
            String newModelFullName = null;
            if (this.text != null) {
                newModelFullName = this.text.getText().trim();
            } else if (this.hrefText != null) {
                newModelFullName = this.hrefText.getText().trim();
            }
            IObjectValue oldModel = (IObjectValue)this.container.getObjectValue().get(this.key);
            String oldModelFullName = this.getFullName(oldModel);
            if (StringUtils.isEmpty((String)newModelFullName) && oldModel != null) {
                this.container.getObjectValue().remove(this.key);
                if (this.editor != null) {
                    this.editor.setModify(true);
                    this.editor.setNeedSync(true);
                }
                if (this.hrefText != null) {
                    this.hrefText.setHref(null);
                }
                return;
            }
            if (newModelFullName.equals(oldModelFullName)) {
                return;
            }
            String packageName = MetaDataUtils.getPackageName((String)newModelFullName);
            String metadataName = MetaDataUtils.getClassName((String)newModelFullName);
            if (!CheckUtils.isValidPackageName(packageName) || !CheckUtils.isValidMetaDataName(metadataName)) {
                MessageDialog m = new MessageDialog(this.btn.getShell(), "", null, Messages.ObjectValueBindedItem_FeiFaDeZiFuShuRu, 1, new String[]{Messages.ObjectValueBindedItem_QueDing}, 0);
                m.create();
                m.open();
                this.setTextLabel(oldModel);
                return;
            }
            newModel = null;
            if (Utils.createInfo((BOSObjectType)this.type) == null) {
                MessageDialog m = new MessageDialog(this.btn.getShell(), "", null, Messages.ObjectValueBindedItem_SuoShuRuDeDuiXiangBuCunZaiNinQueRenYaoZheYangMa, 1, new String[]{Messages.ObjectValueBindedItem_QueDing}, 0);
                m.create();
                m.open();
                return;
            }
            IMDFile file = MDResourceUtil.getFile(this.editor.getMDProject(), newModelFullName, this.type);
            event = new ObjectValueBindedEvent(this);
            event.setFile(file);
            this.fireListener_beforeLoad(event);
            if (!event.continueLoad) {
                newModel = event.getModel();
            } else {
                try {
                    newModel = MDORMUtil.load(file);
                }
                catch (MDNotFoundException e1) {
                    LogTool.logError(e1.getMessage(), null);
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    String title = Messages.ObjectValueBindedItem_QueRen;
                    String message = Messages.ObjectValueBindedItem_NiShuRuDeDuiXiangBuCunZaiNinQueRenYaoZheYangMa + "[" + file.getPath() + "]";
                    boolean result2 = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                    if (result2) break block18;
                    this.setTextLabel(oldModel);
                    return;
                }
            }
        }
        if (newModel == null) {
            return;
        }
        event.setModel(newModel);
        event.setContinueLoad(true);
        this.fireListener_afterLoad(event);
        if (this.validator != null && !(result = this.validator.validate(newModel))) {
            MessageDialog m = new MessageDialog(this.btn.getShell(), "", null, this.validator.getMessage(), this.validator.getMessageType(), new String[]{Messages.ObjectValueBindedItem_QueDing}, 0);
            m.create();
            m.open();
            this.setTextLabel(null);
            return;
        }
        this.container.getObjectValue().put(this.key, (Object)newModel);
        if (this.hrefText != null) {
            this.hrefText.setHref(this.getHrefString(this.hrefText.getText()));
        }
        if (this.editor != null) {
            this.editor.setModify(true);
            this.editor.setNeedSync(true);
        }
    }

    private void setTextLabel(IObjectValue model) {
        if (model == null) {
            if (this.text != null) {
                this.text.setText("");
            } else if (this.hrefText != null) {
                this.hrefText.setText("");
                this.hrefText.setHref(null);
            }
        } else if (this.text != null) {
            this.text.setText(this.getFullName(model));
        } else if (this.hrefText != null) {
            this.hrefText.setText(this.getFullName(model));
            this.hrefText.setHref(this.getHrefString(this.getFullName(model)));
        }
    }

    protected void btnSelected(SelectionEvent e) {
        try {
            IMDFile file;
            String[] suffixes = new String[]{Utils.getMetaDataSuffix((BOSObjectType)this.type).substring(1)};
            SelectMetaDataDialog dialog = new SelectMetaDataDialog(this.btn.getShell(), suffixes, (IMDObject)this.getEditor().getMDProject());
            dialog.create();
            if (0 == dialog.open() && (file = dialog.getSelectedFile()) != null && file.exists()) {
                boolean result;
                ObjectValueBindedEvent event = new ObjectValueBindedEvent(this);
                event.setFile(file);
                this.fireListener_beforeLoad(event);
                IObjectValue newModel = null;
                newModel = !event.continueLoad ? event.getModel() : MDORMUtil.load(file);
                event.setModel(newModel);
                event.continueLoad = true;
                this.fireListener_afterLoad(event);
                if (!event.isContinueLoad()) {
                    return;
                }
                if (this.validator != null && !(result = this.validator.validate(newModel))) {
                    MessageDialog m = new MessageDialog(this.btn.getShell(), "", null, this.validator.getMessage(), this.validator.getMessageType(), new String[]{Messages.ObjectValueBindedItem_QueDing}, 0);
                    m.create();
                    m.open();
                    return;
                }
                if (this.container.getObjectValue() != null) {
                    this.container.getObjectValue().put(this.key, (Object)newModel);
                    this.setTextLabel(newModel);
                    if (this.editor != null) {
                        this.editor.setModify(true);
                        this.editor.setNeedSync(true);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionHandler.showException(ex);
        }
    }

    public IObjectValueValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IObjectValueValidator validator) {
        this.validator = validator;
    }

    public IMDSourceEditor getEditor() {
        return this.editor;
    }

    public void setEditor(IMDSourceEditor editor) {
        this.editor = editor;
    }

    public String getDefaultPackagePath() {
        return this.defaultPackagePath;
    }

    public void setDefaultPackagePath(String string) {
        this.defaultPackagePath = string;
    }

    public void addListener(IObjectValueBindedListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(IObjectValueBindedListener listener) {
        return this.listeners.remove(listener);
    }

    private void fireListener_beforeLoad(ObjectValueBindedEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IObjectValueBindedListener listener = (IObjectValueBindedListener)this.listeners.get(i);
            listener.beforeLoad(event);
        }
    }

    private void fireListener_afterLoad(ObjectValueBindedEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IObjectValueBindedListener listener = (IObjectValueBindedListener)this.listeners.get(i);
            listener.afterLoad(event);
        }
    }

    private String getFullName(IObjectValue ov) {
        if (ov == null) {
            return "";
        }
        String packageName = ov.getString("package");
        String name = ov.getString("name");
        if (!StringUtils.isEmpty((String)packageName)) {
            name = packageName + "." + name;
        }
        return name;
    }

    public BOSObjectType getType() {
        return this.type;
    }

    public void setType(BOSObjectType type) {
        this.type = type;
    }

    public String getHrefString(String modelName) {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)modelName);
        return MDResourceUtil.getFile(this.editor.getMDProject(), pk, this.type).toFile().getAbsolutePath();
    }

    public String getKey() {
        return this.key;
    }

    public Button getBtn() {
        return this.btn;
    }

    public HrefText getHrefText() {
        return this.hrefText;
    }

    public Text getText() {
        return this.text;
    }

    private class InnerSelectionAdapter
    extends SelectionAdapter {
        private InnerSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            ObjectValueBindedItem.this.btnSelected(e);
        }
    }

    private class InnerFocusListener
    extends FocusAdapter {
        private InnerFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            ObjectValueBindedItem.this.textFocusLost(e);
        }
    }
}

