/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.views;

import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class ResourceContentProvider
implements ITreeContentProvider,
IResourceChangeListener {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected Viewer viewer;

    public void dispose() {
        if (this.viewer != null) {
            Object obj = this.viewer.getInput();
            IWorkspace workspace = null;
            if (obj instanceof IWorkspace) {
                workspace = (IWorkspace)obj;
            } else if (obj instanceof IContainer) {
                workspace = ((IContainer)obj).getWorkspace();
            }
            if (workspace != null) {
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
        }
    }

    protected IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MDObjectAdapter && ((MDObjectAdapter)element).getModel() instanceof IMDProject) {
            return true;
        }
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        IWorkspace oldWorkspace = null;
        IWorkspace newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = (IWorkspace)oldInput;
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = ((IContainer)oldInput).getWorkspace();
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = (IWorkspace)newInput;
        } else if (newInput instanceof IContainer) {
            newWorkspace = ((IContainer)newInput).getWorkspace();
        }
        if (oldWorkspace != newWorkspace) {
            if (oldWorkspace != null) {
                oldWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newWorkspace != null) {
                newWorkspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }
    }

    protected void processDelta(IResourceDelta delta) {
        int i;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        for (int i2 = 0; i2 < affectedChildren.length; ++i2) {
            if ((affectedChildren[i2].getFlags() & 0x8000) == 0 && !(affectedChildren[i2].getResource() instanceof IProject)) continue;
            ((StructuredViewer)this.viewer).refresh((Object)resource);
            return;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x14000) != 0) {
            ((StructuredViewer)this.viewer).update((Object)resource, null);
        }
        if ((changeFlags & 0x40000) != 0) {
            ((StructuredViewer)this.viewer).refresh((Object)resource, true);
            return;
        }
        for (int i3 = 0; i3 < affectedChildren.length; ++i3) {
            this.processDelta(affectedChildren[i3]);
        }
        affectedChildren = delta.getAffectedChildren(2);
        if (affectedChildren.length > 0) {
            Object[] affected = new Object[affectedChildren.length];
            for (i = 0; i < affectedChildren.length; ++i) {
                affected[i] = affectedChildren[i].getResource();
            }
            if (this.viewer instanceof AbstractTreeViewer) {
                ((AbstractTreeViewer)this.viewer).remove(affected);
            } else {
                ((StructuredViewer)this.viewer).refresh((Object)resource);
            }
        }
        if ((affectedChildren = delta.getAffectedChildren(1)).length > 0) {
            Object[] affected = new Object[affectedChildren.length];
            for (i = 0; i < affectedChildren.length; ++i) {
                affected[i] = affectedChildren[i].getResource();
            }
            ((StructuredViewer)this.viewer).refresh((Object)resource);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final IResourceDelta delta = event.getDelta();
        Control ctrl = this.viewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ResourceContentProvider.this.viewer.getControl().setRedraw(false);
                    ResourceContentProvider.this.processDelta(delta);
                    ResourceContentProvider.this.viewer.getControl().setRedraw(true);
                }
            });
        }
    }
}

