/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.widgets;

import com.kingdee.bos.metadata.management.JdbcDriverType;
import com.kingdee.bos.tool.connection.DBConnection;
import com.kingdee.bos.tool.widgets.Messages;
import com.kingdee.util.StringUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class DataSourcePanel
extends Composite {
    private Text fHost;
    private Text fPort;
    private Text fDBName;
    private Text fUser;
    private Text fPassw;
    private Button btn_Test;
    private Combo driverType;
    private DBConnection model;

    public DataSourcePanel(Composite parent, int style) {
        super(parent, style);
        this.layoutTab();
    }

    public DBConnection getModel() {
        return this.model;
    }

    public void setModel(DBConnection model) {
        this.model = model;
        this.init();
    }

    private void layoutTab() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 6;
        layout.horizontalSpacing = 10;
        layout.marginHeight = 15;
        this.setLayout((Layout)layout);
        new Label((Composite)this, 0).setText("JDBC Driver:");
        this.driverType = new Combo((Composite)this, 2056);
        this.driverType.setItems(new String[]{JdbcDriverType.MS_SQL_SERVER_DRIVER.getName(), JdbcDriverType.ORACLE_THIN_DRIVER.getName(), JdbcDriverType.IBM_DB2_NET_DRIVER.getName()});
        this.driverType.setLayoutData((Object)new GridData(768));
        this.driverType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource().equals(DataSourcePanel.this.driverType)) {
                    DataSourcePanel.this.model.setValue("jdbcdrivertype", JdbcDriverType.getEnum((String)DataSourcePanel.this.driverType.getText()));
                    return;
                }
            }
        });
        new Label((Composite)this, 0).setText(Messages.DataSourcePanel_ZhuJiMing);
        this.fHost = new Text((Composite)this, 2048);
        this.fHost.setLayoutData((Object)new GridData(256));
        new Label((Composite)this, 0).setText(Messages.DataSourcePanel_DuanKouMing);
        this.fPort = new Text((Composite)this, 2048);
        this.fPort.setLayoutData((Object)new GridData(256));
        new Label((Composite)this, 0).setText(Messages.DataSourcePanel_ShuJuKuMing);
        this.fDBName = new Text((Composite)this, 2048);
        this.fDBName.setLayoutData((Object)new GridData(256));
        new Label((Composite)this, 0).setText(Messages.DataSourcePanel_YongHuMing);
        this.fUser = new Text((Composite)this, 2048);
        this.fUser.setLayoutData((Object)new GridData(256));
        new Label((Composite)this, 0).setText(Messages.DataSourcePanel_KouLing);
        this.fPassw = new Text((Composite)this, 2048);
        this.fPassw.setEchoChar('*');
        this.fPassw.setLayoutData((Object)new GridData(256));
        Composite panel = new Composite((Composite)this, 0);
        GridData gd = new GridData(896);
        gd.horizontalSpan = 2;
        panel.setLayoutData((Object)gd);
        panel.setLayout((Layout)new GridLayout());
        this.layoutButtons(panel);
        TextModifyListener textModifyListener = new TextModifyListener();
        this.fHost.addModifyListener((ModifyListener)textModifyListener);
        this.fPort.addModifyListener((ModifyListener)textModifyListener);
        this.fDBName.addModifyListener((ModifyListener)textModifyListener);
        this.fUser.addModifyListener((ModifyListener)textModifyListener);
        this.fPassw.addModifyListener((ModifyListener)textModifyListener);
        this.btn_Test.addSelectionListener((SelectionListener)new ConnectionTestListener());
    }

    protected void layoutButtons(Composite parent) {
        this.btn_Test = new Button(parent, 8);
        this.btn_Test.setText(Messages.DataSourcePanel_CeShiLianJie);
        this.btn_Test.setLayoutData((Object)new GridData(128));
    }

    private void init() {
        JdbcDriverType type = null;
        Object obj = this.model.getValue("jdbcdrivertype");
        if (obj != null) {
            type = obj instanceof JdbcDriverType ? (JdbcDriverType)obj : JdbcDriverType.getEnum((String)obj.toString());
        }
        String host = (String)this.model.getValue("host");
        if (this.model.getValue("port") != null) {
            int port = (Integer)this.model.getValue("port");
            this.fPort.setText(String.valueOf(port));
        } else {
            this.fPort.setText("1433");
        }
        String db = (String)this.model.getValue("dbname");
        String user = (String)this.model.getValue("user");
        String password = (String)this.model.getValue("password");
        this.fHost.setText(host == null ? "127.0.0.1" : host);
        this.fDBName.setText(db == null ? "master" : db);
        this.fUser.setText(user == null ? "sa" : user);
        this.fPassw.setText(password == null ? "" : password);
        if (type == null) {
            this.driverType.select(0);
        } else if (type.equals((Object)JdbcDriverType.ORACLE_THIN_DRIVER)) {
            this.driverType.select(1);
        } else if (type.equals((Object)JdbcDriverType.IBM_DB2_NET_DRIVER)) {
            this.driverType.select(2);
        } else {
            this.driverType.select(0);
        }
    }

    protected void connectInfoChanged(ModifyEvent e) {
        if (e.getSource().equals(this.fHost)) {
            this.model.setValue("host", this.fHost.getText().trim());
        } else if (e.getSource().equals(this.fPort)) {
            if (!StringUtils.isEmpty((String)this.fPort.getText())) {
                this.model.setValue("port", new Integer(this.fPort.getText().trim()));
            }
        } else if (e.getSource().equals(this.fDBName)) {
            this.model.setValue("dbname", this.fDBName.getText().trim());
        } else if (e.getSource().equals(this.fUser)) {
            this.model.setValue("user", this.fUser.getText().trim());
        } else if (e.getSource().equals(this.fPassw)) {
            this.model.setValue("password", this.fPassw.getText());
        }
    }

    protected abstract void connectTest();

    private class ConnectionTestListener
    extends SelectionAdapter {
        private ConnectionTestListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            BusyIndicator.showWhile((Display)DataSourcePanel.this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    DataSourcePanel.this.connectTest();
                }
            });
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            DataSourcePanel.this.connectInfoChanged(e);
        }
    }
}

