/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.wizard;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.tool.check.VerifyOperator;
import com.kingdee.bos.tool.utils.CheckUtils;
import com.kingdee.bos.tool.wizard.AbstractMetaDataWizardPage;
import com.kingdee.bos.tool.wizard.Messages;
import com.kingdee.bos.tool.wizard.NewMetaDataWizard;
import com.kingdee.bos.util.BOSObjectType;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NewMetaDataWizardPage
extends AbstractMetaDataWizardPage {
    public NewMetaDataWizardPage(String title, String description) {
        super(title);
        assert (title != null);
        assert (description != null);
        this.setTitle(title);
        this.setDescription(description);
    }

    @Override
    protected void init() {
        super.init();
        NewMetaDataWizard wizard = (NewMetaDataWizard)this.getWizard();
        wizard.getModel().setPackage(this.currentPackage());
        this.addTextListener();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fName != null && visible) {
            this.fName.setFocus();
        }
    }

    public void createControl(Composite parent) {
        Composite container = this.layoutChildContainer(parent, 3);
        this.layoutPackage(container);
        this.layoutSeparator(container);
        this.layoutCommonData(container);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void addTextListener() {
        TextModifyListener listener = new TextModifyListener();
        if (this.fPKName != null) {
            this.fPKName.addModifyListener((ModifyListener)listener);
        }
        if (this.fName != null) {
            this.fName.addModifyListener((ModifyListener)listener);
        }
        if (this.fAlias != null) {
            this.fAlias.addModifyListener((ModifyListener)listener);
        }
        if (this.fDesc != null) {
            this.fDesc.addModifyListener((ModifyListener)listener);
        }
    }

    protected void inputIntoModel(ModifyEvent e) {
        NewMetaDataWizard wizard = (NewMetaDataWizard)this.getWizard();
        AbstractMetaDataValue model = wizard.getModel();
        if (e.getSource().equals(this.fName)) {
            model.setName(this.fName.getText().trim());
        } else if (e.getSource().equals(this.fPKName)) {
            model.setPackage(this.fPKName.getText().trim());
        } else if (e.getSource().equals(this.fAlias)) {
            model.setAlias(this.fAlias.getText().trim());
        } else if (e.getSource().equals(this.fDesc)) {
            model.setDescription(this.fDesc.getText().trim());
        }
    }

    protected void verify() {
        NewMetaDataWizard wizard = (NewMetaDataWizard)this.getWizard();
        AbstractMetaDataValue info = wizard.getModel();
        BOSObjectType type = info.getBOSType();
        if (!CheckUtils.isValidPackageName(info.getPackage())) {
            this.setErrorMsg(Messages.NewMetaDataWizardPage_BuHeFaDeBaoMing);
            return;
        }
        if (!CheckUtils.isValidMetaDataName(info.getName(), info.getBOSType())) {
            this.setErrorMsg(Messages.NewMetaDataWizardPage_BuHeFaDeMingCheng);
            return;
        }
        if (!new VerifyOperator(this.report).check((IObjectValue)info, 2)) {
            this.setErrorMsg(this.listener.getMessage());
            return;
        }
        if (CheckUtils.exist(this.getMDProject(), info.getPackage(), info.getName(), type)) {
            this.setErrorMsg(Messages.NewMetaDataWizardPage_CunZaiTongMingDeYuanShuJu);
            return;
        }
        this.setErrorMsg(null);
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            NewMetaDataWizardPage.this.inputIntoModel(e);
            NewMetaDataWizardPage.this.verify();
        }
    }
}

