/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.utils;

import com.kingdee.bos.utils.Filter;
import com.kingdee.bos.utils.GroupFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ListUtils {
    public static Filter<String> makeFilter(final String target) {
        return new Filter<String>(){

            @Override
            public boolean accept(String listData) {
                if (listData.indexOf("*") == -1) {
                    return listData.equals(target);
                }
                return target != null && target.matches(listData.replaceFirst("\\.\\*$", "\\\\.\\\\w+"));
            }
        };
    }

    public static <T> List<T> filter(List<T> list, Filter<T> filter) {
        return ListUtils._fillListData(list, filter, new ArrayList());
    }

    private static <T> List<T> _fillListData(List<T> list, Filter<T> filter, List<T> out) {
        for (T t : list) {
            if (!filter.accept(t)) continue;
            out.add(t);
        }
        return Collections.unmodifiableList(out);
    }

    public static <T> T findFirstMatchData(List<T> list, Filter<T> filter) {
        for (T t : list) {
            if (!filter.accept(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean contains(List<T> list, Filter<T> filter) {
        return ListUtils.findFirstMatchData(list, filter) != null;
    }

    public static <T, V> Map<T, List<V>> groupBy(List<V> list, GroupFunction<T> function) {
        HashMap map = new HashMap();
        for (V v : list) {
            T t = function.group(v);
            if (!map.containsKey(t)) {
                map.put(t, new ArrayList());
            }
            ((List)map.get(t)).add(v);
        }
        return map;
    }

    public static <T> boolean partMatch(List<T> list1, List<T> list2) {
        for (T obj1 : list1) {
            if (!list2.contains(obj1)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean partMatch(T[] array1, T[] array2) {
        for (T obj1 : array1) {
            for (T obj2 : array2) {
                if (!obj1.equals(obj2)) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("com.kingdee.*");
        list.add("com.kingdee.bos.app.a.ui");
        list.add("com.kingdee.bos.app.b.*");
        list.add("com.kingdee.bos.app.client.a.ui");
        list.add("com.kingdee.bos.app.client.b.*");
        List<String> result = ListUtils.filter(list, ListUtils.makeFilter("com.kingdee.bos.app.b.ui"));
        if (result.size() > 0) {
            System.out.println("find =" + result.get(0));
        }
        if ((result = ListUtils.filter(list, ListUtils.makeFilter("com.kingdee.bos.app.a.ui"))).size() > 0) {
            System.out.println("find =" + result.get(0));
        }
    }
}

