/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.statsa.syn;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.SAOperateFactory;
import com.kingdee.bos.workflow.metas.SAOperateInfo;
import com.kingdee.bos.workflow.metas.SAProcInstInfo;
import com.kingdee.bos.workflow.statsa.util.SAUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class SAOperateDATASync {
    private Context ctx;
    private static Logger log = Logger.getLogger(SAOperateDATASync.class);
    public static Set columnSet = null;

    public SAOperateDATASync(Context ctx) {
        this.ctx = ctx;
    }

    public static Set getColumns(IRowSet rowSet) throws SQLException {
        if (columnSet == null) {
            HashSet<String> set = new HashSet<String>();
            int columns = rowSet.getMetaData().getColumnCount();
            for (int index = 1; index <= columns; ++index) {
                String columnName = rowSet.getMetaData().getColumnName(index);
                if (columnName.indexOf("_") > 0) {
                    columnName = columnName.substring(0, columnName.indexOf("_"));
                }
                set.add(columnName.toUpperCase());
            }
            columnSet = set;
        }
        return columnSet;
    }

    public boolean synData(SAProcInstInfo tSAProcInstInfo) throws BOSException {
        String procInstId = tSAProcInstInfo.getProcInstID().toString();
        try {
            CoreBaseCollection tCoreCollection = new CoreBaseCollection();
            String language = LocaleUtils.getShortCode((Locale)this.ctx.getLocale());
            StringBuffer tSql = new StringBuffer();
            tSql.append(" select FOPINION_l1 FOption_l1,FOPINION_l2 FOption_l2,FOPINION_l3 FOption_l3 ,FBillID ,tochar(FTYPE) FTYPE,FPersonID ,FACTINSTID ,FResult ,FProcinstID ,  ");
            tSql.append(" FCreatorID ,FCreateTime ,FLastUpdateUserID ,FLastUpdateTime ,FControlUnitID ");
            tSql.append(" from t_bas_option where fprocinstid = '" + procInstId + "'  and ftype!=9 ");
            tSql.append(" union all   ");
            tSql.append(" select fcomment_l1 FOption_l1 ,fcomment_l2 FOption_l2 ,fcomment_l3 FOption_l3 ,FBillID ,FTYPE ,'' FPersonID,FACTINSTID,fcomment_" + language + " FResult,FProcinstID, ");
            tSql.append(" FCreatorID ,FCreateTime ,FCreatorID FLastUpdateUserID,FCreateTime FLastUpdateTime,'' FControlUnitID ");
            tSql.append(" from t_wfr_dynamicOp where fprocinstid = '" + procInstId + "' ");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)tSql.toString());
            while (rowSet.next()) {
                CoreBaseInfo coreBaseInfo = this.createSAOperateInfo(tSAProcInstInfo, rowSet);
                if (coreBaseInfo == null) continue;
                tCoreCollection.add(coreBaseInfo);
            }
            if (tCoreCollection.size() > 0) {
                this.distinct(tCoreCollection);
                SAOperateFactory.getLocalInstance((Context)this.ctx).addnewBatchData(tCoreCollection);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u540c\u6b65\u6d41\u7a0b\uff1a" + procInstId + "\u5bf9\u5e94\u7684\u64cd\u4f5c\u6570\u636e\u51fa\u9519"), (Throwable)e);
        }
        return true;
    }

    private CoreBaseInfo createSAOperateInfo(SAProcInstInfo tSAProcInstInfo, IRowSet rowSet) throws SQLException {
        SAOperateInfo tSAOperateInfo = new SAOperateInfo();
        SAUtil.setPropertyForRowSet(this.ctx, rowSet, SAOperateDATASync.getColumns(rowSet), (CoreBaseInfo)tSAOperateInfo, tSAOperateInfo.getBOSType());
        String type = rowSet.getString("FTYPE");
        if ("jumpRepair".equals(type) || "forcedAabort".equals(type)) {
            return null;
        }
        tSAOperateInfo.setType(this.coverType(type));
        tSAOperateInfo.setId(BOSUuid.create((BOSObjectType)tSAOperateInfo.getBOSType()));
        return tSAOperateInfo;
    }

    private OptionType coverType(String type) {
        try {
            if ("forward".equals(type)) {
                return OptionType.deliverAssignment;
            }
            if ("change-performers".equals(type)) {
                return OptionType.CHANGEPERFORMERS;
            }
            if ("kick-back".equals(type)) {
                return OptionType.kickBack;
            }
            if ("redirect".equals(type)) {
                return OptionType.jumpTo;
            }
            if ("add-performers".equals(type)) {
                return OptionType.ADDPERFORMERS;
            }
            if ("suspend".equals(type)) {
                return OptionType.SUSPEND;
            }
            if ("abort".equals(type)) {
                return OptionType.ABORT;
            }
            int IntType = Integer.parseInt(type);
            return OptionType.getEnum((int)IntType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void distinct(CoreBaseCollection tCoreCollection) {
        for (int index = 0; index < tCoreCollection.size(); ++index) {
            SAOperateInfo tISAOperateInfo = (SAOperateInfo)tCoreCollection.get(index);
            for (int j = tCoreCollection.size() - 1; j > index; --j) {
                SAOperateInfo tJSAOperateInfo = (SAOperateInfo)tCoreCollection.get(j);
                if (!this.isCommon(tISAOperateInfo, tJSAOperateInfo)) continue;
                tCoreCollection.remove((CoreBaseInfo)tJSAOperateInfo);
            }
        }
    }

    private boolean isCommon(SAOperateInfo m, SAOperateInfo n) {
        long time = 0L;
        time = m.getCreateTime().after(n.getCreateTime()) ? m.getCreateTime().getTime() - n.getCreateTime().getTime() : n.getCreateTime().getTime() - m.getCreateTime().getTime();
        return time <= 10000L;
    }
}

