/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.iservice.common.util.ServiceLocator;
import com.kingdee.portal.plt.iservice.module.service.dto.PersonalFavoriteDTO;
import com.kingdee.portal.plt.iservice.module.service.dto.ServRecDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceFavorite;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceFavoriteService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceInstanceService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public class MyServiceAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private ServiceFavoriteService serviceFavoriteService = (ServiceFavoriteService)ServiceLocator.getBean("serviceFavoriteService");
    private ServiceDefinitionService serviceDefinitionService = (ServiceDefinitionService)ServiceLocator.getBean("serviceDefinitionService");
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
    private ServiceInstanceService serviceInstanceService = (ServiceInstanceService)ServiceLocator.getBean("serviceInstanceService");
    private ServiceFavorite favorite;
    private ServiceDefinition definition;
    private String definitionId;
    private Map<String, Object> resultMap;
    private String insId;

    public String listRunningFavor() {
        try {
            List<ServRecDTO> list = this.serviceFavoriteService.listRunningFavor(this.getPortalContext());
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        return null;
    }

    public String findRunningFavorDetail() {
        try {
            String procInstId = this.getRequest().getParameter("procInstId");
            List<ServRecDTO> list = this.serviceFavoriteService.findRunningFavorDetail(this.getPortalContext(), procInstId);
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        return null;
    }

    public String showPortletFragment() {
        String portletName;
        String appName = StringUtil.convNull((String)this.getRequest().getParameter("appName"));
        if (!StringUtil.isEmpty((String)appName)) {
            this.getRequest().setAttribute("appName", (Object)appName);
        }
        if (!StringUtil.isEmpty((String)(portletName = StringUtil.convNull((String)this.getRequest().getParameter("portletName"))))) {
            this.getRequest().setAttribute("portletName", (Object)portletName);
        }
        return "success";
    }

    public String findEvaluationServices() {
        try {
            List<ServiceDefinition> list = this.serviceFavoriteService.findWaiteJudgeService(this.getPortalContext());
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
        return null;
    }

    public void findMyServiceTypes() {
        try {
            Map<String, Object> map = this.serviceFavoriteService.findMyServiceTypes(this.getPortalContext());
            List<PersonalFavoriteDTO> list = this.serviceFavoriteService.listPersonalFavorite(this.getPortalContext(), this.getPermMap());
            map.put("favList", list);
            this.writeAjaxData(true, null, map);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void findMyServiceList() {
        try {
            List<ServiceDefinition> list = this.serviceFavoriteService.findAllServiceByCategoryId(this.getPortalContext(), this.definition.getId());
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void findPersonalFavoriteList() {
        try {
            List<PersonalFavoriteDTO> list = this.serviceFavoriteService.listPersonalFavorite(this.getPortalContext(), this.getPermMap());
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            this.writeAjaxData(false, null, null);
        }
    }

    public void createPersonalFavorite() {
        try {
            ServiceDefinition def;
            String addType = this.getRequest().getParameter("addType");
            ServiceDefinitionService serviceDefinitionService = (ServiceDefinitionService)ServiceLocator.getBean("serviceDefinitionService");
            ServiceFavorite fav = this.serviceFavoriteService.createPersonalFavorite(this.getPortalContext(), this.favorite, addType);
            if (fav != null && (def = serviceDefinitionService.findServiceDefinitionById(this.getPortalContext(), fav.getServiceDefId())) != null) {
                PersonalFavoriteDTO dto = new PersonalFavoriteDTO(fav, def.getDisplayName());
                dto.setDefinition(def);
                this.writeAjaxData(true, null, dto);
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void deletePersonalFavorite() {
        try {
            this.serviceFavoriteService.deletePersonalFavoriteById(this.getPortalContext(), this.favorite.getServiceDefId());
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public String findServiceDetail() {
        try {
            ServiceDefinition def = this.serviceFavoriteService.findServiceDefinition(this.getPortalContext(), this.definition.getId());
            String userCode = this.easService.getUserCodeByUserId(this.getPortalContext(), def.getManagerId());
            this.resultMap = new HashMap<String, Object>();
            this.resultMap.put("definition", (Object)def);
            this.resultMap.put("userCode", userCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "success";
    }

    public void findServiceDetailForAjax() {
        try {
            ServiceDefinition def = this.serviceFavoriteService.findServiceDefinition(this.getPortalContext(), this.definition.getId());
            this.writeAjaxData(true, null, (Object)def);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void findServiceCountAndScore() {
        try {
            float totalScore = this.serviceDefinitionService.findServiceTotalScore(this.getPortalContext());
            int totalCount = this.serviceInstanceService.findServiceTotalCount(this.getPortalContext());
            JSONObject obj = new JSONObject();
            obj.put((Object)"totalScore", (Object)Float.valueOf(totalScore));
            obj.put((Object)"totalCount", (Object)totalCount);
            this.writeAjaxData(true, null, obj);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void findAllEnableMyService() {
        try {
            Map<String, Object> map = this.serviceDefinitionService.findAllEnableMyService(this.getPortalContext(), this.getPermMap());
            this.writeAjaxData(true, null, map);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void sortPersonalFavorite() {
        try {
            this.serviceFavoriteService.sortPersonalFavorite(this.getPortalContext(), this.favorite.getId().split(","));
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public ServiceFavorite getFavorite() {
        return this.favorite;
    }

    public void setFavorite(ServiceFavorite favorite) {
        this.favorite = favorite;
    }

    public ServiceDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ServiceDefinition definition) {
        this.definition = definition;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public Map<String, Object> getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(Map<String, Object> resultMap) {
        this.resultMap = resultMap;
    }

    public String getInsId() {
        return this.insId;
    }

    public void setInsId(String insId) {
        this.insId = insId;
    }
}

