/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.action;

import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.iservice.common.enums.NodeTypeEnum;
import com.kingdee.portal.plt.iservice.common.enums.ServiceStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.ServiceTypeEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.util.ServiceLocator;
import com.kingdee.portal.plt.iservice.module.service.dto.ServiceTreeSortDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class ServiceDefAction
extends BaseFileUploadAction {
    private ServiceDefinitionService serviceDefinitionService = (ServiceDefinitionService)ServiceLocator.getBean("serviceDefinitionService");
    private ServiceDefinition serviceDefinition = null;
    private ServiceTreeSortDTO serviceTreeSortDTO = null;

    public String findServiceList4Tree() {
        String id = StringUtil.convNull((String)this.getRequest().getParameter("id"));
        List<Object> serviceNodes = new ArrayList();
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            List<ServiceDefinition> serviceList = this.serviceDefinitionService.findServiceList4Tree(portalContext, id);
            serviceNodes = this.buildeTreeNodes(serviceList);
        }
        catch (ServiceBizException ex) {
            this.handleErr((Exception)((Object)ex));
        }
        this.writeObjectData(serviceNodes, ResponseContentTypeEnum.JSON);
        return null;
    }

    public String findAllService() {
        boolean success = true;
        LocalErr localErr = null;
        List<ServiceDefinition> serviceList = null;
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            serviceList = this.serviceDefinitionService.findServiceList4EnableAndDisable(portalContext);
        }
        catch (ServiceBizException ex) {
            success = false;
            localErr = this.handleErr((Exception)((Object)ex));
        }
        this.writeAjaxData(success, localErr, serviceList);
        return null;
    }

    public String sortTreeNode() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            this.serviceDefinitionService.sortServiceNodeOrder(portalContext, this.serviceTreeSortDTO);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String showNodeInfo() {
        String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
        this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
        String hashCode = StringUtil.convNull((String)this.getRequest().getParameter("hashCode"));
        this.getRequest().setAttribute("hashCode", (Object)hashCode);
        if (NodeTypeEnum.ROOT.equals((Object)this.serviceDefinition.getNodeType())) {
            return "root";
        }
        if (NodeTypeEnum.CATEGORY.equals((Object)this.serviceDefinition.getNodeType())) {
            return this.showCategoryInfo();
        }
        if (NodeTypeEnum.EAS_WEB_BILL.equals((Object)this.serviceDefinition.getNodeType()) || NodeTypeEnum.EAS_GUI_BILL.equals((Object)this.serviceDefinition.getNodeType()) || NodeTypeEnum.OA_WEB_BILL.equals((Object)this.serviceDefinition.getNodeType()) || NodeTypeEnum.URL.equals((Object)this.serviceDefinition.getNodeType())) {
            return this.showServiceInfo();
        }
        this.getRequest().setAttribute("error", (Object)new ServiceBizException("003"));
        return "error";
    }

    public String saveService() {
        String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
        this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
        String hashCode = StringUtil.convNull((String)this.getRequest().getParameter("hashCode"));
        this.getRequest().setAttribute("hashCode", (Object)hashCode);
        try {
            String updateImgStr = StringUtil.convNull((String)this.getRequest().getParameter("updateFlag"));
            boolean updateImg = Boolean.parseBoolean(updateImgStr);
            FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("iservice_last_upload_img");
            this.serviceDefinition = this.serviceDefinitionService.saveServiceDefinition(this.getPortalContext(), this.serviceDefinition, fileModel, updateImg);
            this.getRequest().setAttribute("serviceDefinition", (Object)this.serviceDefinition);
            if (NodeTypeEnum.CATEGORY.equals((Object)this.serviceDefinition.getNodeType())) {
                return "category";
            }
            return "service";
        }
        catch (ServiceBizException ex) {
            this.getRequest().setAttribute("error", (Object)ex);
            return "error";
        }
    }

    public String deleteService() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            this.serviceDefinitionService.deleteServiceDefinitionById(portalContext, this.serviceDefinition.getId());
        }
        catch (ServiceBizException ex) {
            success = false;
            localErr = this.handleErr((Exception)((Object)ex));
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String showEasMenuSelector() {
        String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
        this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
        this.getRequest().setAttribute("serviceDefinition", (Object)this.serviceDefinition);
        return "easMenuSelector";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadTempImg() {
        boolean success = true;
        LocalErr localErr = null;
        FileModel fileModel = null;
        FileInputStream fis = null;
        try {
            this.copyFile2UploadFolder();
            fileModel = new FileModel();
            fileModel.setUploadFilePath(this.getUpload().getAbsolutePath());
            fileModel.setUploadFileName(this.getUploadFileName());
            fileModel.setUploadContentType(this.getUploadContentType());
            fileModel.setLength(Long.valueOf(this.getUpload().length()));
            fis = new FileInputStream(this.getUpload());
            BufferedImage image = ImageIO.read(fis);
            if (image == null) {
                throw new PortalBizException("405");
            }
            fileModel.setHeight(Integer.valueOf(image.getHeight()));
            fileModel.setWidth(Integer.valueOf(image.getWidth()));
        }
        catch (Exception ex) {
            localErr = this.handleErr(ex);
            success = false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"uploadTempImg");
        this.getRequest().getSession().setAttribute("iservice_last_upload_img", (Object)fileModel);
        this.getRequest().setAttribute("localErr", (Object)localErr);
        return "success";
    }

    public String showTempImg() {
        FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("iservice_last_upload_img");
        File tempTempImg = new File(fileModel.getUploadFilePath());
        byte[] fileContent = this.getFileContent(tempTempImg);
        this.writeResponse(this.getResponse(), fileModel.getUploadContentType(), fileContent);
        return null;
    }

    private List<Map<String, Object>> buildeTreeNodes(List<ServiceDefinition> serviceList) {
        ArrayList<Map<String, Object>> serviceNodes = new ArrayList<Map<String, Object>>();
        for (ServiceDefinition serviceDefinition : serviceList) {
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("id", serviceDefinition.getId());
            node.put("pId", serviceDefinition.getParentNodeId());
            String name = this.getLocaleDisplayName(serviceDefinition.getDisplayName());
            if (ServiceStateEnum.DISABLE.equals((Object)serviceDefinition.getState())) {
                name = name + "(\u7981\u7528)";
            }
            node.put("name", name);
            node.put("nodeType", (Object)serviceDefinition.getNodeType());
            node.put("state", (Object)serviceDefinition.getState());
            boolean isParent = false;
            if (NodeTypeEnum.ROOT.equals((Object)serviceDefinition.getNodeType()) || NodeTypeEnum.CATEGORY.equals((Object)serviceDefinition.getNodeType())) {
                isParent = true;
            }
            node.put("isParent", isParent);
            serviceNodes.add(node);
        }
        return serviceNodes;
    }

    private String getLocaleDisplayName(String displayName) {
        DisplayName dn = new DisplayName(displayName, this.getPortalContext().getLocale().toString());
        return dn.getLocaleText();
    }

    private String showCategoryInfo() {
        try {
            ServiceDefinition def = null;
            if (!StringUtil.isEmpty((String)this.serviceDefinition.getId())) {
                def = this.serviceDefinitionService.findServiceDefinitionById(this.getPortalContext(), this.serviceDefinition.getId());
            } else {
                def = new ServiceDefinition();
                def.setState(ServiceStateEnum.DISABLE);
                def.setParentNodeId(this.serviceDefinition.getParentNodeId());
            }
            this.getRequest().setAttribute("serviceDefinition", (Object)def);
            return "category";
        }
        catch (ServiceBizException ex) {
            this.getRequest().setAttribute("error", (Object)ex);
            return "error";
        }
    }

    private String showServiceInfo() {
        try {
            ServiceDefinition def = null;
            if (!StringUtil.isEmpty((String)this.serviceDefinition.getId())) {
                def = this.serviceDefinitionService.findServiceDefinitionById(this.getPortalContext(), this.serviceDefinition.getId());
            } else {
                def = new ServiceDefinition();
                def.setState(ServiceStateEnum.DISABLE);
                def.setServiceType(ServiceTypeEnum.WORKFLOW);
                def.setNodeType(NodeTypeEnum.EAS_GUI_BILL);
                def.setParentNodeId(this.serviceDefinition.getParentNodeId());
            }
            this.getRequest().setAttribute("serviceDefinition", (Object)def);
            return "service";
        }
        catch (ServiceBizException ex) {
            this.getRequest().setAttribute("error", (Object)ex);
            return "error";
        }
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setServiceDefinition(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public ServiceTreeSortDTO getServiceTreeSortDTO() {
        return this.serviceTreeSortDTO;
    }

    public void setServiceTreeSortDTO(ServiceTreeSortDTO serviceTreeSortDTO) {
        this.serviceTreeSortDTO = serviceTreeSortDTO;
    }
}

