/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.dao.impl;

import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.iservice.common.enums.InsStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.MarkFlagEnum;
import com.kingdee.portal.plt.iservice.common.enums.NodeTypeEnum;
import com.kingdee.portal.plt.iservice.common.enums.ServiceTypeEnum;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceInstanceDAO;
import com.kingdee.portal.plt.iservice.module.service.dto.ServRecDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceInstance;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;

public class ServiceInstanceDAOImpl
extends BaseDAOImpl<ServiceInstance>
implements ServiceInstanceDAO {
    private static final String JPQL_GET_SERV_REC_BY_USER = "SELECT si.insParam,si.startTime,si.endTime,si.markFlag,si.procInstId,si.state,si.createTime,sd.displayName,sd.nodeType,sd.serviceStandard,sd.managerId,sd.tel,sd.serviceType,sd.managerDisplayName,si.id,sd.id,sd.defParam FROM ServiceInstance si,ServiceDefinition sd WHERE si.serviceDefId = sd.id and si.userId = :userid and si.state = :state  order by si.createTime desc";
    private static final String JPQL_GET_ALL_REC_BY_USER = "SELECT si.insParam,si.startTime,si.endTime,si.markFlag,si.procInstId,si.state,si.createTime,sd.displayName,sd.nodeType,sd.serviceStandard,sd.managerId,sd.tel,sd.serviceType,sd.managerDisplayName,si.id,sd.id,sd.defParam FROM ServiceInstance si ,ServiceDefinition sd WHERE si.serviceDefId = sd.id and si.userId = :userid order by si.startTime desc";
    private static final String JPQL_GET_EVAL_REC_BY_USER = "SELECT si.insParam,si.startTime,si.endTime,si.markFlag,si.procInstId,si.state,si.createTime,sd.displayName,sd.nodeType,sd.serviceStandard,sd.managerId,sd.tel,sd.serviceType,sd.managerDisplayName,si.id,sd.id,sd.defParam  FROM ServiceInstance si ,ServiceDefinition sd WHERE si.serviceDefId = sd.id   and si.userId = :userid and si.state = :state and si.markFlag = :markFlag order by si.startTime desc";

    @Override
    public List<ServRecDTO> getServRec(String userid, InsStateEnum state, int startIndex, int lastIndex) throws DataAccessException {
        Query query = this.em.createQuery(JPQL_GET_SERV_REC_BY_USER);
        query.setParameter("userid", (Object)userid);
        query.setParameter("state", (Object)state);
        query.setFirstResult(startIndex);
        query.setMaxResults(lastIndex);
        List<ServRecDTO> result = this.builtRec(query.getResultList());
        return result;
    }

    @Override
    public List<ServRecDTO> getAllServRec(String userid, int startIndex, int lastIndex) throws DataAccessException {
        Query query = this.em.createQuery(JPQL_GET_ALL_REC_BY_USER);
        query.setParameter("userid", (Object)userid);
        query.setFirstResult(startIndex);
        query.setMaxResults(lastIndex);
        List<ServRecDTO> result = this.builtRec(query.getResultList());
        return result;
    }

    @Override
    public List<ServRecDTO> getEvalServRec(String userid, int startIndex, int lastIndex) throws DataAccessException {
        Query query = this.em.createQuery(JPQL_GET_EVAL_REC_BY_USER);
        query.setParameter("userid", (Object)userid);
        query.setParameter("state", (Object)InsStateEnum.COMPLETE);
        query.setParameter("markFlag", (Object)MarkFlagEnum.NO);
        query.setFirstResult(startIndex);
        query.setMaxResults(lastIndex);
        List<ServRecDTO> result = this.builtRec(query.getResultList());
        return result;
    }

    private List<ServRecDTO> builtRec(List recList) {
        ArrayList<ServRecDTO> servList = new ArrayList<ServRecDTO>();
        for (int i = 0; i < recList.size(); ++i) {
            long userTime;
            Object[] objs = (Object[])recList.get(i);
            MarkFlagEnum markFlag = (MarkFlagEnum)((Object)objs[3]);
            NodeTypeEnum nodeType = (NodeTypeEnum)((Object)objs[8]);
            ServRecDTO rec = new ServRecDTO();
            rec.setInsParam((String)objs[0]);
            if (null != objs[1]) {
                rec.setStartTime((Timestamp)objs[1]);
            }
            if (null != objs[2]) {
                rec.setEndTime((Timestamp)objs[2]);
            }
            rec.setMarkFlag(markFlag.name());
            rec.setProcInstId((String)objs[4]);
            rec.setState((InsStateEnum)((Object)objs[5]));
            rec.setCreateTime((Timestamp)objs[6]);
            rec.setServiceName((String)objs[7]);
            rec.setNodeType(nodeType);
            rec.setServiceStandard((Double)objs[9]);
            rec.setTel((String)objs[11]);
            if (null != objs[12]) {
                rec.setServiceType((ServiceTypeEnum)((Object)objs[12]));
            }
            rec.setManagerName((String)objs[13]);
            if (rec.getState().equals((Object)InsStateEnum.COMPLETE)) {
                userTime = (rec.getEndTime().getTime() - rec.getStartTime().getTime()) / 86400000L;
                rec.setUseTime(userTime);
            } else if (!rec.getState().equals((Object)InsStateEnum.DRAFT)) {
                Date now = new Date();
                userTime = (now.getTime() - rec.getStartTime().getTime()) / 86400000L;
                rec.setUseTime(userTime);
            }
            rec.setServiceInstancefid((String)objs[14]);
            rec.setServiceDefinefid((String)objs[15]);
            rec.setDefParam((String)objs[16]);
            servList.add(rec);
        }
        return servList;
    }
}

