/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.service.impl;

import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.personal.service.PresetService;
import com.kingdee.portal.plt.iservice.common.enums.InsStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.MarkFlagEnum;
import com.kingdee.portal.plt.iservice.common.enums.ServiceTypeEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.facade.workflow.WorkFlowService;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceFavoriteDAO;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceInstanceDAO;
import com.kingdee.portal.plt.iservice.module.service.dto.PersonalFavoriteDTO;
import com.kingdee.portal.plt.iservice.module.service.dto.ServRecDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceFavorite;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceInstance;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceFavoriteService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceInstanceService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ServiceFavoriteServiceImpl
implements ServiceFavoriteService {
    private ServiceFavoriteDAO serviceFavoriteDAO;
    private ServiceInstanceDAO serviceInstanceDAO;
    private ServiceDefinitionService serviceDefinitionService;
    private ServiceInstanceService serviceInstanceService;
    private WorkFlowService workFlowService;
    private PresetService presetService = (PresetService)PortalServiceLocator.getBean((String)"presetService");

    @Override
    public List<ServRecDTO> listRunningFavor(PortalContext ctx) throws ServiceBizException {
        List<ServRecDTO> list = this.serviceInstanceService.getServRec(ctx, InsStateEnum.RUNNING, 0, 5);
        return list;
    }

    @Override
    public List<ServRecDTO> findRunningFavorDetail(PortalContext portalContext, String procInstId) throws ServiceBizException {
        ArrayList<ServRecDTO> list = new ArrayList<ServRecDTO>();
        try {
            ServRecDTO dto;
            ServiceInstance servInstance = (ServiceInstance)((Object)this.serviceInstanceDAO.findObject(new Filter[]{new FieldFilter("procInstId", "=", (Object)procInstId)}));
            String insParam = servInstance.getInsParam();
            MultiApproveCollection multiCollection = this.workFlowService.getCompleteNodeByProcinstId(insParam);
            for (int i = 0; i < multiCollection.size(); ++i) {
                MultiApproveInfo info = multiCollection.get(i);
                dto = new ServRecDTO();
                ApproveResult isPass = info.getIsPass();
                String assignment = info.getAssignment();
                dto.setOpinion(info.getOpinion());
                dto.setIsPass(isPass.getValue());
                dto.setCreateTime(info.getCreateTime());
                dto.setProcInstId(procInstId);
                dto.setAssignId(assignment);
                dto.setInsParam(insParam);
                AssignCollection assignCollection = this.workFlowService.getCurrNodeAndHanlerByAssignId(assignment);
                for (int j = 0; j < assignCollection.size(); ++j) {
                    AssignInfo assInfo = assignCollection.get(j);
                    dto.setCurrentNode(assInfo.getActdefName());
                    dto.setCurrentPerson(assInfo.getPersonUserName());
                    list.add(dto);
                }
            }
            AssignCollection assignCollection = this.workFlowService.getCurrNodeAndHanlerByProcinstId(procInstId);
            for (int i = 0; i < assignCollection.size(); ++i) {
                dto = new ServRecDTO();
                AssignInfo info = assignCollection.get(i);
                String personId = info.getPersonUserID().toString();
                dto.setProcInstId(procInstId);
                dto.setManagerId(personId);
                dto.setIsPass("waiting");
                dto.setAssignId(info.getAssignID().toString());
                dto.setInsParam(insParam);
                dto.setCurrentPerson(info.getPersonUserName());
                dto.setCurrentNode(info.getActdefName());
                String actdefName = info.getActdefName();
                if (!StringUtils.isNotEmpty((String)actdefName) || !actdefName.contains("\u5ba1\u6279")) continue;
                dto.setCurrentNode(actdefName);
                list.add(dto);
            }
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("602", e);
        }
        return list;
    }

    @Override
    public Map<String, Object> findMyServiceTypes(PortalContext ctx) throws ServiceBizException {
        try {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            HashMap defMapMap = new HashMap();
            HashMap<String, ServiceFavorite> favMap = new HashMap<String, ServiceFavorite>();
            List<ServiceDefinition> list = this.serviceDefinitionService.findAllServiceCategory(ctx);
            ServiceFavorite serviceFavorite = new ServiceFavorite();
            serviceFavorite.setUserId(ctx.getLoginUser().getId());
            serviceFavorite.setPortalContext(ctx);
            List favList = this.serviceFavoriteDAO.findList((Object)serviceFavorite, new Filter[0]);
            for (ServiceFavorite fav : favList) {
                favMap.put(fav.getServiceDefId(), fav);
            }
            for (int i = 0; list != null && i < list.size(); ++i) {
                ServiceDefinition def = list.get(i);
                String categoryId = def.getId();
                HashMap<String, List<ServiceDefinition>> tempMap = new HashMap<String, List<ServiceDefinition>>();
                List<ServiceDefinition> defList = this.serviceDefinitionService.findServiceDefListByCategoryId(ctx, categoryId);
                if (defList == null || defList.size() == 0) {
                    list.remove(i);
                    --i;
                    continue;
                }
                for (ServiceDefinition servDef : defList) {
                    if (favMap.containsKey(servDef.getId())) {
                        servDef.setCreator("iServiceFavorateAddFlag_True");
                        continue;
                    }
                    servDef.setCreator("iServiceFavorateAddFlag_False");
                }
                tempMap.put("defList", defList);
                defMapMap.put(categoryId, tempMap);
            }
            resultMap.put("firstLevelPages", list);
            resultMap.put("multiTreeNodes", defMapMap);
            resultMap.put("favList", favList);
            return resultMap;
        }
        catch (Exception e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public List<ServiceFavorite> findFavList(PortalContext ctx) throws ServiceBizException {
        try {
            ServiceFavorite serviceFavorite = new ServiceFavorite();
            serviceFavorite.setUserId(ctx.getLoginUser().getId());
            serviceFavorite.setPortalContext(ctx);
            return this.serviceFavoriteDAO.findList((Object)serviceFavorite, new Filter[0]);
        }
        catch (Exception e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public List<ServiceDefinition> findAllServiceByCategoryId(PortalContext ctx, String categoryId) throws ServiceBizException {
        return this.serviceDefinitionService.findServiceDefListByCategoryId(ctx, categoryId);
    }

    @Override
    public List<PersonalFavoriteDTO> listPersonalFavorite(PortalContext ctx, Map<String, Object> permMap) throws ServiceBizException {
        ArrayList<PersonalFavoriteDTO> dtoList = new ArrayList<PersonalFavoriteDTO>();
        try {
            IRowSet rs = this.presetService.configPresetFav(ctx, null, "service");
            if (rs != null) {
                while (rs.next()) {
                    ServiceFavorite fav = new ServiceFavorite();
                    fav.setServiceDefId(rs.getString("FId"));
                    this.createPersonalFavorite(ctx, fav, "");
                }
            }
            List<ServiceFavorite> list = this.findFavList(ctx);
            for (int i = 0; list != null && i < list.size(); ++i) {
                ServiceFavorite fav = list.get(i);
                ServiceDefinition def = this.serviceDefinitionService.findServiceDefinitionById(ctx, fav.getServiceDefId());
                if (def == null) continue;
                ArrayList<ServiceDefinition> defList = new ArrayList<ServiceDefinition>();
                defList.add(def);
                List<ServiceDefinition> newList = this.serviceDefinitionService.selectPermServiceList(ctx, defList, permMap);
                if (newList == null || newList.size() <= 0) continue;
                PersonalFavoriteDTO dto = new PersonalFavoriteDTO(fav, def.getDisplayName());
                dto.setDefinition(def);
                dtoList.add(dto);
            }
            return dtoList;
        }
        catch (Exception e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public ServiceFavorite createPersonalFavorite(PortalContext ctx, ServiceFavorite serviceFavorite, String addType) throws ServiceBizException {
        try {
            serviceFavorite.setUserId(ctx.getLoginUser().getId());
            serviceFavorite.setPortalContext(ctx);
            String defId = serviceFavorite.getServiceDefId();
            ServiceFavorite favorite = (ServiceFavorite)((Object)this.serviceFavoriteDAO.findObject((Object)serviceFavorite, new Filter[]{new FieldFilter("serviceDefId", "=", (Object)defId)}));
            ServiceDefinition def = this.serviceDefinitionService.findServiceDefinitionById(ctx, defId);
            if ("start".equals(addType) && !ServiceTypeEnum.WORKFLOW.equals((Object)def.getServiceType())) {
                ServiceInstance instance = new ServiceInstance();
                instance.setPortalContext(ctx);
                instance.setUserId(ctx.getLoginUser().getId());
                Timestamp startTime = new Timestamp(new Date().getTime());
                instance.setCreateTime(startTime);
                instance.setStartTime(startTime);
                instance.setEndTime(startTime);
                instance.setMarkFlag(MarkFlagEnum.NO);
                instance.setServiceDefId(def.getId());
                instance.setInsParam(null);
                instance.setProcInstId(null);
                instance.setState(InsStateEnum.COMPLETE);
                this.serviceInstanceDAO.create((Object)instance);
            }
            if (favorite == null) {
                serviceFavorite.setRunCount(1);
                return (ServiceFavorite)((Object)this.serviceFavoriteDAO.create((Object)serviceFavorite));
            }
            favorite.setRunCount(favorite.getRunCount() + 1);
            favorite.setPortalContext(ctx);
            this.serviceFavoriteDAO.update((Object)favorite);
            return null;
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("601", e);
        }
    }

    @Override
    public void deletePersonalFavoriteById(PortalContext ctx, String serviceDefId) throws ServiceBizException {
        try {
            String userId = ctx.getLoginUser().getId();
            this.serviceFavoriteDAO.deletePersonalFavorite(ctx, userId, serviceDefId);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("603", e);
        }
    }

    @Override
    public void sortPersonalFavorite(PortalContext ctx, String[] sortInfo) throws ServiceBizException {
        try {
            for (String info : sortInfo) {
                ServiceFavorite fav = new ServiceFavorite();
                String[] favInfo = info.split("_");
                fav.setPortalContext(ctx);
                fav = (ServiceFavorite)((Object)this.serviceFavoriteDAO.findObject((Object)fav, new Filter[]{new FieldFilter("serviceDefId", "=", (Object)favInfo[0])}));
                if (fav != null) {
                    fav.setServiceDefId(favInfo[0]);
                    fav.setRunCount(Integer.valueOf(favInfo[1]));
                    this.serviceFavoriteDAO.update((Object)fav);
                    continue;
                }
                ServiceFavorite myFav = new ServiceFavorite();
                myFav.setPortalContext(ctx);
                myFav.setUserId(ctx.getLoginUser().getId());
                myFav.setServiceDefId(favInfo[0]);
                myFav.setRunCount(Integer.valueOf(favInfo[1]));
                this.serviceFavoriteDAO.create((Object)myFav);
            }
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("601", e);
        }
    }

    @Override
    public ServiceDefinition findServiceDefinition(PortalContext ctx, String id) throws ServiceBizException {
        try {
            return this.serviceDefinitionService.findServiceDefinitionById(ctx, id);
        }
        catch (Exception e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public List<ServiceDefinition> findWaiteJudgeService(PortalContext ctx) throws ServiceBizException {
        try {
            List<ServiceDefinition> list = this.serviceDefinitionService.findServiceList4Enable(ctx);
            for (int i = 0; list != null && i < list.size(); ++i) {
                ServiceDefinition service = list.get(i);
                ServiceInstance instance = new ServiceInstance();
                instance.setPortalContext(ctx);
                instance = (ServiceInstance)((Object)this.serviceInstanceDAO.findObject((Object)instance, new Filter[]{new FieldFilter("serviceDefId", "=", (Object)service.getId())}));
                if (instance != null && !instance.getMarkFlag().equals((Object)MarkFlagEnum.YES)) continue;
                list.remove(i);
                --i;
            }
            return list;
        }
        catch (Exception e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public Integer findMyServiceNum(PortalContext ctx) throws ServiceBizException {
        try {
            ServiceInstance instance = new ServiceInstance();
            instance.setPortalContext(ctx);
            return this.serviceInstanceDAO.totalCount((Object)instance, null);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public Integer findMyRuningServiceNum(PortalContext ctx) throws ServiceBizException {
        try {
            ServiceInstance instance = new ServiceInstance();
            instance.setPortalContext(ctx);
            return this.serviceInstanceDAO.totalCount((Object)instance, null);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("602", e);
        }
    }

    @Override
    public Integer findMyWaitingJudgeServiceNum(PortalContext ctx) throws ServiceBizException {
        try {
            ServiceInstance instance = new ServiceInstance();
            instance.setPortalContext(ctx);
            return this.serviceInstanceDAO.totalCount((Object)instance, new Filter[]{new FieldFilter("markFlag", "=", (Object)MarkFlagEnum.NO)});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("602", e);
        }
    }

    public ServiceFavoriteDAO getServiceFavoriteDAO() {
        return this.serviceFavoriteDAO;
    }

    public void setServiceFavoriteDAO(ServiceFavoriteDAO serviceFavoriteDAO) {
        this.serviceFavoriteDAO = serviceFavoriteDAO;
    }

    public ServiceInstanceDAO getServiceInstanceDAO() {
        return this.serviceInstanceDAO;
    }

    public void setServiceInstanceDAO(ServiceInstanceDAO serviceInstanceDAO) {
        this.serviceInstanceDAO = serviceInstanceDAO;
    }

    public ServiceDefinitionService getServiceDefinitionService() {
        return this.serviceDefinitionService;
    }

    public void setServiceDefinitionService(ServiceDefinitionService serviceDefinitionService) {
        this.serviceDefinitionService = serviceDefinitionService;
    }

    public ServiceInstanceService getServiceInstanceService() {
        return this.serviceInstanceService;
    }

    public void setServiceInstanceService(ServiceInstanceService serviceInstanceService) {
        this.serviceInstanceService = serviceInstanceService;
    }

    public WorkFlowService getWorkFlowService() {
        return this.workFlowService;
    }

    public void setWorkFlowService(WorkFlowService workFlowService) {
        this.workFlowService = workFlowService;
    }
}

