/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.exception.conf.ServiceErrConfig;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceMarkingDAO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceMarking;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceMarkingService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ServiceMarkingServiceImpl
implements ServiceMarkingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServiceMarkingDAO serviceMarkingDAO;
    private ServiceDefinitionService serviceDefinitionService;

    @Override
    public ServiceMarking saveServiceMarking(PortalContext portalContext, ServiceMarking serviceMarking) throws ServiceBizException {
        try {
            this.logger.info("saveServiceMarking.");
            serviceMarking.setPortalContext(portalContext);
            this.serviceMarkingDAO.create((Object)serviceMarking);
            this.serviceDefinitionService.updateServiceScore(portalContext, serviceMarking.getServiceId());
        }
        catch (Exception e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_SAVE_ERR, e);
        }
        return serviceMarking;
    }

    @Override
    public List<ServiceMarking> findServiceMarkingList(PortalContext portalContext, String serviceId) throws ServiceBizException {
        List servMarkingList = null;
        try {
            servMarkingList = this.serviceMarkingDAO.findList(new Filter[]{new FieldFilter("serviceId", "=", (Object)serviceId), new OrderFilter("createTime", OrderEnum.DESC)});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException("", e);
        }
        return servMarkingList;
    }

    @Override
    public ServiceMarking getScroeBySerInstanceID(PortalContext portalContext, String serviceInstanceID) throws ServiceBizException {
        try {
            ServiceMarking serviceMarking = new ServiceMarking();
            serviceMarking.setBillId(serviceInstanceID);
            return (ServiceMarking)((Object)this.serviceMarkingDAO.findObject((Object)serviceMarking, new Filter[0]));
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_REC_GETSCORE, e);
        }
    }

    public void setServiceDefinitionService(ServiceDefinitionService serviceDefinitionService) {
        this.serviceDefinitionService = serviceDefinitionService;
    }

    public ServiceMarkingDAO getServiceMarkingDAO() {
        return this.serviceMarkingDAO;
    }

    public void setServiceMarkingDAO(ServiceMarkingDAO serviceMarkingDAO) {
        this.serviceMarkingDAO = serviceMarkingDAO;
    }
}

