/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.fme.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.fme.dto.SavePathDto;
import com.kingdee.portal.biz.module.fme.service.SavePathService;
import com.kingdee.portal.plt.portal.module.portlet.action.PortletDefinitionAction;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavePathAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(PortletDefinitionAction.class);
    private SavePathDto savePathDto;
    private SavePathService savePathService = (SavePathService)PortalServiceLocator.getBean((String)"savePathService");

    public SavePathDto getSavePathDto() {
        return this.savePathDto;
    }

    public void setSavePathDto(SavePathDto savePathDto) {
        this.savePathDto = savePathDto;
    }

    public String fmeManager() {
        try {
            boolean isFmePremission = false;
            Context ctx0 = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            isFmePremission = iPermission.hasFunctionPermission(ctx0.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx0).getId()), "fme_view");
            if (!isFmePremission) {
                return "noAdmin";
            }
            this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
            return "success";
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return "error";
    }

    public String fmeLoadContent() {
        String tag = this.getRequest().getParameter("tag");
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        if (tag.equals("1")) {
            return "savePath";
        }
        if (tag.equals("2")) {
            return "ftpServer";
        }
        return "documentIcon";
    }

    public String toSaveSavePath() {
        String id = this.getRequest().getParameter("id");
        SavePathDto savePath = new SavePathDto();
        if (id != null && !id.equals("")) {
            try {
                savePath = this.savePathService.getSavePathById(this.getPortalContext(), id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getRequest().setAttribute("savePath", (Object)savePath);
        return "success";
    }

    public void findSavePathList() {
        PagingResult pagingResult;
        try {
            this.pagingParam.setSortField("pathStatus");
            this.pagingParam.setOrder(OrderEnum.ASC);
            pagingResult = this.savePathService.findSavePathDtoList(this.getPortalContext(), this.pagingParam);
        }
        catch (Exception e) {
            e.printStackTrace();
            pagingResult = new PagingResult();
        }
        this.writePagingResult(pagingResult);
    }

    public void saveSavePath() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            String result = this.savePathService.saveSavepath(ctx, this.savePathDto);
            this.writeAjaxData(true, null, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void checkSavePathName() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            boolean result = this.savePathService.checkSavePathName(ctx, this.savePathDto.getId(), this.savePathDto.getDisplayName());
            this.writeAjaxData(true, null, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void deleteSavePath() {
        String ids = this.getRequest().getParameter("ids");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            String result = this.savePathService.deleteSavePath(ctx, ids);
            if (result.equals("0")) {
                this.writeAjaxData(true, null, "0");
            } else if (result.equals("1")) {
                this.writeAjaxData(true, null, "1");
            } else {
                this.writeAjaxData(true, null, "2");
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
            e.printStackTrace();
        }
    }

    public void updateState() {
        String ids = this.getRequest().getParameter("ids");
        String state = this.getRequest().getParameter("state");
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            boolean result = this.savePathService.updateSavePathState(ctx, ids, state);
            this.writeAjaxData(true, null, result);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
            e.printStackTrace();
        }
    }

    public void getSavePath() {
        String id = this.getRequest().getParameter("id");
        try {
            SavePathDto savePath = this.savePathService.getSavePathById(this.getPortalContext(), id);
            this.writeAjaxData(true, null, savePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }
}

