/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.portlet.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.biz.module.portlet.service.PortletTmplService;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortleTmplAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(PortleTmplAction.class);
    private static final long serialVersionUID = 5348374510095606008L;
    private PortletTmplService portletTmplService = (PortletTmplService)PortalServiceLocator.getBean((String)"portletTmplService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");

    public String findPortletTmplList() {
        try {
            if (FilterSpecialCharactersTool.isContainSQLSpecialCharacters((HttpServletRequest)this.getRequest())) {
                return null;
            }
            PagingResult pagingResult = this.portletTmplService.findPortletTmpl(this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        return null;
    }

    public String modifyTmplStatus() {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.status");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.statuserr");
            String tmplId = this.getRequest().getParameter("tmplId");
            String tmplStatus = this.getRequest().getParameter("tmplStatus");
            this.portletTmplService.modifyTmplStatus(this.getPortalContext(), tmplId, tmplStatus);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    public String delTmpl() {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.uninstall");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.uninstallerr");
            String tmplId = this.getRequest().getParameter("tmplId");
            this.portletTmplService.deleteTmpl(this.getPortalContext(), tmplId);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    public String findTmplById() {
        String tmplId = this.getRequest().getParameter("tmplId");
        try {
            PortletTmpl tmpl = this.portletTmplService.findTmplById(tmplId);
            JSONObject tmplObj = new JSONObject();
            tmplObj.put((Object)"id", (Object)tmpl.getId());
            tmplObj.put((Object)"tmplcode", (Object)tmpl.getCode());
            tmplObj.put((Object)"displayName", (Object)tmpl.getDisplayName());
            tmplObj.put((Object)"description", (Object)tmpl.getDecription());
            tmplObj.put((Object)"content", (Object)tmpl.getContent());
            this.writeData("result", tmplObj.toString());
        }
        catch (PortalBizException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public String modifyTmpl() {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.modify");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.modifyerr");
            String tmplId = this.getRequest().getParameter("tmplId");
            String displayName = this.getRequest().getParameter("displayName");
            String sdeceript = this.getRequest().getParameter("sdeceript");
            String scode = this.getRequest().getParameter("scode");
            scode = StringUtils.isEmpty((String)scode) ? "<div></div>" : scode.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            String tmplcode = this.getRequest().getParameter("tmplcode");
            PortletTmpl tmpl = new PortletTmpl();
            tmpl.setCode(tmplcode);
            tmpl.setId(tmplId);
            tmpl.setDisplayName(displayName);
            tmpl.setContent(scode);
            tmpl.setDecription(sdeceript);
            this.portletTmplService.modifyTmpl(this.getPortalContext(), tmpl);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    public String createTmpl() {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.success");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.err");
            String displayName = this.getRequest().getParameter("displayName");
            String sdeceript = this.getRequest().getParameter("sdeceript");
            String scode = this.getRequest().getParameter("scode");
            scode = StringUtils.isEmpty((String)scode) ? "<div></div>" : scode.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            String tmplcode = this.getRequest().getParameter("tmplcode");
            PortletTmpl tmpl = new PortletTmpl();
            tmpl.setCode(tmplcode);
            tmpl.setDisplayName(displayName);
            tmpl.setContent(scode);
            tmpl.setDecription(sdeceript);
            this.portletTmplService.createTmpl(this.getPortalContext(), tmpl);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    public String saveTmpl() {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.save");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletTmplPortlet.PortletTmplPortlet", "PortletTmplPortlet.result.saveerr");
            String tmplId = this.getRequest().getParameter("tmplId");
            String displayName = this.getRequest().getParameter("displayName");
            String sdeceript = this.getRequest().getParameter("sdeceript");
            String scode = this.getRequest().getParameter("scode");
            scode = StringUtils.isEmpty((String)scode) ? "<div></div>" : scode.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            String tmplcode = this.getRequest().getParameter("tmplcode");
            PortletTmpl tmpl = new PortletTmpl();
            tmpl.setCode(tmplcode);
            tmpl.setId(tmplId);
            tmpl.setDisplayName(displayName);
            tmpl.setContent(scode);
            tmpl.setDecription(sdeceript);
            tmpl.setStatus(StatusEnum.DISABLE);
            this.portletTmplService.saveTmpl(this.getPortalContext(), tmpl);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)result);
            jsonObj.put((Object)"tmplId", (Object)tmpl.getId());
            this.writeData2Response(jsonObj.toString());
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    private void writeData(String skey, String svalue) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)skey, (Object)svalue);
        this.writeData2Response(jsonObj.toString());
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }
}

