/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.portlet.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.dto.PortletModel;
import com.kingdee.portal.biz.module.portlet.entity.PortletApp;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletAppService;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletTmplService;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletDefinitionAction
extends BaseAction {
    private static final long serialVersionUID = -5485635827615170006L;
    private static final Logger logger = LoggerFactory.getLogger(PortletDefinitionAction.class);
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");
    private PortletTmplService portletTmplService = (PortletTmplService)PortalServiceLocator.getBean((String)"portletTmplService");
    private PortletAppService portletAppService = (PortletAppService)PortalServiceLocator.getBean((String)"portletAppService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");
    private PortletModel portletModel;

    public void findAppLabelList() throws Exception {
        try {
            PagingParam pagingParam = new PagingParam();
            pagingParam.setSortField("createTime");
            pagingParam.setOrder(OrderEnum.ASC);
            pagingParam.setPageNo(1);
            pagingParam.setPageSize(100);
            List allList = this.portletAppService.findPortletAppList(pagingParam).getRecords();
            JSONObject jsonObj = new JSONObject();
            JSONArray app = new JSONArray();
            for (int i = 0; i < allList.size(); ++i) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"appname", (Object)((PortletApp)allList.get(i)).getName());
                app.add((Object)obj);
            }
            List pc = this.portletCategoryService.findCategoryList(this.getPortalContext(), "categoryName", "ASC");
            JSONArray category = new JSONArray();
            for (int i = 0; i < pc.size(); ++i) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"cname", (Object)this.getDisplayName(((PortletCategory)pc.get(i)).getCategoryName()));
                obj.put((Object)"pltKeyword", (Object)((PortletCategory)pc.get(i)).getPortletKeywords());
                category.add((Object)obj);
            }
            jsonObj.put((Object)"appList", (Object)app);
            jsonObj.put((Object)"cnameList", (Object)category);
            this.writeData2Response(jsonObj.toString());
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private String getDisplayName(String jsonStr) {
        if (StringUtil.isEmpty((String)jsonStr)) {
            return "\u65e0\u540d\u79f0";
        }
        DisplayName name = new DisplayName(jsonStr);
        name.setLocale(this.getPortalContext().getLocale().toString());
        return name.getLocaleText();
    }

    private void writeData(String skey, String svalue) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)skey, (Object)svalue);
        this.writeData2Response(jsonObj.toString());
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public String findPortletList() {
        String appName = this.getRequest().getParameter("appName");
        String labelName = this.getRequest().getParameter("labelName");
        String displayName = this.getRequest().getParameter("displayName");
        if (FilterSpecialCharactersTool.isContainSQLSpecialCharacters((HttpServletRequest)this.getRequest())) {
            return null;
        }
        try {
            PagingResult pagingResult = this.portletDefinitionService.findPortletDTOList(this.getPortalContext(), this.pagingParam, appName, labelName, displayName);
            this.writePagingResult(pagingResult);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        return null;
    }

    public String modifyPltStatus() throws Exception {
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.enable");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.enableerr");
            String pltId = this.getRequest().getParameter("pltId");
            this.portletDefinitionService.modifyPortletDefinitionStatus(this.getPortalContext(), pltId);
            this.writeData("result", result);
        }
        catch (PortalBizException PE) {
            logger.error(PE.getMessage());
            this.writeData("result", resultErr);
            return null;
        }
        return null;
    }

    public String findPltDef() throws Exception {
        String pltId = this.getRequest().getParameter("pltId");
        try {
            JSONObject tmplList = new JSONObject();
            tmplList = this.portletTmplService.findAllPortletTmpl(StatusEnum.ENABLE.toString());
            PortletDefinition pd = this.portletDefinitionService.findPortletDefinitionById(pltId);
            JSONObject pltDef = new JSONObject();
            pltDef.put((Object)"id", (Object)pd.getId());
            pltDef.put((Object)"displayName", (Object)pd.getDisplayName());
            pltDef.put((Object)"labelName", (Object)pd.getKeywords());
            pltDef.put((Object)"description", (Object)pd.getDescription());
            pltDef.put((Object)"tmplId", (Object)pd.getTmplId());
            pltDef.put((Object)"brole", (Object)"false");
            pltDef.put((Object)"tmpl", (Object)tmplList.toString());
            pltDef.put((Object)"permViewCtrl", (Object)pd.getPermViewCtrl());
            pltDef.put((Object)"appName", (Object)pd.getAppName());
            pltDef.put((Object)"icon", (Object)pd.getIcon());
            if (pd.getCategoryId() != null) {
                PortletCategory category = new PortletCategory();
                category.setId(pd.getCategoryId());
                category = this.portletCategoryService.findCategoryById(category);
                pltDef.put((Object)"categoryName", (Object)category.getCategoryName());
            } else {
                pltDef.put((Object)"categoryName", (Object)"Other");
            }
            this.writeData("result", pltDef.toString());
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String modifyPortlet() throws Exception {
        PortletDefinition pd = new PortletDefinition();
        String pltId = this.getRequest().getParameter("pltId");
        String displayName = this.getRequest().getParameter("displayName");
        String tmpl = this.getRequest().getParameter("tmpl");
        String author = this.getRequest().getParameter("author");
        String description = this.getRequest().getParameter("description");
        String permViewCtrl = this.getRequest().getParameter("author");
        String icon = this.getRequest().getParameter("icon");
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.modify");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.portal.i18n.portlet.PortletAppManagePortlet.PortletAppManagePortlet", "PortletAppManagePortlet.result.modifyerr");
            pd.setId(pltId);
            pd.setDisplayName(displayName);
            pd.setTmplId(tmpl);
            pd.setDescription(description);
            if (permViewCtrl.equals("false")) {
                pd.setPermViewCtrl(Boolean.valueOf(true));
            } else {
                pd.setPermViewCtrl(Boolean.valueOf(false));
            }
            if (!StringUtil.isEmpty((String)icon)) {
                pd.setIcon(icon);
            }
            this.portletDefinitionService.modifyPortlet(this.getPortalContext(), pd);
            this.writeData("result", result);
        }
        catch (PortalBizException e) {
            this.writeData("result", resultErr);
            this.writeAjaxData(false, e.getLocalErr(this.getPortalContext()), "");
        }
        return null;
    }

    public PortletModel getPortletModel() {
        return this.portletModel;
    }

    public void setPortletModel(PortletModel portletModel) {
        this.portletModel = portletModel;
    }
}

