/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.portal.module.report.action;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.report.common.BaseVarProvider;
import com.kingdee.portal.biz.module.report.entity.SimpleReport;
import com.kingdee.portal.biz.module.report.service.DataBuilder;
import com.kingdee.portal.biz.module.report.service.SimpleReportService;
import com.kingdee.portal.biz.module.report.service.impl.DataBuilderFactory;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;

public class SimpleReportAction
extends BaseAction {
    private static final long serialVersionUID = 2837971333524984918L;
    private SimpleReportService simpleReportService = (SimpleReportService)PortalServiceLocator.getBean((String)"simpleReportService");
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");
    private PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();

    public String openReportDetail() {
        String id = this.getRequest().getParameter("id");
        SimpleReport simpleReport = null;
        if (id != null) {
            if (!FilterSpecialCharactersTool.isUUID((String)id)) {
                return null;
            }
            try {
                simpleReport = this.simpleReportService.findById(this.getPortalContext(), id);
                PortletDefinition portletDefinition = this.portletDefinitionServiceFacade.findPortletDefinitionById(this.getPortalContext(), simpleReport.getPortletId());
                this.getRequest().setAttribute("portletDefinition", (Object)portletDefinition);
            }
            catch (PortalBizException e) {
                this.handleErr((Exception)((Object)e));
            }
        } else {
            simpleReport = new SimpleReport();
            simpleReport.setId("");
            simpleReport.setName("{\"zh_CN\":\"\",\"en\":\"\",\"zh_TW\":\"\"}");
            simpleReport.setDesc("{\"zh_CN\":\"\",\"en\":\"\",\"zh_TW\":\"\"}");
        }
        try {
            List portletCategoryList = this.portletCategoryService.findCategoryList(this.getPortalContext(), "categoryName", "ASC");
            this.getRequest().setAttribute("portletCategoryList", (Object)portletCategoryList);
        }
        catch (PortalBizException e) {
            this.handleErr((Exception)((Object)e));
        }
        this.getRequest().setAttribute("simpleReport", (Object)simpleReport);
        return "openSimpleReport";
    }

    public void saveReportDetail() {
        String id = this.getRequest().getParameter("id");
        String name = this.getRequest().getParameter("name");
        String desc = this.getRequest().getParameter("desc");
        String categoryId = this.getRequest().getParameter("categoryId");
        String icon = this.getRequest().getParameter("icon");
        if (id != null && !"".equals(id)) {
            try {
                SimpleReport simpleReport = this.simpleReportService.findById(this.getPortalContext(), id);
                simpleReport.setName(name);
                simpleReport.setDesc(desc);
                simpleReport.setCategoryId(categoryId);
                simpleReport.setIcon(icon);
                SimpleReport sr = this.simpleReportService.update(this.getPortalContext(), simpleReport);
                this.writeAjaxData(true, null, sr);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
        } else {
            SimpleReport simpleReport = new SimpleReport();
            simpleReport.setName(name);
            simpleReport.setDesc(desc);
            simpleReport.setCategoryId(categoryId);
            simpleReport.setIcon(icon);
            try {
                SimpleReport sr = this.simpleReportService.create(this.getPortalContext(), simpleReport);
                this.writeAjaxData(true, null, sr);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
        }
    }

    public void findList() {
        PortalContext ctx = this.getPortalContext();
        PagingResult simpleReports = null;
        try {
            simpleReports = this.simpleReportService.findList(ctx, this.pagingParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            simpleReports = new PagingResult();
        }
        this.writePagingResult(simpleReports);
    }

    public void delete() {
        String id = this.getRequest().getParameter("id");
        if (id != null && !"".equals(id)) {
            try {
                this.simpleReportService.delete(this.getPortalContext(), id);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
            this.writeAjaxData(true, null, null);
        }
    }

    public String openDesigner() {
        String id = this.getRequest().getParameter("id");
        if (id != null && !"".equals(id)) {
            try {
                SimpleReport simpleReport = this.simpleReportService.findById(this.getPortalContext(), id);
                this.getRequest().setAttribute("id", (Object)id);
                this.getRequest().setAttribute("simpleReport", (Object)simpleReport);
            }
            catch (PortalBizException e) {
                this.handleErr((Exception)((Object)e));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return "simpleReportDesigner";
    }

    public String getChooseColumn() {
        String reportSql = this.getRequest().getParameter("reportSql");
        String chartType = this.getRequest().getParameter("chartType");
        String showStyle = this.getRequest().getParameter("showStyle");
        reportSql = this.modifyReportSql(reportSql);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String result = this.simpleReportService.getChooseColumn(ctx, reportSql, chartType, showStyle);
        this.writeData2Response(this.getResponse(), result);
        return null;
    }

    public String getColumn() {
        String reportSql = this.getRequest().getParameter("reportSql");
        reportSql = this.modifyReportSql(reportSql);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String result = this.simpleReportService.getColumn(ctx, reportSql);
        this.writeData2Response(this.getResponse(), result);
        return null;
    }

    public String previewReport() {
        String reportSql = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("reportSql"));
        String x_axis = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("x_axis"));
        String y_axis = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("y_axis"));
        String countName = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("countName"));
        String countValue = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("countValue"));
        String chartType = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("chartType"));
        String chartName = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("chartName"));
        reportSql = this.modifyReportSql(reportSql);
        this.logger.info("reportSql:" + reportSql + ",x_axis:" + x_axis + ",y_axis:" + y_axis + ",countName:" + countName + ",countValue:" + countValue + ",chartType:" + chartType + ",chartName:" + chartName);
        String[] xAxisArray = null;
        String[] yAxisArray = null;
        String[] countNameArray = null;
        String[] countValueArray = null;
        if (x_axis != null && !"".equals(x_axis)) {
            xAxisArray = x_axis.split(",");
        }
        if (y_axis != null && !"".equals(y_axis)) {
            yAxisArray = y_axis.split(",");
        }
        if (countName != null && !"".equals(countName)) {
            countNameArray = countName.split(",");
        }
        if (countValue != null && !"".equals(countValue)) {
            countValueArray = countValue.split(",");
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        DataBuilder dataBuilder = DataBuilderFactory.getDataBuilder((String)chartType);
        String reportData = dataBuilder.getReportData(ctx, reportSql, xAxisArray, yAxisArray, countNameArray, countValueArray);
        this.getRequest().setAttribute("reportData", (Object)reportData);
        this.getRequest().setAttribute("chartName", (Object)chartName);
        return "previewReport";
    }

    public String previewPortletReport() {
        String reportSql = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("reportSql"));
        String x_axis = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("x_axis"));
        String y_axis = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("y_axis"));
        String countName = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("countName"));
        String countValue = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("countValue"));
        String chartType = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("chartType"));
        String chartName = StringEscapeUtils.escapeSql((String)this.getRequest().getParameter("chartName"));
        String insId = this.getRequest().getParameter("insId");
        reportSql = this.modifyReportSql(reportSql);
        this.logger.info("reportSql:" + reportSql + ",x_axis:" + x_axis + ",y_axis:" + y_axis + ",countName:" + countName + ",countValue:" + countValue + ",chartType:" + chartType + ",chartName:" + chartName + ",insId=" + insId);
        String[] xAxisArray = null;
        String[] yAxisArray = null;
        String[] countNameArray = null;
        String[] countValueArray = null;
        if (x_axis != null && !"".equals(x_axis)) {
            xAxisArray = x_axis.split(",");
        }
        if (y_axis != null && !"".equals(y_axis)) {
            yAxisArray = y_axis.split(",");
        }
        if (countName != null && !"".equals(countName)) {
            countNameArray = countName.split(",");
        }
        if (countValue != null && !"".equals(countValue)) {
            countValueArray = countValue.split(",");
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        DataBuilder dataBuilder = DataBuilderFactory.getDataBuilder((String)chartType);
        String reportData = dataBuilder.getReportData(ctx, reportSql, xAxisArray, yAxisArray, countNameArray, countValueArray);
        this.getRequest().setAttribute("reportData", (Object)reportData);
        this.getRequest().setAttribute("chartName", (Object)chartName);
        this.getRequest().setAttribute("insId", (Object)insId);
        return "previewPortletReport";
    }

    public String previewReportTable() {
        String reportSql = this.getRequest().getParameter("reportSql");
        reportSql = this.modifyReportSql(reportSql);
        String selectColumns = this.getRequest().getParameter("selectColumns");
        String alignValue = this.getRequest().getParameter("alignValue");
        String widthValue = this.getRequest().getParameter("widthValue");
        this.logger.info("previewReportTable reportSql:" + reportSql + ",selectColumns:" + selectColumns + ",alignValue:" + alignValue + ",widthValue:" + widthValue);
        this.getRequest().setAttribute("reportSql", (Object)reportSql);
        this.getRequest().setAttribute("selectColumns", (Object)selectColumns);
        this.getRequest().setAttribute("alignValue", (Object)alignValue);
        this.getRequest().setAttribute("widthValue", (Object)widthValue);
        return "previewReportTable";
    }

    public String previewPortletReportTable() {
        String reportSql = this.getRequest().getParameter("reportSql");
        reportSql = this.modifyReportSql(reportSql);
        String selectColumns = this.getRequest().getParameter("selectColumns");
        String alignValue = this.getRequest().getParameter("alignValue");
        String widthValue = this.getRequest().getParameter("widthValue");
        String insId = this.getRequest().getParameter("insId");
        this.logger.info("previewReportTable reportSql:" + reportSql + ",selectColumns:" + selectColumns + ",alignValue:" + alignValue + ",widthValue:" + widthValue + ",insId:" + insId);
        this.getRequest().setAttribute("reportSql", (Object)reportSql);
        this.getRequest().setAttribute("selectColumns", (Object)selectColumns);
        this.getRequest().setAttribute("alignValue", (Object)alignValue);
        this.getRequest().setAttribute("widthValue", (Object)widthValue);
        this.getRequest().setAttribute("insId", (Object)insId);
        return "previewPortletReportTable";
    }

    public void viewResultSet() {
        PagingResult result = null;
        try {
            String reportSql = this.getRequest().getParameter("reportSql");
            if (!StringUtil.isEmpty((String)reportSql)) {
                this.logger.info("viewResultSet reportSql1:" + reportSql);
                reportSql = URLDecoder.decode(reportSql, "UTF-8");
                this.logger.info("viewResultSet reportSql2:" + reportSql);
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                result = this.simpleReportService.findPagingList(ctx, reportSql, this.pagingParam);
                this.writePagingResult(result);
            }
        }
        catch (Exception ex) {
            this.handleErr(ex);
            result = new PagingResult();
            this.writePagingResult(result);
        }
    }

    public String loadViewResultSet() {
        String reportSql = this.getRequest().getParameter("reportSql");
        reportSql = this.modifyReportSql(reportSql);
        this.logger.info("loadViewResultSet reportSql:" + reportSql);
        this.getRequest().setAttribute("reportSql", (Object)reportSql);
        return "loadViewResultSet";
    }

    public void saveReportDesign() {
        String id = this.getRequest().getParameter("id");
        String reportSql = this.getRequest().getParameter("reportSql");
        String showStyle = this.getRequest().getParameter("showStyle");
        String chartName = this.getRequest().getParameter("chartName");
        String chartType = this.getRequest().getParameter("chartType");
        String chartParams = this.getRequest().getParameter("chartParams");
        String tableAllParams = this.getRequest().getParameter("tableAllParams");
        String tableSelectedParams = this.getRequest().getParameter("tableSelectedParams");
        String tableSelectedAlign = this.getRequest().getParameter("tableSelectedAlign");
        String tableSelectedWidth = this.getRequest().getParameter("tableSelectedWidth");
        reportSql = this.modifyReportSql(reportSql);
        try {
            SimpleReport simpleReport = this.simpleReportService.findById(this.getPortalContext(), id);
            simpleReport.setReportSql(reportSql);
            simpleReport.setShowStyle(showStyle);
            simpleReport.setChartName(chartName);
            simpleReport.setChartType(chartType);
            simpleReport.setChartParams(chartParams);
            simpleReport.setTableAllParams(tableAllParams);
            simpleReport.setTableSelectedParams(tableSelectedParams);
            simpleReport.setTableSelectedAlign(tableSelectedAlign);
            simpleReport.setTableSelectedWidth(tableSelectedWidth);
            this.simpleReportService.update(this.getPortalContext(), simpleReport);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private void writeData2Response(HttpServletResponse response, String data) {
        this.logger.info("-----------------------data:" + data);
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public String loadSystemVar() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        BaseVarProvider varProvider = new BaseVarProvider(ctx);
        List list = varProvider.enumVars();
        this.getRequest().setAttribute("systemVars", (Object)list);
        return "loadSystemVar";
    }

    private String modifyReportSql(String reportSql) {
        String sql = reportSql;
        sql = sql.replaceAll("\n", " ");
        sql = sql.replaceAll("\r", " ");
        return sql;
    }
}

