/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.baidu.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.dto.PortletModel;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiduAction
extends BaseAction {
    private static final long serialVersionUID = -5485635827615170006L;
    private static final Logger logger = LoggerFactory.getLogger(BaiduAction.class);
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");
    private PortletService portletService = (PortletService)PortalServiceLocator.getBean((String)"portletService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");
    private PortletModel portletModel;

    private void writeData(String skey, String svalue) throws Exception {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)skey, (Object)svalue);
        this.writeData2Response(jsonObj.toString());
    }

    private void writeData2Response(String data) {
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public String findPortletList() {
        String appName = this.getRequest().getParameter("appName");
        String labelName = this.getRequest().getParameter("labelName");
        String displayName = this.getRequest().getParameter("displayName");
        try {
            labelName = !labelName.equals("") ? "%," + labelName + ",%" : "%%";
            PagingResult pagingResult = this.portletDefinitionService.findPortletDTOList(this.getPortalContext(), this.pagingParam, appName, labelName, displayName);
            this.writePagingResult(pagingResult);
        }
        catch (PortalBizException pe) {
            logger.error(pe.getMessage());
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
        return null;
    }

    public void savePortlet() throws Exception {
        String pltId = this.getRequest().getParameter("pltId");
        String displayName = this.getRequest().getParameter("displayName");
        String smode = this.getRequest().getParameter("smode");
        String surl = this.getRequest().getParameter("surl");
        String description = this.getRequest().getParameter("description");
        String resultErr = "";
        String result = "";
        try {
            JSONObject jsonObj = new JSONObject();
            if (StringUtils.isEmpty((String)pltId)) {
                PortletParam pa = new PortletParam();
                pa.setDisplayName(new DisplayName(displayName));
                pa.setDescription(new Description(description));
                Preferences preferences = new Preferences();
                preferences.addPreference(new Preference("importMode", smode));
                preferences.addPreference(new Preference("address", surl));
                pa.setPreferences(preferences);
                PortletDefinition plt = this.portletDefinitionService.copyPortletDefinition(this.getPortalContext(), "plt_widget", "BaiduPortlet", pa);
                result = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.success");
                resultErr = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.err");
                jsonObj.put((Object)"result", (Object)result);
                jsonObj.put((Object)"pltId", (Object)plt.getId());
            } else {
                result = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.modify");
                resultErr = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.modifyerr");
                PortletDefinition plt = this.portletDefinitionService.findPortletDefinitionById(pltId);
                if (plt == null) {
                    result = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.norecord");
                } else {
                    plt.setDisplayName(displayName);
                    plt.setDescription(description);
                    if (plt.getPreferences() != null) {
                        Preferences preferences = PortletHelper.convPreferences((String)plt.getPreferences());
                        if (preferences != null) {
                            ArrayList<String> modes = new ArrayList<String>();
                            modes.add(smode);
                            ArrayList<String> urls = new ArrayList<String>();
                            urls.add(surl);
                            for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                                if (((Preference)preferences.getPreferences().get(i)).getName().equals("importMode")) {
                                    ((Preference)preferences.getPreferences().get(i)).setValues(modes);
                                }
                                if (!((Preference)preferences.getPreferences().get(i)).getName().equals("address")) continue;
                                ((Preference)preferences.getPreferences().get(i)).setValues(urls);
                            }
                        }
                        plt.setPreferences(preferences.toString());
                    } else {
                        Preferences preferences = new Preferences();
                        preferences.addPreference(new Preference("importMode", smode));
                        preferences.addPreference(new Preference("address", surl));
                        plt.setPreferences(preferences.toString());
                    }
                    this.portletDefinitionService.modifyPortlet(this.getPortalContext(), plt);
                }
                jsonObj.put((Object)"result", (Object)result);
                jsonObj.put((Object)"pltId", (Object)pltId);
            }
            this.writeData2Response(jsonObj.toString());
        }
        catch (PortalBizException pe) {
            this.writeData("result", resultErr + "     " + pe.getLocalErr(this.getPortalContext()));
        }
        catch (Exception e) {
            this.writeData("result", resultErr + "     " + e.getMessage());
        }
    }

    public String findPltDef() throws Exception {
        String pltId = this.getRequest().getParameter("pltId");
        try {
            PortletDefinition pd = this.portletDefinitionService.findPortletDefinitionById(pltId);
            JSONObject pltDef = new JSONObject();
            pltDef.put((Object)"id", (Object)pd.getId());
            pltDef.put((Object)"displayName", (Object)pd.getDisplayName());
            pltDef.put((Object)"description", (Object)pd.getDescription());
            String mode = "";
            String url = "";
            List prefs = null;
            if (!StringUtil.isEmpty((String)pd.getPreferences())) {
                prefs = PortletHelper.convPreferences((String)pd.getPreferences()).getPreferences();
            }
            if (prefs != null) {
                for (int i = 0; i < prefs.size(); ++i) {
                    if (((Preference)prefs.get(i)).getName().equals("importMode")) {
                        mode = (String)((Preference)prefs.get(i)).getValues().get(0);
                    }
                    if (!((Preference)prefs.get(i)).getName().equals("address")) continue;
                    url = (String)((Preference)prefs.get(i)).getValues().get(0);
                }
            }
            pltDef.put((Object)"mode", (Object)mode);
            pltDef.put((Object)"url", (Object)url);
            this.writeData("result", pltDef.toString());
        }
        catch (PortalBizException e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public void delPorlet() throws Exception {
        String pltId = this.getRequest().getParameter("pltId");
        String resultErr = "";
        try {
            String result = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.del");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.delerr");
            this.portletDefinitionService.delPortletDefinitionById(this.getPortalContext(), pltId);
            this.writeData("result", result);
        }
        catch (PortalBizException pe) {
            this.writeData("result", resultErr + "   " + pe.getLocalErr(this.getPortalContext()));
        }
        catch (Exception e) {
            this.writeData("result", resultErr + "   " + e.getMessage());
        }
    }

    public void saveInstance() throws Exception {
        PortletDefinition pd = new PortletDefinition();
        String insId = this.getRequest().getParameter("pltId");
        String displayName = this.getRequest().getParameter("displayName");
        String smode = this.getRequest().getParameter("smode");
        String surl = this.getRequest().getParameter("surl");
        String resultErr = "";
        String result = "";
        try {
            result = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.modify");
            resultErr = this.i18nService.getText(this.getPortalContext(), "res.widget.i18n.module.baidu.BaiduPortlet", "BaiduPortlet.result.modifyerr");
            this.portletService.modifyBaiduTmplTools(this.getPortalContext(), insId, displayName, smode, surl);
            this.writeData("result", result);
        }
        catch (PortalBizException pe) {
            this.writeData("result", resultErr + "     " + pe.getLocalErr(this.getPortalContext()));
        }
        catch (Exception e) {
            this.writeData("result", resultErr + "     " + e.getMessage());
        }
    }

    public PortletModel getPortletModel() {
        return this.portletModel;
    }

    public void setPortletModel(PortletModel portletModel) {
        this.portletModel = portletModel;
    }
}

