/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.customsearch.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.plt.widget.common.util.WidgetServiceLocator;
import com.kingdee.portal.plt.widget.module.customsearch.dto.MethodDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.SearchDetailDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.ServiceDTO;
import com.kingdee.portal.plt.widget.module.customsearch.service.CustomSearchService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSearchAction
extends BaseAction {
    private static final long serialVersionUID = -5485635827615170006L;
    private static final Logger logger = LoggerFactory.getLogger(CustomSearchAction.class);
    private CustomSearchService customSearchService = (CustomSearchService)WidgetServiceLocator.getBean("customSearchService");
    private PortletService portletService = (PortletService)PortalServiceLocator.getBean((String)"portletService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    private Map<String, Object> serviceList;
    private SearchDetailDTO searchDetailDto;

    public String getSearchResult() {
        boolean succ = true;
        LocalErr localErr = null;
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String findServiceList() {
        boolean succ = true;
        LocalErr localErr = null;
        try {
            this.serviceList = this.customSearchService.findServiceList(this.getPortalContext());
        }
        catch (Exception e) {
            succ = false;
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(succ, localErr, this.serviceList);
        return null;
    }

    public String findMethodDetail() {
        String serviceName = this.searchDetailDto.getServiceName();
        String methodName = this.searchDetailDto.getMethodName();
        try {
            this.serviceList = this.customSearchService.findServiceList(this.getPortalContext());
            if (this.serviceList != null) {
                List methods;
                List services = (List)this.serviceList.get("services");
                if (services != null) {
                    for (Object sv : services) {
                        if (!serviceName.equals(((ServiceDTO)sv).getServiceName())) continue;
                        this.searchDetailDto.setServiceDesc(((ServiceDTO)sv).getServiceDesc());
                    }
                }
                if ((methods = (List)this.serviceList.get(serviceName)) != null) {
                    for (MethodDTO mt : methods) {
                        if (!methodName.equals(mt.getMethodName())) continue;
                        this.searchDetailDto.setMethodDesc(mt.getMethodDesc());
                    }
                }
                List params = (List)this.serviceList.get(methodName);
                this.searchDetailDto.setParams(params);
                List rcs = (List)this.serviceList.get(methodName + "-rcs");
                this.searchDetailDto.setResultColumns(rcs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public void saveDetail() {
        boolean succ = true;
        LocalErr localErr = null;
        try {
            this.customSearchService.saveDetail(this.getPortalContext(), this.searchDetailDto);
        }
        catch (Exception e) {
            succ = false;
            localErr = this.handleErr(e);
            logger.error(e.getMessage());
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void buildSearchAllData() {
        boolean succ = true;
        LocalErr localErr = null;
        Map<String, Object> map = null;
        String insId = this.getRequest().getParameter("insId");
        String viewSource = "";
        try {
            Preferences preferences;
            PortletRuntimePreferences prefs = this.portletService.findPortletRuntimePreferencesByInsId(this.getPortalContext(), insId);
            if (prefs != null && (preferences = PortletHelper.convPreferences((String)prefs.getPreferences())) != null) {
                for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                    if (!((Preference)preferences.getPreferences().get(i)).getName().equals("viewSource")) continue;
                    viewSource = (String)((Preference)preferences.getPreferences().get(i)).getValues().get(0);
                }
            }
            this.searchDetailDto.setViewSource(viewSource);
            map = this.customSearchService.buildSearchAllData(this.getPortalContext(), this.searchDetailDto);
        }
        catch (Exception e) {
            succ = false;
            localErr = this.handleErr(e);
            logger.error(e.getMessage());
        }
        this.writeAjaxData(succ, localErr, map);
    }

    public Map<String, Object> getServiceList() {
        return this.serviceList;
    }

    public void setServiceList(Map<String, Object> serviceList) {
        this.serviceList = serviceList;
    }

    public SearchDetailDTO getSearchDetailDto() {
        return this.searchDetailDto;
    }

    public void setSearchDetailDto(SearchDetailDTO searchDetailDto) {
        this.searchDetailDto = searchDetailDto;
    }
}

