/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.customsearch.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.plt.widget.module.customsearch.dto.MethodDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.MethodParamsDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.ResultColumnDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.SearchDetailDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.SearchParamDTO;
import com.kingdee.portal.plt.widget.module.customsearch.dto.ServiceDTO;
import com.kingdee.portal.plt.widget.module.customsearch.service.CustomSearchService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class CustomSearchServiceImpl
implements CustomSearchService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");

    @Override
    public Map<String, Object> getSearchResult(PortalContext ctx, String serviceId, String viewId) throws PortalBizException {
        return null;
    }

    @Override
    public Map<String, Object> findServiceList(PortalContext ctx) throws PortalBizException {
        return this.getTemplData(ctx);
    }

    public Map<String, Object> getServiceListFromBSF(PortalContext ctx) throws PortalBizException {
        return null;
    }

    @Override
    public int saveDetail(PortalContext ctx, SearchDetailDTO sd) throws PortalBizException {
        int result = 0;
        PortletParam param = new PortletParam();
        param.setDisplayName(new DisplayName(sd.getDisplayName()));
        param.setDescription(new Description(sd.getDescription()));
        String portletName = "CustomSearchListPortlet";
        Preferences prefs = new Preferences();
        prefs.addPreference(new Preference("viewSource", sd.getViewSource()));
        prefs.addPreference(new Preference("serviceName", sd.getServiceName()));
        prefs.addPreference(new Preference("methodName", sd.getMethodName()));
        prefs.addPreference(new Preference("serviceDesc", sd.getServiceDesc()));
        prefs.addPreference(new Preference("methodDesc", sd.getMethodDesc()));
        prefs.addPreference(new Preference("displayName", sd.getDisplayName()));
        prefs.addPreference(new Preference("description", sd.getDescription()));
        param.setPreferences(prefs);
        this.portletDefinitionService.copyPortletDefinition(ctx, "plt_widget", portletName, param, "");
        return result;
    }

    @Override
    public Map<String, Object> buildSearchAllData(PortalContext ctx, SearchDetailDTO sd) throws PortalBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (sd != null && sd.getViewSource() != null) {
            String viewSource = sd.getViewSource();
            try {
                System.currentTimeMillis();
                Document document = DocumentHelper.parseText((String)viewSource);
                Element root = document.getRootElement();
                result.put("search", this.getSearchParam(root));
                PagingResult pg = (PagingResult)this.getResult(ctx, root, sd);
                result.put("result", pg.getRecords());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private List<SearchParamDTO> getSearchParam(Element root) {
        ArrayList<SearchParamDTO> param = new ArrayList<SearchParamDTO>();
        Element str = root.element("search");
        List lt = str.elements();
        for (int i = 0; i < lt.size(); ++i) {
            DefaultElement de = (DefaultElement)lt.get(i);
            List at = de.attributes();
            SearchParamDTO mp = new SearchParamDTO();
            for (int j = 0; j < at.size(); ++j) {
                DefaultAttribute da = (DefaultAttribute)at.get(j);
                if ("label".equals(da.getName())) {
                    mp.setLabel(da.getText());
                }
                if (!"name".equals(da.getName())) continue;
                mp.setInputString("<input type=\"text\" name=\"" + da.getText() + "\" id=\"" + da.getText() + "\">");
            }
            param.add(mp);
        }
        return param;
    }

    private Object getResult(PortalContext ctx, Element root, SearchDetailDTO sd) {
        try {
            Map<String, Object> map = this.getTemplData(ctx);
            List services = (List)map.get("services");
            Class<?> clazz = null;
            if (services != null) {
                for (ServiceDTO sv : services) {
                    if (!sd.getServiceName().equals(sv.getServiceName())) continue;
                    ServiceDTO svd = sv;
                    clazz = Class.forName(sv.getInterfaceName());
                    svd.getPortletId();
                }
            }
            List params = (List)map.get(sd.getMethodName());
            Class[] partypes = new Class[params.size()];
            Object[] arg = new Object[params.size()];
            PagingParam pg = new PagingParam();
            pg.setPageNo(1);
            pg.setPageSize(10);
            arg[0] = pg;
            arg[1] = "";
            arg[2] = "";
            arg[3] = "%%";
            for (int i = 0; i < params.size(); ++i) {
                partypes[i] = ((MethodParamsDTO)params.get(i)).getParamType().equals("String") ? ((MethodParamsDTO)params.get(i)).getParamType().getClass() : Class.forName(((MethodParamsDTO)params.get(i)).getParamType());
            }
            if (clazz != null) {
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod(sd.getMethodName(), partypes);
                return method.invoke(obj, arg);
            }
        }
        catch (Exception e) {
            this.logger.equals(e);
        }
        return null;
    }

    public Map<String, Object> getTemplData(PortalContext ctx) throws PortalBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<ResultColumnDTO> rcs = new ArrayList<ResultColumnDTO>();
        ResultColumnDTO rc = new ResultColumnDTO();
        rc.setColomnName("displayName");
        rc.setColomnDesc("\u663e\u793a\u540d\u79f0");
        rcs.add(rc);
        rc.setColomnName("appName");
        rc.setColomnDesc("\u5e94\u7528\u5305\u540d\u79f0");
        rcs.add(rc);
        rc.setColomnName("categoryName");
        rc.setColomnDesc("\u5206\u7c7b\u540d\u79f0");
        rcs.add(rc);
        rc.setColomnName("status");
        rc.setColomnDesc("\u72b6\u6001");
        rcs.add(rc);
        rc.setColomnName("description");
        rc.setColomnDesc("\u63cf\u8ff0");
        rcs.add(rc);
        ArrayList<MethodParamsDTO> params = new ArrayList<MethodParamsDTO>();
        MethodParamsDTO param = new MethodParamsDTO();
        param.setParamName("pagingParam");
        param.setParamType("com.kingdee.portal.biz.common.dao.PagingParam");
        param.setParamDesc("\u5206\u9875\u53c2\u6570");
        param.setIsRequired("true");
        params.add(param);
        MethodParamsDTO param2 = new MethodParamsDTO();
        param2.setParamName("appName");
        param2.setParamType("String");
        param2.setParamDesc("\u5e94\u7528\u5305\u540d\u79f0");
        param2.setIsRequired("false");
        params.add(param2);
        MethodParamsDTO param3 = new MethodParamsDTO();
        param3.setParamName("portletName");
        param3.setParamType("String");
        param3.setParamDesc("Portlet\u540d\u79f0");
        param3.setIsRequired("false");
        params.add(param3);
        MethodParamsDTO param4 = new MethodParamsDTO();
        param4.setParamName("displayName");
        param4.setParamType("String");
        param4.setParamDesc("\u663e\u793a\u540d\u79f0");
        param4.setIsRequired("false");
        params.add(param4);
        ArrayList<MethodDTO> methods = new ArrayList<MethodDTO>();
        MethodDTO mt = new MethodDTO();
        mt.setMethodName("findPortletList");
        mt.setMethodDesc("\u6839\u636e\u5e94\u7528\u5305\u540d\u3001\u6807\u7b7e\u53ca\u663e\u793a\u540d\u79f0\u67e5\u627ePortlet\u5217\u8868");
        methods.add(mt);
        ArrayList<ServiceDTO> services = new ArrayList<ServiceDTO>();
        ServiceDTO sv = new ServiceDTO();
        sv.setServiceName("PortletDefinitionService");
        sv.setInterfaceName("com.kingdee.portal.biz.facade.portal.PortalServiceFacade");
        sv.setServiceDesc("Portlet\u5b9a\u4e49\u670d\u52a1");
        sv.setSversion("1.0");
        sv.setServiceModel("BOS.PORTAL");
        sv.setCompatibility("\u5411\u540e\u517c\u5bb9");
        sv.setProductName("BOS7.5");
        services.add(sv);
        map.put("services", services);
        map.put("PortletDefinitionService", methods);
        map.put("findPortletList", params);
        map.put("findPortletList-rcs", rcs);
        return map;
    }
}

