/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.eas.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import java.util.ArrayList;
import java.util.List;

public class EASAction
extends BaseAction {
    private static final long serialVersionUID = 2484666435063724691L;
    private PortletDefinitionService portletDefinitionService = (PortletDefinitionService)PortalServiceLocator.getBean((String)"portletDefinitionService");
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
    private List<PortletDefinition> defs;

    public List<PortletDefinition> getDefs() {
        return this.defs;
    }

    public void setDefs(List<PortletDefinition> defs) {
        this.defs = defs;
    }

    public void findEASPortletList() {
        try {
            List list = this.easService.getPortletList(this.getPortalContext());
            PagingResult pd = new PagingResult();
            if (list != null) {
                int pageNo = this.pagingParam.getPageNo();
                int pageSize = this.pagingParam.getPageSize();
                int firstCount = (pageNo - 1) * pageSize;
                int maxCount = pageNo * pageSize;
                if (maxCount > list.size()) {
                    maxCount = list.size();
                }
                ArrayList resultList = new ArrayList();
                for (int i = firstCount; i < maxCount; ++i) {
                    resultList.add(list.get(i));
                }
                pd.setPagingParam(this.pagingParam);
                pd.setRecords(resultList);
                pd.setTotalCount(list.size());
            }
            this.writePagingResult(pd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createEASPortlet() {
        PortletParam[] params = this.getPortletParams();
        if (params == null || params.length <= 0) {
            this.writeAjaxData(true, null, null);
            return;
        }
        try {
            this.portletDefinitionService.copyOne2ManyPortletDefinition(this.getPortalContext(), "plt_widget", "EASPortlet", params);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private PortletParam[] getPortletParams() {
        int size = this.defs.size();
        if (size <= 0) {
            return null;
        }
        PortletParam[] params = new PortletParam[size];
        PortletDefinition define = null;
        for (int i = 0; i < size; ++i) {
            define = this.defs.get(i);
            Preferences prefs = new Preferences();
            prefs.addPreference(new Preference("portletId", define.getId()));
            prefs.addPreference(new Preference("defUrl", define.getThemeId()));
            prefs.addPreference(new Preference("insUrl", define.getTmplId()));
            PortletParam param = new PortletParam();
            param.setPreferences(prefs);
            param.setDisplayName(this.setDisplayName(define.getDisplayName()));
            param.setDescription(this.setDescription(define.getDescription()));
            params[i] = param;
        }
        return params;
    }

    private DisplayName setDisplayName(String name) {
        DisplayName dis = new DisplayName();
        dis.setZh_CN(name);
        dis.setEn(name);
        dis.setZh_TW(name);
        return dis;
    }

    private Description setDescription(String desc) {
        Description des = new Description();
        des.setEn(desc);
        des.setZh_CN(desc);
        des.setZh_TW(desc);
        return des;
    }
}

