/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.imgmap.action;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PubFileServiceFacade;
import com.kingdee.portal.biz.module.page.dto.MenuItemInfo;
import com.kingdee.portal.biz.module.page.dto.PageDTO;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.widget.common.util.WidgetServiceLocator;
import com.kingdee.portal.plt.widget.module.imgmap.entity.ImgMap;
import com.kingdee.portal.plt.widget.module.imgmap.service.ImgMapService;
import com.kingdee.util.StringUtils;
import java.util.List;

public class ImgMapAction
extends BaseAction {
    private static final long serialVersionUID = 5161366962256933885L;
    private PageDTO pageDto;
    private ImgMapService imgMapService = (ImgMapService)WidgetServiceLocator.getBean("imgMapService");
    private PubFileServiceFacade pubFileServiceFacade = PortalServiceFacade.getPubFileServiceFacade();
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");
    private PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");

    public PageDTO getPageDto() {
        return this.pageDto;
    }

    public void setPageDto(PageDTO pageDto) {
        this.pageDto = pageDto;
    }

    public void setEasService(EASService easService) {
        this.easService = easService;
    }

    public void setImgMapService(ImgMapService imgMapService) {
        this.imgMapService = imgMapService;
    }

    public void findList() {
        PortalContext ctx = this.getPortalContext();
        PagingResult imgMaps = null;
        try {
            imgMaps = this.imgMapService.findList(ctx, this.pagingParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            imgMaps = new PagingResult();
        }
        this.writePagingResult(imgMaps);
    }

    public String openImgMap() {
        String id = this.getRequest().getParameter("id");
        ImgMap imgMap = null;
        if (id != null) {
            if (!FilterSpecialCharactersTool.isUUID((String)id)) {
                return null;
            }
            try {
                imgMap = this.imgMapService.findById(this.getPortalContext(), id);
                PortletDefinition portletDefinition = this.portletDefinitionServiceFacade.findPortletDefinitionById(this.getPortalContext(), imgMap.getPortletId());
                this.getRequest().setAttribute("portletDefinition", (Object)portletDefinition);
            }
            catch (PortalBizException e) {
                this.handleErr((Exception)((Object)e));
            }
        } else {
            imgMap = new ImgMap();
            imgMap.setId("");
            imgMap.setName("{\"zh_CN\":\"\",\"en\":\"\",\"zh_TW\":\"\"}");
            imgMap.setDesc("{\"zh_CN\":\"\",\"en\":\"\",\"zh_TW\":\"\"}");
        }
        try {
            List portletCategoryList = this.portletCategoryService.findCategoryList(this.getPortalContext(), "categoryName", "ASC");
            this.getRequest().setAttribute("portletCategoryList", (Object)portletCategoryList);
        }
        catch (PortalBizException e) {
            this.handleErr((Exception)((Object)e));
        }
        this.getRequest().setAttribute("imgMap", (Object)imgMap);
        return "openImgMap";
    }

    public void save() {
        String id = this.getRequest().getParameter("id");
        String name = this.getRequest().getParameter("name");
        String desc = this.getRequest().getParameter("desc");
        String categoryId = this.getRequest().getParameter("categoryId");
        String icon = this.getRequest().getParameter("icon");
        if (id != null && !"".equals(id)) {
            try {
                ImgMap imgMap = this.imgMapService.findById(this.getPortalContext(), id);
                imgMap.setName(name);
                imgMap.setDesc(desc);
                imgMap.setCategoryId(categoryId);
                imgMap.setIcon(icon);
                this.imgMapService.update(this.getPortalContext(), imgMap);
                this.writeAjaxData(true, null, null);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
        } else {
            ImgMap imgMap = new ImgMap();
            imgMap.setName(name);
            imgMap.setDesc(desc);
            imgMap.setStatus(StatusEnum.ENABLE);
            imgMap.setCategoryId(categoryId);
            imgMap.setIcon(icon);
            try {
                ImgMap ig = this.imgMapService.create(this.getPortalContext(), imgMap);
                this.writeAjaxData(true, null, (Object)ig);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
        }
    }

    public void delete() {
        String id = this.getRequest().getParameter("id");
        if (id != null && !"".equals(id)) {
            try {
                this.imgMapService.delete(this.getPortalContext(), id);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
            this.writeAjaxData(true, null, null);
        }
    }

    public String openDesigner() {
        String id = this.getRequest().getParameter("id");
        if (!FilterSpecialCharactersTool.isUUID((String)id)) {
            return null;
        }
        if (!StringUtils.isEmpty((String)id)) {
            try {
                ImgMap imgMap = this.imgMapService.findById(this.getPortalContext(), id);
                this.getRequest().setAttribute("id", (Object)id);
                this.getRequest().setAttribute("imgMap", (Object)imgMap);
                FileModel fileModel = this.pubFileServiceFacade.findFileModelByPubFileId(this.getPortalContext(), imgMap.getAttachmentId());
                this.getRequest().getSession().setAttribute("last_upload_img", (Object)fileModel);
            }
            catch (PortalBizException e) {
                this.handleErr((Exception)((Object)e));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return "imgMapDesigner";
    }

    public void publish() {
        String id = this.getRequest().getParameter("id");
        String htmlContent = this.replaceSpecialCharacters(this.getRequest().getParameter("htmlContent"));
        String canvasContent = this.getRequest().getParameter("canvasContent");
        if (id != null && !"".equals(id)) {
            try {
                ImgMap imgMap = this.imgMapService.findById(this.getPortalContext(), id);
                imgMap.setHtmlContent(htmlContent);
                imgMap.setCanvasContent(canvasContent);
                FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("last_upload_img");
                this.imgMapService.publish(this.getPortalContext(), imgMap, fileModel);
                this.getRequest().getSession().removeAttribute("last_upload_img");
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
            catch (Exception t) {
                t.printStackTrace();
                this.writeAjaxData(false, this.handleErr(t), null);
            }
        }
        this.writeAjaxData(true, null, null);
    }

    private String replaceSpecialCharacters(String htmlContent) {
        String realHtmlContent = htmlContent;
        if (!StringUtils.isEmpty((String)htmlContent)) {
            realHtmlContent = htmlContent.replaceAll("#SpecialChar1#", "<img").replaceAll("#SpecialChar2#", "</img>").replaceAll("#SpecialChar3#", "<map").replaceAll("#SpecialChar4#", "</map>").replaceAll("#SpecialChar5#", "<area").replaceAll("#SpecialChar6#", "</area>").replaceAll("#SpecialChar7#", "javascript:").replaceAll("#SpecialChar8#", "<").replaceAll("#SpecialChar9#", ">");
        }
        return realHtmlContent;
    }

    public void getExternalLinkList() {
        String id = this.getRequest().getParameter("MainMenuItemId");
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fname_l2 fname, flongnumber, fparent, flevel, fisleaf, fuiclassname,fimagepath,fuiclassparam,fuioprt,fopenmethod ");
        sb.append("from  T_PM_MainMenuItem where fid='");
        sb.append(id);
        sb.append("'");
        PortalContext ctx = this.getPortalContext();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        MenuItemInfo item = new MenuItemInfo();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sb.toString());
            while (rs.next()) {
                item = new MenuItemInfo();
                item.setId(rs.getString("fid"));
                String name = rs.getString("fname");
                if (name == null) {
                    name = "";
                }
                item.setName(name);
                item.setParentId(rs.getString("fparent"));
                item.setUiClassName(rs.getString("fuiclassname"));
                item.setLongNumber(rs.getString("flongnumber"));
                item.setLeaf(rs.getBoolean("fisleaf"));
                item.setLevel(rs.getInt("flevel"));
                item.setImagePath(rs.getString("fimagepath"));
                item.setUiClassParam(rs.getString("fuiclassparam"));
                item.setUiOprt(rs.getString("fuioprt"));
                item.setOpenMethod(rs.getString("fopenmethod"));
            }
            this.writeAjaxData(true, null, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void unpublish() {
        String id = this.getRequest().getParameter("id");
        if (id != null && !"".equals(id)) {
            try {
                ImgMap imgMap = this.imgMapService.findById(this.getPortalContext(), id);
                this.imgMapService.unpublish(this.getPortalContext(), imgMap);
            }
            catch (PortalBizException e) {
                this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
            }
        }
        this.writeAjaxData(true, null, null);
    }

    public String showEasMenuSelector() {
        String insId = StringUtil.convNull((String)this.getRequest().getParameter("insId"));
        String targetType = StringUtil.convNull((String)this.getRequest().getParameter("targetType"));
        if (!("EAS_GUI_BILL".equalsIgnoreCase(targetType) || "EAS_WEB_BILL".equalsIgnoreCase(targetType) || "OA_WEB_BILL".equalsIgnoreCase(targetType) || "URL".equalsIgnoreCase(targetType))) {
            targetType = "URL";
        }
        if (!FilterSpecialCharactersTool.checkParamsValid((String)insId)) {
            return null;
        }
        this.getRequest().setAttribute("insId", (Object)insId);
        this.getRequest().setAttribute("targetType", (Object)targetType);
        return "easMenuSelector";
    }
}

