/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.imgmap.service.impl;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PubFileServiceFacade;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.biz.module.pub.entity.PubFile;
import com.kingdee.portal.plt.widget.common.exception.conf.WidgetErrConfig;
import com.kingdee.portal.plt.widget.module.imgmap.dao.ImgMapDAO;
import com.kingdee.portal.plt.widget.module.imgmap.entity.ImgMap;
import com.kingdee.portal.plt.widget.module.imgmap.service.ImgMapService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ImgMapServiceImpl
implements ImgMapService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ImgMapDAO imgMapDAO;
    private PubFileServiceFacade pubFileServiceFacade = PortalServiceFacade.getPubFileServiceFacade();
    private PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");

    public void setImgMapDAO(ImgMapDAO imgMapDAO) {
        this.imgMapDAO = imgMapDAO;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<ImgMap> findList(PortalContext ctx, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult pr = this.imgMapDAO.findList((Object)new ImgMap(), pagingParam, new Filter[]{new OrderFilter("createTime", OrderEnum.DESC)});
            List list = pr.getRecords();
            for (ImgMap imgMap : list) {
                String portletId = imgMap.getPortletId();
                PortletDefinition portletDefinition = this.portletDefinitionServiceFacade.findPortletDefinitionById(ctx, portletId);
                if (portletDefinition == null) continue;
                imgMap.setPortletName(portletDefinition.getDisplayName());
                PortletCategory portletCategory = new PortletCategory();
                portletCategory.setId(portletDefinition.getCategoryId());
                portletCategory = this.portletCategoryService.findCategoryById(portletCategory);
                imgMap.setCategoryName(portletCategory.getCategoryName());
            }
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException(WidgetErrConfig.IMGMAP_FIND_ERR, (Throwable)e);
        }
    }

    @Override
    public ImgMap create(PortalContext ctx, ImgMap imgMap) throws PortalBizException {
        try {
            imgMap.setPortalContext(ctx);
            ImgMap imgmapSaved = (ImgMap)((Object)this.imgMapDAO.create((Object)imgMap));
            this.saveOrUpdatePortletDefinition(ctx, imgmapSaved);
            this.imgMapDAO.update((Object)imgmapSaved);
            return imgmapSaved;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException(WidgetErrConfig.IMGMAP_DATA_ACCESS_ERR, (Throwable)e);
        }
    }

    @Override
    public ImgMap update(PortalContext ctx, ImgMap imgMap) throws PortalBizException {
        try {
            imgMap.setPortalContext(ctx);
            this.saveOrUpdatePortletDefinition(ctx, imgMap);
            this.imgMapDAO.update((Object)imgMap);
            return imgMap;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException(WidgetErrConfig.IMGMAP_DATA_ACCESS_ERR, (Throwable)e);
        }
    }

    @Override
    public int delete(PortalContext ctx, String id) throws PortalBizException {
        try {
            ImgMap imgMap = (ImgMap)((Object)this.imgMapDAO.findById(id));
            this.pubFileServiceFacade.delete4UploadImgId(ctx, imgMap.getAttachmentId());
            if (!StringUtil.isEmpty((String)imgMap.getPortletId())) {
                this.portletDefinitionServiceFacade.deletePortletDefinitionById(ctx, imgMap.getPortletId());
            } else {
                this.logger.info("imgmap delete, imgMap.getPortletId() is null.");
            }
            return this.imgMapDAO.deleteById(id);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException(WidgetErrConfig.IMGMAP_DATA_ACCESS_ERR, (Throwable)e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public ImgMap findById(PortalContext ctx, String id) throws PortalBizException {
        try {
            return (ImgMap)((Object)this.imgMapDAO.findById(id));
        }
        catch (DataAccessException e) {
            throw new PortalBizException(WidgetErrConfig.IMGMAP_FIND_ERR, (Throwable)e);
        }
    }

    @Override
    public ImgMap publish(PortalContext ctx, ImgMap imgMap, FileModel fileModel) throws PortalBizException {
        String attId = imgMap.getAttachmentId();
        String htmlContent = imgMap.getHtmlContent();
        if (attId != null) {
            if (fileModel != null) {
                this.pubFileServiceFacade.update4UploadImg(ctx, fileModel, attId);
            }
            htmlContent = htmlContent.replaceFirst("\\{pubFileIdPlaceholder\\}", attId);
        } else {
            PubFile pubFile = this.pubFileServiceFacade.create4UploadImg(ctx, fileModel);
            imgMap.setAttachmentId(pubFile.getId());
            htmlContent = htmlContent.replaceFirst("\\{pubFileIdPlaceholder\\}", pubFile.getId());
        }
        imgMap.setHtmlContent(htmlContent);
        this.saveOrUpdatePortletDefinition(ctx, imgMap);
        imgMap.setStatus(StatusEnum.ENABLE);
        try {
            imgMap.setPortalContext(ctx);
            return (ImgMap)((Object)this.imgMapDAO.update((Object)imgMap));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException(WidgetErrConfig.IMGMAP_DATA_ACCESS_ERR, (Throwable)e);
        }
    }

    private void saveOrUpdatePortletDefinition(PortalContext ctx, ImgMap imgMap) throws PortalBizException {
        PortletParam portletParam = new PortletParam();
        DisplayName displayName = new DisplayName(imgMap.getName());
        portletParam.setDisplayName(displayName);
        Description description = new Description(imgMap.getDesc());
        portletParam.setDescription(description);
        Preferences preferences = new Preferences();
        Preference preference = new Preference("imgMapId", imgMap.getId());
        preferences.addPreference(preference);
        portletParam.setPreferences(preferences);
        portletParam.setCategoryId(imgMap.getCategoryId());
        portletParam.setIcon(imgMap.getIcon());
        portletParam.setStatus(imgMap.getStatus());
        String portletDefinitionId = imgMap.getPortletId();
        PortletDefinition portletDefinition = null;
        if (portletDefinitionId != null) {
            portletDefinition = this.portletDefinitionServiceFacade.findPortletDefinitionById(ctx, portletDefinitionId);
        }
        if (portletDefinition != null) {
            this.portletDefinitionServiceFacade.updatePortletDefinition(ctx, portletDefinitionId, portletParam);
        } else {
            portletDefinition = this.portletDefinitionServiceFacade.createPortletDefinition(ctx, "plt_widget", "ImgMapViewPortlet", portletParam);
            imgMap.setPortletId(portletDefinition.getId());
        }
    }

    @Override
    public ImgMap unpublish(PortalContext ctx, ImgMap imgMap) throws PortalBizException {
        if (!StringUtil.isEmpty((String)imgMap.getPortletId())) {
            this.portletDefinitionServiceFacade.deletePortletDefinitionById(ctx, imgMap.getPortletId());
        } else {
            this.logger.info("imgmap delPortletDefinitionById, imgMap.getPortletId() is null.");
        }
        imgMap.setAttachmentId(null);
        imgMap.setPortletId(null);
        imgMap.setStatus(StatusEnum.DISABLE);
        try {
            imgMap.setPortalContext(ctx);
            return (ImgMap)((Object)this.imgMapDAO.update((Object)imgMap));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException(WidgetErrConfig.IMGMAP_DATA_ACCESS_ERR, (Throwable)e);
        }
    }
}

