/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.shell.action;

import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.widget.common.util.WidgetServiceLocator;
import com.kingdee.portal.plt.widget.module.shell.dto.ShellDTO;
import com.kingdee.portal.plt.widget.module.shell.service.ShellService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ShellAction
extends BaseAction {
    private ShellService shellService = (ShellService)WidgetServiceLocator.getBean("shellService");
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean((String)"portletCategoryService");
    private ShellDTO shellDTO;

    public String findPortletList() {
        try {
            if (FilterSpecialCharactersTool.isContainSQLSpecialCharacters((HttpServletRequest)this.getRequest())) {
                return null;
            }
            PagingResult<PortletDefinition> pagingResult = this.shellService.findPortletList(this.getPortalContext(), this.shellDTO.getDisplayName(), this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String showPortlet() {
        String showPage = this.shellDTO.getShowPage();
        try {
            if (this.shellDTO != null && !StringUtil.isEmpty((String)this.shellDTO.getPortletId())) {
                String pltInsId = this.shellDTO.getPltInsId();
                String hashCode = this.shellDTO.getHashCode();
                this.shellDTO = this.shellService.findPortletInfo(this.getPortalContext(), this.shellDTO.getPortletId());
                this.shellDTO.setPltInsId(pltInsId);
                this.shellDTO.setHashCode(hashCode);
                this.getRequest().setAttribute("shellDTO", (Object)this.shellDTO);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if ("detail4Edit".equals(showPage)) {
            try {
                List portletCategoryList = this.portletCategoryService.findCategoryList(this.getPortalContext(), "categoryName", "ASC");
                this.getRequest().setAttribute("portletCategoryList", (Object)portletCategoryList);
            }
            catch (PortalBizException e) {
                this.handleErr((Exception)((Object)e));
            }
        }
        return showPage;
    }

    public String savePortlet() {
        try {
            this.shellService.saveShellPortlet(this.getPortalContext(), this.shellDTO);
            this.shellDTO.setShowPage("detail4Edit");
            return this.showPortlet();
        }
        catch (Exception ex) {
            LocalErr localErr = this.handleErr(ex);
            this.getRequest().setAttribute("error", (Object)localErr);
            return "error";
        }
    }

    public String deletePortlet() {
        boolean success = true;
        LocalErr localErr = null;
        try {
            this.shellService.deleteShellPortletById(this.getPortalContext(), this.shellDTO.getPortletId());
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, "");
        return null;
    }

    public ShellDTO getShellDTO() {
        return this.shellDTO;
    }

    public void setShellDTO(ShellDTO shellDTO) {
        this.shellDTO = shellDTO;
    }
}

