/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.shell.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.json.Supports;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.widget.module.shell.common.util.Constant;
import com.kingdee.portal.plt.widget.module.shell.dto.ShellDTO;
import com.kingdee.portal.plt.widget.module.shell.service.ShellService;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ShellServiceImpl
implements ShellService {
    @Override
    public PagingResult<PortletDefinition> findPortletList(PortalContext portalContext, String displayName, PagingParam pagingParam) throws PortalBizException {
        PagingResult pagingResult = PortalServiceFacade.getPortletDefinitionServiceFacade().findPortletDefinitionList(portalContext, "plt_widget", "ShellTmplPortlet", displayName, pagingParam);
        return pagingResult;
    }

    @Override
    public ShellDTO findPortletInfo(PortalContext portalContext, String portletId) throws PortalBizException {
        PortletDefinition portletDefinition = PortalServiceFacade.getPortletDefinitionServiceFacade().findPortletDefinitionById(portalContext, portletId);
        if (portletDefinition != null) {
            ShellDTO shellDTO = new ShellDTO();
            shellDTO.setPortletId(portletDefinition.getId());
            shellDTO.setDisplayName(portletDefinition.getDisplayName());
            shellDTO.setDescription(portletDefinition.getDescription());
            shellDTO.setCategoryId(portletDefinition.getCategoryId());
            shellDTO.setIcon(portletDefinition.getIcon());
            String preferencesStr = portletDefinition.getPreferences();
            Preferences preferences = PortletHelper.convPreferences((String)preferencesStr);
            List list = preferences.getPreferences();
            if (list != null) {
                for (Preference pre : list) {
                    String name = pre.getName();
                    if (Constant.MODE_VIEW_PAGE.equals(name)) {
                        shellDTO.setViewPage(((String)pre.getValues().get(0)).toString());
                        continue;
                    }
                    if (Constant.MODE_EDIT_PAGE.equals(name)) {
                        shellDTO.setEditPage(((String)pre.getValues().get(0)).toString());
                        continue;
                    }
                    if (!Constant.MODE_HELP_PAGE.equals(name)) continue;
                    shellDTO.setHelpPage(((String)pre.getValues().get(0)).toString());
                }
            }
            return shellDTO;
        }
        return null;
    }

    @Override
    public void saveShellPortlet(PortalContext portalContext, ShellDTO shellDTO) throws PortalBizException {
        PortletParam portletParam = this.buildPortletParam(shellDTO);
        if (StringUtil.isEmpty((String)shellDTO.getPortletId())) {
            PortletDefinition portletDefinition = PortalServiceFacade.getPortletDefinitionServiceFacade().createPortletDefinition(portalContext, "plt_widget", "ShellTmplPortlet", portletParam);
            shellDTO.setPortletId(portletDefinition.getId());
        } else {
            PortalServiceFacade.getPortletDefinitionServiceFacade().updatePortletDefinition(portalContext, shellDTO.getPortletId(), portletParam);
        }
    }

    @Override
    public void deleteShellPortletById(PortalContext portalContext, String id) throws PortalBizException {
        PortalServiceFacade.getPortletDefinitionServiceFacade().deletePortletDefinitionById(portalContext, id);
    }

    private PortletParam buildPortletParam(ShellDTO shellDTO) {
        Preference preference;
        PortletParam portletParam = new PortletParam();
        if (!StringUtil.isEmpty((String)shellDTO.getDisplayName())) {
            DisplayName displayName = new DisplayName(shellDTO.getDisplayName());
            portletParam.setDisplayName(displayName);
        }
        if (!StringUtil.isEmpty((String)shellDTO.getDescription())) {
            Description description = new Description(shellDTO.getDescription());
            portletParam.setDescription(description);
        }
        if (!StringUtil.isEmpty((String)shellDTO.getIcon())) {
            portletParam.setIcon(shellDTO.getIcon());
        }
        if (!StringUtil.isEmpty((String)shellDTO.getCategoryId())) {
            portletParam.setCategoryId(shellDTO.getCategoryId());
        }
        Preferences preferences = new Preferences();
        if (!StringUtil.isEmpty((String)shellDTO.getViewPage())) {
            preference = new Preference(Constant.MODE_VIEW_PAGE, shellDTO.getViewPage());
            preferences.addPreference(preference);
        }
        if (!StringUtil.isEmpty((String)shellDTO.getEditPage())) {
            preference = new Preference(Constant.MODE_EDIT_PAGE, shellDTO.getEditPage());
            preferences.addPreference(preference);
        }
        if (!StringUtil.isEmpty((String)shellDTO.getHelpPage())) {
            preference = new Preference(Constant.MODE_HELP_PAGE, shellDTO.getHelpPage());
            preferences.addPreference(preference);
        }
        portletParam.setPreferences(preferences);
        Supports supports = new Supports();
        supports.setMimeType("text/html");
        if (!StringUtil.isEmpty((String)shellDTO.getViewPage())) {
            supports.addPortletMode("VIEW");
        }
        if (!StringUtil.isEmpty((String)shellDTO.getEditPage())) {
            supports.addPortletMode("EDIT");
        }
        if (!StringUtil.isEmpty((String)shellDTO.getHelpPage())) {
            supports.addPortletMode("HELP");
        }
        portletParam.setSupports(supports);
        portletParam.setStatus(StatusEnum.ENABLE);
        return portletParam;
    }
}

