/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.single.portlet;

import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class URLPortlet
extends GenericPortlet {
    private static final String default_open_type = "iframe";
    private static final String default_height4Iframe = "300";

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        String url = preferences.getValue("url", "");
        if (!StringUtil.isEmpty((String)url)) {
            url = url.indexOf("?") > 0 ? url + "&_=" + System.currentTimeMillis() : url + "?_=" + System.currentTimeMillis();
        }
        String openType = preferences.getValue("openType", default_open_type);
        String height = preferences.getValue("height", default_height4Iframe);
        String resType = this.getResTypeByUrl(url);
        request.setAttribute("url", (Object)url);
        request.setAttribute("openType", (Object)openType);
        request.setAttribute("height", (Object)height);
        request.setAttribute("resType", (Object)resType);
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/single/url/URLPortlet_view.jsp");
        dispatcher.include(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences preferences = request.getPreferences();
        String url = preferences.getValue("url", "");
        String openType = preferences.getValue("openType", default_open_type);
        String height = preferences.getValue("height", default_height4Iframe);
        request.setAttribute("url", (Object)url);
        request.setAttribute("openType", (Object)openType);
        request.setAttribute("height", (Object)height);
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/single/url/URLPortlet_edit.jsp");
        dispatcher.include(request, response);
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/single/url/URLPortlet_help.jsp");
        dispatcher.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String url = request.getParameter("url");
        String openType = request.getParameter("openType");
        String height = request.getParameter("height");
        if ("auto".equals(openType)) {
            openType = this.buildOpenTypeByAuto(url);
        }
        if (!StringUtil.isEmpty((String)url)) {
            PortletPreferences preferences = request.getPreferences();
            preferences.setValue("url", url);
            preferences.setValue("openType", openType);
            preferences.setValue("height", height);
            preferences.store();
        }
    }

    private String buildOpenTypeByAuto(String url) {
        if (url.startsWith("/portal/")) {
            return "div";
        }
        if (url.startsWith("/plt_")) {
            return "div";
        }
        return default_open_type;
    }

    private String getResTypeByUrl(String url) {
        String _url = StringUtil.convNull((String)url).toLowerCase();
        if (_url.indexOf(".swf?") > 0) {
            return "flash";
        }
        if (_url.indexOf(".gif?") > 0 || _url.indexOf(".jpg?") > 0 || _url.indexOf(".jpeg?") > 0 || _url.indexOf(".png?") > 0 || _url.indexOf(".bmp?") > 0) {
            return "image";
        }
        return "page";
    }
}

