/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.sms.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MAGroupResolventCollection;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.cp.eip.mc.util.ReceiverSelectUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.plt.widget.module.sms.dto.SmsReceiveSchemeDTO;
import com.kingdee.portal.plt.widget.module.sms.service.OrgPersonService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class OrgPersonServiceImpl
implements OrgPersonService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<JSONObject> getRosStr(Context ctx, String orgid) {
        try {
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            MetaDataPK mainQueryPK = null;
            boolean ishasEas = SPManager.isSPInstalled((String)"ReceiverPersonSelectImp");
            mainQueryPK = ishasEas ? new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonReceiverQuery") : new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection fic = filterInfo.getFilterItems();
            fic.add(new FilterItemInfo("AdminOrgUnit.id", (Object)orgid));
            fic.add(new FilterItemInfo("Deletedstatus", (Object)new Integer(1), CompareType.EQUALS));
            if (ishasEas) {
                fic.add(new FilterItemInfo("employeeType.inService", (Object)new Integer(1), CompareType.EQUALS));
            }
            entityViewInfo.setFilter(filterInfo);
            IQueryExecutor exec = null;
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList personCandidates = new ArrayList();
            personCandidates = ReceiverSelectUtil.recordSet2ArrayList((IRowSet)rowSet, null, (boolean)false);
            personCandidates = ReceiverSelectUtil.mergeRows((ArrayList)personCandidates, (String)"id", (String[])new String[]{"AdminOrgUnit.name"});
            for (int i = 0; i < personCandidates.size(); ++i) {
                HashMap map = new HashMap();
                map = (HashMap)personCandidates.get(i);
                JSONObject obj = new JSONObject();
                String id = map.get("id").toString();
                obj.put((Object)"id", (Object)(id == null ? "" : id));
                String number = map.get("number").toString();
                obj.put((Object)"number", (Object)(number == null ? "" : number));
                String name = map.get("name").toString();
                obj.put((Object)"name", (Object)(name == null ? "" : name));
                String adminOrgUnit_name = map.get("AdminOrgUnit.name").toString();
                obj.put((Object)"adminOrgUnit_name", (Object)(adminOrgUnit_name == null ? "" : adminOrgUnit_name));
                result.add(obj);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("--getRosStr--" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<GroupDTO> getOrgList(Context ctx) {
        return this.getOrgList(ctx, null);
    }

    @Override
    public List<GroupDTO> getOrgList(Context ctx, String id) {
        ArrayList<GroupDTO> orgList = new ArrayList<GroupDTO>();
        try {
            IRowSet rowSet = OrgPersonServiceImpl.getAdminRowSet(ctx);
            rowSet.beforeFirst();
            GroupDTO org = null;
            Locale local = ctx.getLocale();
            while (rowSet.next()) {
                AdminOrgUnitInfo adminInfo = OrgPersonServiceImpl.createAdminUnitInfo(rowSet);
                if (adminInfo == null) continue;
                org = new GroupDTO();
                org.setId(adminInfo.getId().toString());
                org.setName(adminInfo.getName(local));
                if (adminInfo.getParent() != null) {
                    org.setParentId(adminInfo.getParent().getId().toString());
                }
                org.setLevel(adminInfo.getLevel());
                org.setLongNumber(adminInfo.getLongNumber());
                org.setLeaf(adminInfo.isIsLeaf());
                org.setDesc(adminInfo.getDisplayName(local));
                org.setNumber(adminInfo.getNumber());
                orgList.add(org);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgList;
    }

    @Override
    public List<JSONObject> fastQueryWithFilter(Context ctx, String cboKey, String txtValue, boolean chkLike, boolean isAdminFilter) {
        if (StringUtils.isEmpty((String)cboKey) || StringUtils.isEmpty((String)txtValue)) {
            return null;
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        IQueryExecutor exec = null;
        MetaDataPK mainQueryPK = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if ("name".equals(cboKey)) {
            if (chkLike) {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)txtValue.trim()));
            }
        } else if (chkLike) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + txtValue.trim() + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)txtValue.trim()));
        }
        if (isAdminFilter && this.isFilterByUserAdminOrgRange(ctx)) {
            try {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)OrgPersonServiceImpl.getCurrentUserAdminOrgRange(ctx), CompareType.INCLUDE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        mainQueryPK = new MetaDataPK("com.kingdee.eas.basedata.person.app", "PersonQuery");
        try {
            entityViewInfo.setFilter(filterInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            IRowSet rowSet = exec.executeQuery();
            ArrayList personCandidates = new ArrayList();
            personCandidates = ReceiverSelectUtil.recordSet2ArrayList((IRowSet)rowSet, null, (boolean)false);
            personCandidates = ReceiverSelectUtil.mergeRows((ArrayList)personCandidates, (String)"id", (String[])new String[]{"AdminOrgUnit.name"});
            String[][] rowDataArray = new String[personCandidates.size()][8];
            for (int i = 0; i < personCandidates.size(); ++i) {
                HashMap map = new HashMap();
                map = (HashMap)personCandidates.get(i);
                JSONObject obj = new JSONObject();
                String id = map.get("id").toString();
                obj.put((Object)"id", (Object)(id == null ? "" : id));
                String number = map.get("number").toString();
                obj.put((Object)"number", (Object)(number == null ? "" : number));
                String name = map.get("name").toString();
                obj.put((Object)"name", (Object)(name == null ? "" : name));
                String adminOrgUnit_name = map.get("AdminOrgUnit.name").toString();
                obj.put((Object)"adminOrgUnit_name", (Object)(adminOrgUnit_name == null ? "" : adminOrgUnit_name));
                result.add(obj);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("-fastQueryWithFilter error!-", (Throwable)e);
            return null;
        }
    }

    @Override
    public PagingResult<SmsReceiveSchemeDTO> getMAGroupResolventCollection(PagingParam pagingParam, Context ctx, EntityViewInfo viewInfo) {
        PagingResult pagingResult = new PagingResult();
        ArrayList<SmsReceiveSchemeDTO> records = new ArrayList<SmsReceiveSchemeDTO>();
        pagingResult.setPagingParam(pagingParam);
        try {
            Locale local = ctx.getLocale();
            MAGroupResolventCollection magcol = MAGroupResolventFactory.getRemoteInstance().getMAGroupResolventCollection(viewInfo);
            Iterator it = magcol.iterator();
            MAGroupResolventInfo info = null;
            boolean i = false;
            while (it.hasNext()) {
                info = (MAGroupResolventInfo)it.next();
                SmsReceiveSchemeDTO smsReceiveSchemeDTO = new SmsReceiveSchemeDTO();
                smsReceiveSchemeDTO.setName(info.getName(local));
                smsReceiveSchemeDTO.setNumber(info.getNumber());
                records.add(smsReceiveSchemeDTO);
            }
            pagingResult.setRecords(records);
            pagingResult.setTotalCount(records.size());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return pagingResult;
    }

    private boolean isFilterByUserAdminOrgRange(Context ctx) {
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            if (Administrator.isCUAdmin((Context)ctx, (IObjectPK)userPK)) {
                return false;
            }
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"isReceiverFilterByAdminRange");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString(9) == null || row.getString(9).equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString(9)));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private JSONArray buildOrgTreeArr(List<GroupDTO> orgList, boolean isSearch) throws PortalBizException {
        JSONArray array = new JSONArray();
        JSONObject treeNode = null;
        for (GroupDTO org : orgList) {
            treeNode = new JSONObject();
            treeNode.put((Object)"id", (Object)org.getId());
            if (!isSearch) {
                treeNode.put((Object)"isParent", (Object)(!org.isLeaf() ? 1 : 0));
                treeNode.put((Object)"pId", (Object)org.getParentId());
                treeNode.put((Object)"open", (Object)false);
            }
            String name = "";
            String desc = "";
            if (org.getName() != null) {
                name = org.getName();
            }
            if (org.getDesc() != null) {
                name = org.getDesc();
            }
            treeNode.put((Object)"name", (Object)name);
            treeNode.put((Object)"desc", (Object)desc);
            array.add((Object)treeNode);
        }
        return array;
    }

    private static IRowSet getAdminRowSet(Context ctx) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        System.out.println("************SQL1: " + queryExcu.getSQL());
        System.out.println("************SQL2: " + queryExcu.getSQL());
        return queryExcu.executeQuery();
    }

    public static Set getCurrentUserAdminOrgRange(Context ctx) throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        HashSet<String> result = new HashSet<String>();
        IOrgRange orgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection coll = orgRange.findFullOrgCol((IObjectPK)userPK, OrgRangeType.ADMIN_ORG_TYPE);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            result.add(coll.get(i).getOrg().getId().toString());
        }
        return result;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

