/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.sms.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.message.IMAGroup;
import com.kingdee.eas.base.message.IMAGroupEntry;
import com.kingdee.eas.base.message.IMAGroupResolvent;
import com.kingdee.eas.base.message.IMAGroupResolventEntry;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupResolventEntryFactory;
import com.kingdee.eas.base.message.MAGroupResolventEntryInfo;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.IMobileMessageAssign;
import com.kingdee.eas.mobile.MobileMessageAssignFactory;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.plt.widget.module.sms.service.SendMsgService;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class SendMsgServiceImpl
implements SendMsgService {
    private static Logger logger = Logger.getLogger((String)SendMsgServiceImpl.class.getName());

    @Override
    public String getCellByIds(Context ctx, String names) {
        String result = "";
        boolean isSuppTelNo = this.isSMSSupportInputTelNo(ctx);
        if (!StringUtils.isEmpty((String)names)) {
            String[] receiverArray = names.split(",");
            StringBuffer phoneStrBf = new StringBuffer();
            StringBuffer receiverBf = new StringBuffer();
            for (int i = 0; i < receiverArray.length; ++i) {
                if (SendMsgServiceImpl.isDigitStr(receiverArray[i]) && this.isCellphoneNumber(receiverArray[i]) && isSuppTelNo) {
                    if (phoneStrBf.length() == 0) {
                        phoneStrBf.append(receiverArray[i]);
                        continue;
                    }
                    phoneStrBf.append(",");
                    phoneStrBf.append(receiverArray[i]);
                    continue;
                }
                if (receiverBf.length() == 0) {
                    receiverBf.append(receiverArray[i]);
                    continue;
                }
                receiverBf.append(",");
                receiverBf.append(receiverArray[i]);
            }
            if (!StringUtils.isEmpty((String)receiverBf.toString())) {
                result = this.getPhoneNumberByName(ctx, receiverBf.toString());
            }
            int index = -1;
            if (!StringUtils.isEmpty((String)result)) {
                index = result.indexOf("&");
            }
            if (!StringUtils.isEmpty((String)phoneStrBf.toString())) {
                if (index == -1) {
                    result = phoneStrBf + "&" + result;
                } else if (index >= 0) {
                    result = phoneStrBf + "," + result;
                }
            }
        }
        return result;
    }

    @Override
    public JSONObject checkSendMsg(Context ctx, String receives, String content) {
        JSONObject returnObj = new JSONObject();
        int sendCountUser = receives.split(",").length;
        int sengCount = (content.length() - 1) / 70 + 1;
        try {
            if (this.isLimitSendCount(ctx)) {
                String userId = ctx.getCaller().toString();
                IMobileMessageAssign iMobile = MobileMessageAssignFactory.getRemoteInstance();
                String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                int sendCount = sendCountUser * sengCount;
                int sendedCount = iMobile.getSendedCountByUserId(userId, cuID);
                int cansendCount = iMobile.canSendCount(userId, cuID);
                int canSendTotal = cansendCount - sendedCount;
                if (canSendTotal < 0) {
                    canSendTotal = 0;
                }
                String sms_send_to = ResourceBase.getString((String)"com.kingdee.eas.mobile.client.SmsResource", (String)"sms_send_to", (Locale)ctx.getOriginLocale());
                String user_total_count = ResourceBase.getString((String)"com.kingdee.eas.mobile.client.SmsResource", (String)"user_total_count", (Locale)ctx.getOriginLocale());
                String can_still_send = ResourceBase.getString((String)"com.kingdee.eas.mobile.client.SmsResource", (String)"can_still_send", (Locale)ctx.getOriginLocale());
                String count_sms = ResourceBase.getString((String)"com.kingdee.eas.mobile.client.SmsResource", (String)"count_sms", (Locale)ctx.getOriginLocale());
                String can_not_send = ResourceBase.getString((String)"com.kingdee.eas.mobile.client.SmsResource", (String)"can_not_send", (Locale)ctx.getOriginLocale());
                String msg = sms_send_to + " " + sendCountUser + " " + user_total_count + " " + sendCount + can_still_send + " " + canSendTotal + " " + count_sms;
                if (sendCount + sendedCount > cansendCount) {
                    returnObj.put((Object)"result", (Object)false);
                    msg = msg + can_not_send;
                } else {
                    returnObj.put((Object)"result", (Object)true);
                }
                returnObj.put((Object)"data", (Object)msg);
            } else {
                returnObj.put((Object)"result", (Object)true);
                returnObj.put((Object)"data", (Object)"");
            }
        }
        catch (Exception e) {
            logger.error((Object)"WEB\u77ed\u4fe1\u53d1\u9001\u68c0\u67e5\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return returnObj;
    }

    @Override
    public boolean sendMsgHasAppend(SendMessageParamInfo messageParamInfo) {
        try {
            boolean result = MsgFacadeFactory.getRemoteInstance().sendMsg(messageParamInfo);
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean sendMsgHasAppend(Context ctx, SendMessageParamInfo messageParamInfo) {
        try {
            boolean result = MsgFacadeFactory.getLocalInstance((Context)ctx).sendMsg(messageParamInfo);
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isSMSSupportInputTelNo(Context ctx) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"SMSSupportInputTelNo");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97SMSSupportInputTelNo\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private String getPhoneNumberByName(Context ctx, String ids) {
        if (ids == null || ids.equals("")) {
            return "";
        }
        String[] tempIds = ids.split(",");
        if (tempIds.length == 0) {
            return "";
        }
        StringBuffer cellNumber = new StringBuffer();
        StringBuffer noneCellNumberPerson = new StringBuffer();
        String local = ctx.getLocale().toString();
        String sql = "";
        if (local.equals("l1")) {
            sql = "SELECT FCell, FName_L1 FName FROM T_BD_Person where FId = ?";
        } else if (local.equals("l2")) {
            sql = "SELECT FCell, FName_L2 FName FROM T_BD_Person where FId = ?";
        } else if (local.equals("l3")) {
            sql = "SELECT FCell, FName_L3 FName FROM T_BD_Person where FId = ?";
        }
        try {
            int num = tempIds.length;
            for (int i = 0; i < num; ++i) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{tempIds[i]});
                if (rs.next()) {
                    String tempCellNumber = rs.getString("FCell");
                    String personName = rs.getString("FName");
                    if (tempCellNumber != null && !tempCellNumber.equals("")) {
                        cellNumber.append(tempCellNumber);
                        cellNumber.append(",");
                        continue;
                    }
                    noneCellNumberPerson.append(personName);
                    noneCellNumberPerson.append(",");
                    continue;
                }
                noneCellNumberPerson.append(tempIds[i]);
                noneCellNumberPerson.append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = cellNumber.toString() + "&" + noneCellNumberPerson.toString();
        return result;
    }

    @Override
    public String getMagtoPersonId(Context ctx, IMAGroupResolvent imag, String magid) throws EASBizException, BOSException {
        IPerson ip = PersonFactory.getRemoteInstance();
        IMAGroupResolventEntry ire = MAGroupResolventEntryFactory.getRemoteInstance();
        IMAGroup im = MAGroupFactory.getRemoteInstance();
        IMAGroupEntry ime = MAGroupEntryFactory.getRemoteInstance();
        String personid = "";
        StringBuffer sb = new StringBuffer();
        MAGroupResolventInfo info = imag.getMAGroupResolventInfo("select * where number = '" + magid + "'");
        for (int i = 0; i < info.getEntries().size(); ++i) {
            MAGroupResolventEntryInfo entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(info.getEntries().get(i).getId().toString()));
            MAGroupInfo magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
            if (magroupInfo == null) continue;
            for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                PersonInfo personInfo;
                MAGroupEntryInfo magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString())) || (personInfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(personid))) == null) continue;
                if (StringUtils.isEmpty((String)sb.toString())) {
                    sb.append(personInfo.getId());
                    continue;
                }
                sb.append(",");
                sb.append(personInfo.getId());
            }
        }
        return sb.toString();
    }

    private static boolean isDigitStr(String str) {
        return Character.isDigit(str.charAt(0));
    }

    private boolean isLimitSendCount(Context ctx) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"MobileSendLimit");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97MobileSendLimit\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private boolean isCellphoneNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        String number = str.trim();
        try {
            new Long(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return number.length() == 11;
    }
}

