/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.weibo.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.portal.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.cache.CacheProxy;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.weibo.WeiboService;
import com.kingdee.portal.biz.module.weibo.PrepareInfo;
import com.kingdee.portal.biz.module.weibo.RegisterInfo;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.widget.module.weibo.common.util.WeiboNoticUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weibo4j.Feed;

public class WeiboAction
extends BaseAction {
    private static final Logger logger = LoggerFactory.getLogger(WeiboAction.class);
    private WeiboService weiboService = (WeiboService)PortalServiceLocator.getBean((String)"weiboService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");

    public String adminBind() {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String email = request.getParameter("email");
        String psw = request.getParameter("psw");
        String weiboSystemType = request.getParameter("weiboSystemType");
        String testUrl = request.getParameter("testUrl");
        boolean succ = false;
        LocalErr localErr = null;
        try {
            succ = this.weiboService.bind(ctx, email, psw, true, weiboSystemType, testUrl);
            boolean enable = this.weiboService.isWeiboEnable(ctx);
            CacheProxy.getHttpSessionCache().put("weibo_enable", (Object)enable);
            request.setAttribute("weiboEnable", (Object)enable);
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String getWeiboSystemUrl() {
        PortalContext ctx = this.getPortalContext();
        LocalErr localErr = null;
        boolean succ = true;
        String weiboSystemUrl = null;
        try {
            weiboSystemUrl = this.weiboService.getWeiboSystemUrl(ctx);
        }
        catch (Exception e) {
            succ = false;
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(succ, localErr, weiboSystemUrl);
        return null;
    }

    public String getWeiboUserId() {
        PortalContext ctx = this.getPortalContext();
        LocalErr localErr = null;
        String weiboUserId = null;
        boolean succ = true;
        try {
            PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
            if (StringUtil.isEmpty((String)info.getPersonId())) {
                logger.error("getWeiboUserId\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u804c\u5458\uff01");
            } else {
                weiboUserId = this.weiboService.getWeiboUserId(ctx, info.getPersonId());
            }
        }
        catch (Exception e) {
            succ = false;
            localErr = this.handleErr(e);
        }
        this.writeAjaxData(succ, localErr, weiboUserId);
        return null;
    }

    public String register() throws PortalBizException {
        String domain;
        HttpServletRequest request;
        String email;
        String realEmail;
        PortalContext ctx = this.getPortalContext();
        boolean isRegistered = this.weiboService.isRegistered(ctx, realEmail = this.restoreEmail(email = FilterSpecialCharactersTool.cleanXSS((String)(request = this.getRequest()).getParameter("email")), domain = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("domain"))));
        if (isRegistered) {
            String weiboSystemUrl = this.weiboService.getWeiboSystemUrl(ctx);
            request.setAttribute("email", (Object)realEmail);
            request.setAttribute("domain", (Object)domain);
            request.setAttribute("weiboSystemUrl", (Object)weiboSystemUrl);
            return "input";
        }
        String weiboSystemUrl = this.weiboService.getWeiboSystemUrl(ctx);
        request.setAttribute("weiboSystemUrl", (Object)weiboSystemUrl);
        return "regWeibo";
    }

    private String restoreEmail(String email, String domain) {
        if (StringUtils.isEmpty((String)domain) || email.endsWith(domain)) {
            return email;
        }
        return email + "@" + domain;
    }

    public String bind() throws PortalBizException {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String email = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("email"));
        String psw = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("psw"));
        String domain = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("domain"));
        boolean succ = this.weiboService.bind(ctx, email, psw, false, null, null);
        if (succ) {
            return "success";
        }
        String weiboSystemUrl = this.weiboService.getWeiboSystemUrl(ctx);
        request.setAttribute("email", (Object)email);
        request.setAttribute("domain", (Object)domain);
        String passwdError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.passwd");
        request.setAttribute("err", (Object)passwdError);
        request.setAttribute("weiboSystemUrl", (Object)weiboSystemUrl);
        return "error";
    }

    public String billList() throws Exception {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        this.setAttrIf(request, "height", "500");
        this.setAttrIf(request, "width", "630");
        PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String weiboError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.accessWeiboService");
            request.setAttribute("err", (Object)weiboError);
            return "error";
        }
        String url = this.getBillListWeiboUrl(info.getLgtk());
        if (StringUtil.isEmpty((String)info.getEmail())) {
            request.setAttribute("isCheckWeibo", (Object)true);
        }
        request.setAttribute("weiboUrl", (Object)url);
        return "success";
    }

    public String myFocus() throws Exception {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        this.setAttrIf(request, "height", "500");
        this.setAttrIf(request, "width", "630");
        PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String weiboError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.accessWeiboService");
            request.setAttribute("err", (Object)weiboError);
            return "error";
        }
        String url = this.getMyFocusWeiboUrl(info.getLgtk());
        if (StringUtil.isEmpty((String)info.getEmail())) {
            request.setAttribute("isCheckWeibo", (Object)true);
        }
        request.setAttribute("weiboUrl", (Object)url);
        return "success";
    }

    private void setAttrIf(HttpServletRequest request, String atrr, String defaultValue) {
        String height = request.getParameter(atrr);
        if (StringUtil.isEmpty((String)height)) {
            request.setAttribute(atrr, (Object)defaultValue);
        } else {
            request.setAttribute(atrr, (Object)height);
        }
    }

    private String getBillListWeiboUrl(String lgtk) throws Exception {
        String widget = "/activity/?t=p&appKey=bsoAbsbamY7gA5ZF";
        return this.getLoginUrl(widget, lgtk);
    }

    private String getMyFocusWeiboUrl(String lgtk) throws Exception {
        String widget = "/activity/focus?t=p&appKey=bsoAbsbamY7gA5ZF";
        return this.getLoginUrl(widget, lgtk);
    }

    private String getLoginUrl(String widgetUrl, String lgtk) throws Exception {
        String weiboSystemUrl = this.weiboService.getWeiboSystemUrl(null);
        StringBuilder url = new StringBuilder("http://" + weiboSystemUrl + "/snsapi/oauth/login?lgtk=");
        url.append(URLEncoder.encode(lgtk, "UTF-8"));
        url.append("&to=");
        url.append(URLEncoder.encode(widgetUrl, "UTF-8"));
        return url.toString();
    }

    public String bill() throws Exception {
        String billId;
        logger.info("info bill.action");
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String tempBillId = billId = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("billId"));
        if (StringUtil.isEmpty((String)billId)) {
            String billIdError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.billIdNull");
            request.setAttribute("err", (Object)billIdError);
            return "error";
        }
        billId = billId.replaceAll("/", "888");
        billId = billId.replaceAll("\\+", "999");
        this.setAttrIf(request, "height", "500");
        this.setAttrIf(request, "width", "630");
        PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String weiboError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.accessWeiboService");
            request.setAttribute("err", (Object)weiboError);
            return "error";
        }
        String url = "";
        try {
            Feed feed = WeiboBizUtil.getStreamFeedDetail((String)billId, (String)"3");
            url = feed != null && "started".equals(feed.conversationState) ? this.getBillWeiboUrl(billId, info.getLgtk()) : "/plt_widget/weibo/showCooperate.action?billId=" + URLEncoder.encode(tempBillId, "utf-8");
        }
        catch (Exception e) {
            logger.error("getStreamFeedDetail error", (Throwable)e);
        }
        if (StringUtil.isEmpty((String)info.getEmail())) {
            request.setAttribute("isCheckWeibo", (Object)true);
        }
        request.setAttribute("weiboUrl", (Object)url);
        logger.info("weiboUrl:" + url);
        return "success";
    }

    public String billInfo() throws PortalBizException {
        Map ajaxData = this.getBillInfoMap();
        this.writeObjectData(JSONUtil.getJson4Object((Object)ajaxData));
        return null;
    }

    private Map getBillInfoMap() throws PortalBizException {
        String billId;
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        String url = "";
        String appSrc = request.getParameter("appSrc");
        if (appSrc == null || "".equals(appSrc)) {
            appSrc = "3";
        }
        String tempBillId = billId = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("billId"));
        if (StringUtil.isEmpty((String)billId)) {
            String newCooperate = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.cooperate.new");
            ajaxData.put("weiboUrl", "/plt_widget/weibo/billError.action?type=error1");
            ajaxData.put("height", 300);
            ajaxData.put("width", 400);
            ajaxData.put("title", newCooperate);
            return ajaxData;
        }
        billId = billId.replaceAll("/", "888");
        billId = billId.replaceAll("\\+", "999");
        PrepareInfo info = null;
        try {
            info = this.weiboService.getPrepareInfo(ctx);
        }
        catch (Exception e) {
            logger.info("getBillInfoMap getPrepareInfo error:", (Throwable)e);
        }
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String newCooperate = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.cooperate.new");
            ajaxData.put("weiboUrl", "/plt_widget/weibo/billError.action?type=error2");
            ajaxData.put("height", 300);
            ajaxData.put("width", 400);
            ajaxData.put("title", newCooperate);
            return ajaxData;
        }
        if (StringUtil.isEmpty((String)info.getEmail())) {
            String newCooperate = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.cooperate.new");
            ajaxData.put("weiboUrl", "/plt_widget/weibo/checkWeibo.action");
            ajaxData.put("height", 200);
            ajaxData.put("width", 700);
            ajaxData.put("title", newCooperate);
            return ajaxData;
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String newCooperate = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.cooperate.new");
            ajaxData.put("weiboUrl", "/plt_widget/weibo/billError.action?type=error3");
            ajaxData.put("height", 300);
            ajaxData.put("width", 400);
            ajaxData.put("title", newCooperate);
            return ajaxData;
        }
        try {
            boolean isFeedExist = WeiboBizUtil.billFeedExist((String)billId, (String)"3");
            logger.info("getBillInfoMap isFeedExist=" + isFeedExist);
            if (!isFeedExist) {
                Context context = (Context)ctx.getMetaInfo().get("eas_context");
                String billNumber = this.getBillNumber(context, BOSUuid.read((String)tempBillId));
                String userName = context.getUserName();
                boolean createResult = WeiboBizUtil.createBillFeed((String)tempBillId, (String)userName, (String)billNumber, (String)"", (String)"3");
                if (!createResult) {
                    logger.info("\u81ea\u52a8\u521b\u5efafeed\u51fa\u9519,billId=" + billId);
                }
            }
            URLDecoder.decode(tempBillId, "utf-8");
            Feed feed = WeiboBizUtil.getStreamFeedDetail((String)billId, (String)"3");
            if (feed != null && "started".equals(feed.conversationState)) {
                String viewCooperate = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.cooperate.view");
                url = this.getBillWeiboUrl(billId, info.getLgtk());
                ajaxData.put("weiboUrl", url);
                ajaxData.put("height", 680);
                ajaxData.put("width", 850);
                ajaxData.put("title", viewCooperate);
                return ajaxData;
            }
            String newCooperate = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.cooperate.new");
            url = "/plt_widget/weibo/showCooperate.action?appSrc=" + appSrc + "&billId=" + URLEncoder.encode(tempBillId, "utf-8");
            ajaxData.put("weiboUrl", url);
            ajaxData.put("height", 390);
            ajaxData.put("width", 520);
            ajaxData.put("title", newCooperate);
            return ajaxData;
        }
        catch (Exception e) {
            logger.error("getStreamFeedDetail  error", (Throwable)e);
            return null;
        }
    }

    public String billError() throws PortalBizException {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String type = request.getParameter("type");
        if (type != null && "error1".equals(type)) {
            return "errorPage1";
        }
        if (type != null && "error2".equals(type)) {
            return "errorPage2";
        }
        if (type != null && "error3".equals(type)) {
            return "errorPage3";
        }
        return "errorPage4";
    }

    private String getBillWeiboUrl(String billId, String lgtk) throws Exception {
        String widget = "/activity/feed/" + URLEncoder.encode(billId, "UTF-8") + "?t=p&appKey=bsoAbsbamY7gA5ZF";
        return this.getLoginUrl(widget, lgtk);
    }

    public String billWeibo() throws Exception {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String billId = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("billId"));
        if (StringUtil.isEmpty((String)billId)) {
            String billIdNull = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.billIdNull");
            request.setAttribute("err", (Object)billIdNull);
            return "error";
        }
        billId = billId.replaceAll("/", "888");
        billId = billId.replaceAll("\\+", "999");
        this.setAttrIf(request, "height", "500");
        this.setAttrIf(request, "width", "630");
        PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String weiboError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.accessWeiboService");
            request.setAttribute("err", (Object)weiboError);
            return "error";
        }
        String url = this.getBillWeiboUrl(billId, info.getLgtk());
        if (StringUtil.isEmpty((String)info.getEmail())) {
            request.setAttribute("isCheckWeibo", (Object)true);
        }
        request.setAttribute("weiboUrl", (Object)url);
        return "success";
    }

    public String checkWeibo() throws PortalBizException {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String email = this.weiboService.getBindEmail(ctx);
        if (!StringUtil.isEmpty((String)email)) {
            request.setAttribute("email", (Object)email);
            return "success";
        }
        RegisterInfo info = this.weiboService.getRegisterInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        request.setAttribute("email", (Object)this.getSubstrEmail(info.getEmail(), info.getDomain()));
        request.setAttribute("domain", (Object)info.getDomain());
        return "input";
    }

    private String getSubstrEmail(String email, String domain) {
        if (StringUtils.isEmpty((String)domain)) {
            return email;
        }
        if (this.isEmailInDomain(email, domain)) {
            return email.substring(0, email.lastIndexOf(domain) - 1);
        }
        return "";
    }

    private boolean isEmailInDomain(String email, String domain) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        return email.endsWith("@" + domain);
    }

    public String namecard() throws Exception {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String personId = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("personId"));
        if (StringUtil.isEmpty((String)personId)) {
            String personIdNull = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.personIdNull");
            request.setAttribute("err", (Object)personIdNull);
            return "error";
        }
        this.setAttrIf(request, "height", "150");
        this.setAttrIf(request, "width", "350");
        String weiboUserId = this.weiboService.getWeiboUserId(ctx, personId);
        if (StringUtil.isEmpty((String)weiboUserId)) {
            String personIdIs = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.personIdIs");
            request.setAttribute("err", (Object)(personIdIs + personId));
            return "error";
        }
        PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String weiboError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.accessWeiboService");
            request.setAttribute("err", (Object)weiboError);
            return "error";
        }
        String url = this.getNamecardUrl(weiboUserId, info.getLgtk());
        request.setAttribute("weiboUrl", (Object)url);
        return "success";
    }

    private String getNamecardUrl(String weiboUserId, String lgtk) throws Exception {
        String widget = "/activity/weidgt/" + weiboUserId + "/namecard?t=p&appKey=bsoAbsbamY7gA5ZF";
        return this.getLoginUrl(widget, lgtk);
    }

    public String publish() throws Exception {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        PrepareInfo info = this.weiboService.getPrepareInfo(ctx);
        if (StringUtil.isEmpty((String)info.getPersonId())) {
            String personError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.noPerson");
            request.setAttribute("err", (Object)personError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getLgtk())) {
            String weiboError = this.i18nService.getText(ctx, "res.widget.i18n.module.weibo.WeiboAction", "WeiboAction.error.accessWeiboService");
            request.setAttribute("err", (Object)weiboError);
            return "error";
        }
        if (StringUtil.isEmpty((String)info.getEmail())) {
            request.setAttribute("isCheckWeibo", (Object)true);
        }
        String url = this.getLoginUrl("/snsapi/weibo/?appKey=bsoAbsbamY7gA5ZF", info.getLgtk());
        request.setAttribute("weiboUrl", (Object)url);
        return "success";
    }

    public String userBind() {
        HttpServletRequest request = this.getRequest();
        request.setAttribute("isCheckWeibo", (Object)true);
        request.setAttribute("width", (Object)"600");
        request.setAttribute("height", (Object)"300");
        return "success";
    }

    public String findBillConfigList() {
        PagingResult pagingResult;
        try {
            pagingResult = this.weiboService.findBillConfigList(this.getPortalContext(), this.pagingParam);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e1a\u52a1\u5bfc\u822a\u6570\u636e\u51fa\u9519", (Throwable)e);
            pagingResult = new PagingResult();
        }
        this.writePagingResult(pagingResult);
        return null;
    }

    public String addBillConfig() {
        boolean succ = true;
        LocalErr localErr = null;
        HttpServletRequest request = this.getRequest();
        try {
            this.weiboService.addBillConfig(this.getPortalContext(), request.getParameter("bosType"), request.getParameter("desc"));
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String deleteBillConfig() {
        boolean succ = true;
        LocalErr localErr = null;
        HttpServletRequest request = this.getRequest();
        try {
            this.weiboService.deleteBillConfig(this.getPortalContext(), request.getParameter("configId"));
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String findBindPersonList() {
        PagingResult pagingResult;
        try {
            pagingResult = this.weiboService.findBindPersonList(this.getPortalContext(), this.pagingParam);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e1a\u52a1\u5bfc\u822a\u6570\u636e\u51fa\u9519", (Throwable)e);
            pagingResult = new PagingResult();
        }
        this.writePagingResult(pagingResult);
        return null;
    }

    public String batchCreateWeiboUser() {
        boolean succ = true;
        LocalErr localErr = null;
        HttpServletRequest request = this.getRequest();
        String size = request.getParameter("size");
        int defaultSize = 1000;
        if (!StringUtil.isEmpty((String)size)) {
            defaultSize = Integer.valueOf(size);
        }
        try {
            this.weiboService.batchCreateWeiboUser(this.getPortalContext(), defaultSize);
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String userUnBind() {
        boolean succ = true;
        LocalErr localErr = null;
        try {
            this.weiboService.deleteBindEmail(this.getPortalContext());
        }
        catch (PortalBizException e) {
            succ = false;
            localErr = this.handleErr((Exception)((Object)e));
        }
        this.writeAjaxData(succ, localErr, null);
        return null;
    }

    public String weiboNoticeLink() {
        LocalErr localErr = null;
        try {
            Integer totalNoticeNum = 0;
            PortalContext ctx = this.getPortalContext();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            String rowNum = this.getRequest().getParameter("rowNum");
            if (StringUtils.isEmpty((String)rowNum)) {
                rowNum = "3";
            }
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            Map counter = ClassificationStatCacheManager.get((Context)context).getStat(context.getCaller().toString());
            WeiboNoticUtil.setWeiboWorkFlowInfo(ctx, resultMap, context);
            WeiboNoticUtil.setWeiboNoticeInfo(ctx, resultMap, context);
            totalNoticeNum = totalNoticeNum + (Integer)counter.get("pendingassign");
            String haseOA = "false";
            try {
                IParamControl iParam = ParamControlFactory.getRemoteInstance();
                haseOA = iParam.getParamValue(null, "OFFICE001");
            }
            catch (Exception iParam) {
                // empty catch block
            }
            logger.info("WeiboAction hasOA:" + haseOA);
            if ("true".equals(haseOA)) {
                WeiboNoticUtil.setWeiboOAMessageInfo(ctx, resultMap, context);
                Integer oa = WeiboNoticUtil.getOAMessageCount(context);
                totalNoticeNum = totalNoticeNum + oa;
                resultMap.put("oaMessageNum", oa);
            }
            resultMap.put("workFlowNum", counter.get("pendingassign"));
            resultMap.put("totalNoticeNum", totalNoticeNum);
            resultMap.put("atMeUnreadCount", 0);
            this.writeAjaxData(true, localErr, resultMap);
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
        return null;
    }

    public String weiboNoticeLink4Portlet() {
        LocalErr localErr = null;
        try {
            PortalContext ctx = this.getPortalContext();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            String rowNum = this.getRequest().getParameter("rowNum");
            String type = this.getRequest().getParameter("type");
            Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
            if (StringUtils.isEmpty((String)rowNum) || rowNum != null && !pattern.matcher(rowNum).matches()) {
                rowNum = "3";
            }
            if (StringUtils.isEmpty((String)type)) {
                type = "Subscribe";
            }
            if (type.equals("Subscribe")) {
                WeiboNoticUtil.setWeiboNoticeInfo(ctx, resultMap, Integer.valueOf(rowNum));
            } else if (type.equals("Dynamic")) {
                WeiboNoticUtil.setWeiboNoticeDynamic(ctx, resultMap, Integer.valueOf(rowNum));
            } else if (type.equals("Groups")) {
                WeiboNoticUtil.setWeiboNoticeGroups(resultMap, ctx, Integer.valueOf(rowNum));
            }
            this.writeAjaxData(true, localErr, resultMap);
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
        return null;
    }

    public String getWeiboNoticeGroupUrl() {
        LocalErr localErr = null;
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String groupId = this.getRequest().getParameter("groupId");
            if (!StringUtils.isEmpty((String)groupId)) {
                resultMap.put("groupIdUrl", WeiboBizUtil.getWeiboGroupUrl((String)groupId, (String)"6"));
            }
            resultMap.put("weiboGroupsUrl", WeiboBizUtil.getWeiboAllGroupUrl((String)"6"));
            this.writeAjaxData(true, localErr, resultMap);
        }
        catch (Exception e) {
            localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBillNumber(Context ctx, BOSUuid id) throws BOSException, SQLException {
        String string;
        Object bak = ctx.get((Object)"disablePermissionForKScript");
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add("id");
            sc.add("number");
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk, sc, true);
            string = "" + model.get("number");
        }
        catch (Throwable throwable) {
            ctx.put((Object)"disablePermissionForKScript", bak);
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        ctx.put((Object)"disablePermissionForKScript", bak);
        SQLUtils.cleanup((Connection)cn);
        return string;
    }
}

