/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.weibo.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.portal.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.weibo.WeiboService;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weibo4j.Feed;
import weibo4j.User;

public class WeiboFileAction
extends BaseFileUploadAction {
    private static final Logger logger = LoggerFactory.getLogger(WeiboFileAction.class);
    private WeiboService weiboService = (WeiboService)PortalServiceLocator.getBean((String)"weiboService");

    public String cooperate() throws PortalBizException {
        PortalContext ctx = this.getPortalContext();
        HttpServletRequest request = this.getRequest();
        String weiboTitle = request.getParameter("weiboTitle");
        String weiboUsers = request.getParameter("weiboUsers");
        String content = request.getParameter("content");
        String sendMail = request.getParameter("sendMail");
        String con = content;
        FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("weiboFile");
        byte[] fileContent = null;
        String fileName = null;
        if (fileModel != null) {
            File file = new File(fileModel.getUploadFilePath());
            fileContent = this.getFileContent(file);
            fileName = fileModel.getUploadFileName();
        }
        String billId = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("billId"));
        content = content + this.getWeiboUserNames(weiboUsers);
        try {
            if (sendMail != null && !"".equals(sendMail)) {
                String mailContent = con + "\u3010\u8bf7\u901a\u8fc7EAS\u6d41\u7a0b\u4e2d\u5fc3->\u534f\u4f5c\u7a7a\u95f4\u4e86\u89e3\u8be6\u7ec6\u4fe1\u606f\u5e76\u8fdb\u884c\u534f\u4f5c\u6c9f\u901a\u3011";
                WeiboBizUtil.sendDirectMessageByWeiboId2((String)weiboUsers, (String)mailContent, (boolean)true);
            }
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String userId = context.getCaller().toString();
            WeiboBizUtil.doCooperate((String)billId, (String)weiboTitle, (String)userId, (String)weiboUsers, (String)content, (byte[])fileContent, (String)fileName, (String)"3");
            if (fileModel != null) {
                this.getRequest().getSession().removeAttribute("weiboFile");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("billId", (Object)billId);
        return "success";
    }

    private String getWeiboUserNames(String weiboUsers) {
        if (weiboUsers == null || "".equals(weiboUsers)) {
            return "";
        }
        String[] weiboUserIds = weiboUsers.split(",");
        String result = "";
        try {
            if (weiboUserIds != null && weiboUserIds.length > 0) {
                for (int i = 0; i < weiboUserIds.length; ++i) {
                    User user = WeiboBizUtil.getWeiboUserByWeiboId((String)weiboUserIds[i]);
                    result = result + " @" + user.getName();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String showCooperate() throws PortalBizException {
        HttpServletRequest request = this.getRequest();
        String billId = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("billId"));
        String appSrc = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("appSrc"));
        try {
            String userId;
            User user;
            Feed feed;
            PortalContext ctx = this.getPortalContext();
            String email = this.weiboService.getBindEmail(ctx);
            if (email == null || "".equals(email)) {
                request.setAttribute("weiboOK", (Object)"false");
            } else {
                request.setAttribute("weiboOK", (Object)"true");
            }
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            boolean isFeedExist = WeiboBizUtil.billFeedExist((String)billId, (String)"3");
            logger.info("WeiboFileAction isFeedExist=" + isFeedExist);
            if (!isFeedExist) {
                String billNumber = this.getBillNumber(context, BOSUuid.read((String)billId));
                String userName = context.getUserName();
                boolean createResult = WeiboBizUtil.createBillFeed((String)billId, (String)userName, (String)billNumber, (String)"", (String)"3");
                if (!createResult) {
                    logger.info("\u81ea\u52a8\u521b\u5efafeed\u51fa\u9519,billId=" + billId);
                }
            }
            if ((feed = WeiboBizUtil.getStreamFeedDetail((String)billId, (String)"3")) != null) {
                logger.info("showCooperate,title:" + feed.title);
                request.setAttribute("title", (Object)feed.title);
            }
            if ((user = WeiboBizUtil.getWeiboUser((String)(userId = context.getCaller().toString()))) != null) {
                logger.info("showCooperate,userName:" + user.getName());
                request.setAttribute("userName", (Object)user.getName());
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6Feed\u8be6\u7ec6\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        request.setAttribute("billId", (Object)billId);
        request.setAttribute("appSrc", (Object)appSrc);
        return "success";
    }

    public String search() {
        String q = this.getRequest().getParameter("search");
        logger.info("#############q=" + q);
        List list = null;
        try {
            list = WeiboBizUtil.searchUsers((String)q, (String)"3");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (list != null && list.size() > 0) {
            StringBuffer jsonSB = new StringBuffer("[");
            for (int i = 0; i < list.size(); ++i) {
                User user = (User)list.get(i);
                String jsonItem = "[\"" + user.getId() + "\",\"" + user.getName() + "\",null,\"" + user.getName() + "\"]";
                jsonSB.append(jsonItem);
                if (i != list.size() - 1) {
                    jsonSB.append(",");
                    continue;
                }
                jsonSB.append("]");
            }
            String jsonString = jsonSB.toString();
            logger.info("search jsonString result:" + jsonString);
            this.writeObjectData(jsonString);
        }
        return null;
    }

    public String uploadFile() {
        boolean success = true;
        FileModel fileModel = null;
        try {
            this.copyFile2UploadFolder();
            fileModel = new FileModel();
            fileModel.setUploadFilePath(this.getUpload().getAbsolutePath());
            fileModel.setUploadFileName(this.getUploadFileName());
            fileModel.setUploadContentType(this.getUploadContentType());
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        File file = this.getUpload();
        if (file != null) {
            logger.info("fileName:" + file.getAbsolutePath());
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"uploadTempImg");
        this.getRequest().getSession().setAttribute("weiboFile", (Object)fileModel);
        return "success";
    }

    public String showTempFile() {
        FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("weiboFile");
        File tempTempImg = new File(fileModel.getUploadFilePath());
        byte[] fileContent = this.getFileContent(tempTempImg);
        this.writeResponse(this.getResponse(), fileModel.getUploadContentType(), fileContent);
        return null;
    }

    public String deleteFile() {
        this.getRequest().getSession().removeAttribute("weiboFile");
        try {
            String result = "test mao";
            this.getResponse().getOutputStream().write(result.getBytes());
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBillNumber(Context ctx, BOSUuid id) throws BOSException, SQLException {
        String string;
        Object bak = ctx.get((Object)"disablePermissionForKScript");
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add("id");
            sc.add("number");
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk, sc, true);
            string = "" + model.get("number");
        }
        catch (Throwable throwable) {
            ctx.put((Object)"disablePermissionForKScript", bak);
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        ctx.put((Object)"disablePermissionForKScript", bak);
        SQLUtils.cleanup((Connection)cn);
        return string;
    }
}

