/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.weibo.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import weibo4j.Activity;
import weibo4j.ActivityComment;
import weibo4j.Feed;
import weibo4j.Group;

public class WeiboNoticUtil {
    public static void setWeiboNoticeInfoOnlyUnread(PortalContext ctx, Map<String, Object> resultMap, Integer rowNum) throws BOSException, EASBizException {
        List feedList = WeiboBizUtil.feedSubscribeTimelineOnlyUnread(null, (int)1, (int)1, (int)rowNum, (boolean)true, (String)"3");
        ArrayList weiboList = new ArrayList();
        for (int i = 0; feedList != null && i < feedList.size() && weiboList.size() < rowNum; ++i) {
            Feed feed = (Feed)feedList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, String> activityMap = new HashMap<String, String>();
            List activityList = feed.activityList;
            for (int j = 0; activityList != null && j < activityList.size() && j < 1; ++j) {
                Activity activity = (Activity)activityList.get(j);
                activityMap.put("content", activity.content);
                activityMap.put("published", WeiboNoticUtil.getShortTime(ctx, activity.published.toLocaleString()));
                activityMap.put("ownerName", activity.ownerName);
            }
            map.put("activityList", activityMap);
            map.put("category", feed.category);
            map.put("tagKey", feed.tagKey);
            map.put("targetId", feed.targetId);
            map.put("title", feed.title);
            map.put("unread", feed.unread);
            weiboList.add(map);
        }
        resultMap.put("weiboUnreadList", weiboList);
    }

    public static void setWeiboNoticeInfo(PortalContext ctx, Map<String, Object> resultMap, Integer rowNum) throws BOSException, EASBizException {
        List feedList = WeiboBizUtil.getFeedSubscribeTimeline(null, (int)1, (int)1, (int)rowNum, (String)"3");
        ArrayList weiboList = new ArrayList();
        for (int i = 0; feedList != null && i < feedList.size() && i < rowNum; ++i) {
            Feed feed = (Feed)feedList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, String> activityMap = new HashMap<String, String>();
            List activityList = feed.activityList;
            for (int j = 0; activityList != null && j < activityList.size() && j < 1; ++j) {
                Activity activity = (Activity)activityList.get(j);
                activityMap.put("content", activity.content);
                activityMap.put("published", WeiboNoticUtil.getShortTime(ctx, activity.published.toLocaleString()));
                activityMap.put("ownerName", activity.ownerName);
            }
            map.put("activityList", activityMap);
            map.put("category", feed.category);
            map.put("tagKey", feed.tagKey);
            map.put("targetId", feed.targetId);
            map.put("title", feed.title);
            map.put("unread", feed.unread);
            weiboList.add(map);
        }
        resultMap.put("weiboList", weiboList);
    }

    public static void setWeiboNoticeDynamicOnlyUnread(PortalContext ctx, Map<String, Object> resultMap, Integer rowNum) throws BOSException, EASBizException {
        List feedList = WeiboBizUtil.feedDynamicTimelineOnlyUnread(null, (int)1, (int)1, (int)rowNum, (boolean)true, (String)"3");
        ArrayList weiboList = new ArrayList();
        for (int i = 0; feedList != null && i < feedList.size(); ++i) {
            Feed feed = (Feed)feedList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, String> activityMap = new HashMap<String, String>();
            List activityList = feed.activityList;
            for (int j = 0; activityList != null && j < activityList.size() && j < 1; ++j) {
                Activity activity = (Activity)activityList.get(j);
                activityMap.put("content", activity.content);
                activityMap.put("published", WeiboNoticUtil.getShortTime(ctx, activity.published.toLocaleString()));
                activityMap.put("ownerName", activity.ownerName);
            }
            map.put("activityList", activityMap);
            map.put("category", feed.category);
            map.put("tagKey", feed.tagKey);
            map.put("targetId", feed.targetId);
            map.put("title", feed.title);
            map.put("unread", feed.unread);
            weiboList.add(map);
        }
        resultMap.put("weiboDynamicUnreadList", weiboList);
    }

    public static void setWeiboNoticeDynamic(PortalContext ctx, Map<String, Object> resultMap, Integer rowNum) throws BOSException, EASBizException {
        List feedList = WeiboBizUtil.getFeedDynamicTimeline(null, (int)1, (int)1, (int)rowNum, (String)"3");
        ArrayList weiboList = new ArrayList();
        for (int i = 0; feedList != null && i < feedList.size(); ++i) {
            Feed feed = (Feed)feedList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, String> activityMap = new HashMap<String, String>();
            List activityList = feed.activityList;
            for (int j = 0; activityList != null && j < activityList.size() && j < 1; ++j) {
                Activity activity = (Activity)activityList.get(j);
                activityMap.put("content", activity.content);
                activityMap.put("published", WeiboNoticUtil.getShortTime(ctx, activity.published.toLocaleString()));
                activityMap.put("ownerName", activity.ownerName);
            }
            map.put("activityList", activityMap);
            map.put("category", feed.category);
            map.put("tagKey", feed.tagKey);
            map.put("targetId", feed.targetId);
            map.put("title", feed.title);
            map.put("unread", feed.unread);
            weiboList.add(map);
        }
        resultMap.put("weiboDynamicList", weiboList);
    }

    public static void setWeiboNoticeReply(Map<String, Object> resultMap, PortalContext ctx, Integer rowNum) throws BOSException, EASBizException {
        String userId = ctx.getLoginUser().getId();
        ArrayList weiboList = new ArrayList();
        List activityList = WeiboBizUtil.getStreamReplyToMeTimeline((String)userId, (int)1, (int)rowNum, (String)"3");
        for (int j = 0; activityList != null && j < activityList.size() && j < rowNum; ++j) {
            HashMap<String, String> activityMap = new HashMap<String, String>();
            Activity activity = (Activity)activityList.get(j);
            List comments = activity.comments;
            if (comments != null && comments.size() > 0) {
                ActivityComment comment = (ActivityComment)comments.get(0);
                activityMap.put("content", comment.content);
                activityMap.put("published", WeiboNoticUtil.getShortTime(ctx, comment.published.toLocaleString()));
                activityMap.put("ownerName", comment.ownerName);
            }
            activityMap.put("targetId", activity.target);
            weiboList.add(activityMap);
        }
        resultMap.put("weiboReplyList", weiboList);
    }

    public static void setWeiboNoticeMentions(Map<String, Object> resultMap, PortalContext ctx, Integer rowNum) throws BOSException, EASBizException {
        String userId = ctx.getLoginUser().getId();
        ArrayList weiboList = new ArrayList();
        List activityList = WeiboBizUtil.getStreamMentionsTimeline((String)userId, (int)1, (int)rowNum, (String)"3");
        for (int j = 0; activityList != null && j < activityList.size() && j < rowNum; ++j) {
            HashMap<String, String> activityMap = new HashMap<String, String>();
            Activity activity = (Activity)activityList.get(j);
            activityMap.put("content", activity.content);
            activityMap.put("published", WeiboNoticUtil.getShortTime(ctx, activity.published.toLocaleString()));
            activityMap.put("ownerName", activity.ownerName);
            activityMap.put("targetId", activity.target);
            weiboList.add(activityMap);
        }
        resultMap.put("weiboMentionsList", weiboList);
    }

    public static void setWeiboNoticeGroups(Map<String, Object> resultMap, PortalContext ctx, Integer rowNum) throws BOSException, EASBizException {
        String userId = ctx.getLoginUser().getId();
        ArrayList weiboList = new ArrayList();
        List groupList = WeiboBizUtil.getJoinedGroups((String)userId, (int)1, (int)rowNum, (String)"3");
        for (int j = 0; groupList != null && j < groupList.size() && j < rowNum; ++j) {
            HashMap<String, String> activityMap = new HashMap<String, String>();
            Group group = (Group)groupList.get(j);
            activityMap.put("id", group.id);
            activityMap.put("url", WeiboBizUtil.getWeiboGroupUrl((String)group.id, (String)"3"));
            activityMap.put("name", group.name);
            activityMap.put("imageUrl", group.profile_image_url);
            activityMap.put("description", group.description);
            activityMap.put("bulletin", group.bulletin);
            weiboList.add(activityMap);
        }
        resultMap.put("weiboGroups", weiboList);
    }

    public static void setWeiboNoticeInfo(PortalContext ctx, Map<String, Object> resultMap, Context context) throws Exception {
        List notices = new WfUtil(context).getUnReadNotices(3);
        for (int i = 0; notices != null && i < notices.size(); ++i) {
            Map map = (Map)notices.get(i);
            String fsendtime = String.valueOf(map.get("fsendtime"));
            if (StringUtils.isEmpty((String)fsendtime)) continue;
            fsendtime = fsendtime.substring(0, 19);
            map.put("fsendtime", WeiboNoticUtil.getShortTime(ctx, fsendtime));
        }
        resultMap.put("noticeList", notices);
    }

    public static void setWeiboOAMessageInfo(PortalContext ctx, Map<String, Object> resultMap, Context context) throws Exception {
        List notices = new WfUtil(context).getUnReadOAMessage(3);
        for (int i = 0; notices != null && i < notices.size(); ++i) {
            Map map = (Map)notices.get(i);
            String fsendtime = String.valueOf(map.get("freceivetime"));
            if (StringUtils.isEmpty((String)fsendtime)) continue;
            fsendtime = fsendtime.substring(0, 19);
            map.put("freceivetime", WeiboNoticUtil.getShortTime(ctx, fsendtime));
        }
        resultMap.put("oaMesageList", notices);
    }

    public static int getOAMessageCount(Context context) throws Exception {
        Integer count = 0;
        List notices = new WfUtil(context).getOAMessageCount();
        if (notices != null) {
            Map map = (Map)notices.get(0);
            Number count_ = (Number)map.get("num");
            count = count_.intValue();
        }
        return count;
    }

    public static void setWeiboWorkFlowInfo(PortalContext ctx, Map<String, Object> resultMap, Context context) throws Exception {
        List assigns = new WfUtil(context).getUnReadAssigns(3);
        for (int i = 0; assigns != null && i < assigns.size(); ++i) {
            Map map = (Map)assigns.get(i);
            String fcreatedtime = String.valueOf(map.get("fcreatedtime"));
            if (StringUtils.isEmpty((String)fcreatedtime)) continue;
            fcreatedtime = fcreatedtime.substring(0, 19);
            map.put("fcreatedtime", WeiboNoticUtil.getShortTime(ctx, fcreatedtime));
        }
        resultMap.put("workFlowList", assigns);
    }

    public static String getShortTime(PortalContext ctx, String time) {
        II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
        if (StringUtils.isEmpty((String)time)) {
            return time;
        }
        String shortstring = null;
        Date date = WeiboNoticUtil.getDateByString(time);
        if (date == null) {
            return shortstring;
        }
        long now = Calendar.getInstance().getTimeInMillis();
        long deltime = (now - date.getTime()) / 1000L;
        try {
            shortstring = deltime > 31536000L ? (int)(deltime / 31536000L) + i18nService.getText(ctx, "res.widget.i18n.module.weibo.Notice", "Notice.label.yearBefore") : (deltime > 86400L ? (int)(deltime / 86400L) + i18nService.getText(ctx, "res.widget.i18n.module.weibo.Notice", "Notice.label.dayBefore") : (deltime > 3600L ? (int)(deltime / 3600L) + i18nService.getText(ctx, "res.widget.i18n.module.weibo.Notice", "Notice.label.hourBefore") : (deltime > 60L ? (int)(deltime / 60L) + i18nService.getText(ctx, "res.widget.i18n.module.weibo.Notice", "Notice.label.minuteBefore") : (deltime > 1L ? deltime + i18nService.getText(ctx, "res.widget.i18n.module.weibo.Notice", "Notice.label.secondBefore") : i18nService.getText(ctx, "res.widget.i18n.module.weibo.Notice", "Notice.label.second1Before")))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shortstring;
    }

    public static Date getDateByString(String time) {
        Date date = null;
        if (time == null) {
            return date;
        }
        String date_format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(date_format);
        try {
            date = format.parse(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }
}

