/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.weibo.portlet;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.weibo.WeiboService;
import com.kingdee.portal.biz.module.weibo.PrepareInfo;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import weibo4j.User;

public class WeiboCardPortlet
extends GenericPortlet {
    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortalContext ctx = PortalContextUtil.getPortalContext((RenderRequest)request);
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        try {
            WeiboService weiboService = (WeiboService)PortalServiceLocator.getBean((String)"weiboService");
            String weiboMessageUrl = this.getWeiboUrl(ctx, weiboService, "/message");
            if (weiboMessageUrl == null) {
                request.setAttribute("weiboEnable", (Object)"false");
                PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/weibo/WeiboCardPortlet_view.jsp");
                dispatcher.include(request, response);
                return;
            }
            request.setAttribute("weiboEnable", (Object)"true");
            String weiboAtmeUrl = this.getWeiboUrl(ctx, weiboService, "/microblog/atme");
            String weiboFansUrl = this.getWeiboUrl(ctx, weiboService, "/relation/fans");
            String weiboFellowUrl = this.getWeiboUrl(ctx, weiboService, "/relation/follow");
            String weiboSystemUrl = weiboService.getWeiboSystemUrl(null);
            String userId = context.getCaller().toString();
            User user = WeiboBizUtil.getWeiboUser((String)userId);
            String imageURL = user.getProfileImageURL().toString();
            String name = user.getName();
            int followersCount = user.getFollowersCount();
            int friendsCount = user.getFriendsCount();
            int statusesCount = user.getStatusesCount();
            request.setAttribute("imageURL", (Object)imageURL);
            request.setAttribute("name", (Object)name);
            request.setAttribute("followersCount", (Object)followersCount);
            request.setAttribute("friendsCount", (Object)friendsCount);
            request.setAttribute("statusesCount", (Object)statusesCount);
            request.setAttribute("weiboMessageUrl", (Object)weiboMessageUrl);
            request.setAttribute("weiboAtmeUrl", (Object)weiboAtmeUrl);
            request.setAttribute("weiboFansUrl", (Object)weiboFansUrl);
            request.setAttribute("weiboFellowUrl", (Object)weiboFellowUrl);
            request.setAttribute("weiboSystemUrl", (Object)weiboSystemUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/weibo/WeiboCardPortlet_view.jsp");
        dispatcher.include(request, response);
    }

    private String getWeiboUrl(PortalContext ctx, WeiboService weiboService, String widgetUrl) {
        try {
            PrepareInfo info = null;
            try {
                info = weiboService.getPrepareInfo(ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (StringUtil.isEmpty((String)info.getPersonId())) {
                return null;
            }
            if (StringUtil.isEmpty((String)info.getLgtk())) {
                return null;
            }
            String weiboSystemUrl = weiboService.getWeiboSystemUrl(null);
            StringBuilder url = new StringBuilder("http://" + weiboSystemUrl + "/snsapi/oauth/login?lgtk=");
            url.append(URLEncoder.encode(info.getLgtk(), "UTF-8"));
            url.append("&to=");
            url.append(URLEncoder.encode(widgetUrl, "UTF-8"));
            return url.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
    }
}

