/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.widget.module.weibo.portlet;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.weibo.WeiboService;
import com.kingdee.portal.biz.module.weibo.PrepareInfo;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import weibo4j.User;

public class WeiboNetworkPortlet
extends GenericPortlet {
    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        PortalContext ctx = PortalContextUtil.getPortalContext((RenderRequest)request);
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        WeiboService weiboService = (WeiboService)PortalServiceLocator.getBean((String)"weiboService");
        PrepareInfo info = null;
        try {
            info = weiboService.getPrepareInfo(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtil.isEmpty((String)info.getPersonId()) || StringUtil.isEmpty((String)info.getLgtk())) {
            request.setAttribute("weiboEnable", (Object)"false");
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/weibo/WeiboNetworkPortlet_view.jsp");
            dispatcher.include(request, response);
            return;
        }
        try {
            String userId = context.getCaller().toString();
            User user = WeiboBizUtil.getWeiboUser((String)userId);
            String weiboUrl = this.getWeiboUrl(weiboService, info.getLgtk(), user.companyId);
            System.out.println("###############weiboUrl:" + weiboUrl);
            request.setAttribute("weiboUrl", (Object)weiboUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("weiboEnable", (Object)"true");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/fragments/weibo/WeiboNetworkPortlet_view.jsp");
        dispatcher.include(request, response);
    }

    private String getWeiboUrl(WeiboService weiboService, String lgtk, String companyId) {
        try {
            String widgetUrl = "/snsapi/weibo/networkMicroBlogs?width=0&height=1300&widgetSkin=0&networkId=" + companyId;
            String weiboSystemUrl = weiboService.getWeiboSystemUrl(null);
            StringBuilder url = new StringBuilder("http://" + weiboSystemUrl + "/snsapi/oauth/login?lgtk=");
            url.append(URLEncoder.encode(lgtk, "UTF-8"));
            url.append("&to=");
            url.append(URLEncoder.encode(widgetUrl, "UTF-8"));
            return url.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
    }
}

