/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.shr.ltap;

import com.kingdee.eas.cp.eip.sso.shr.ltap.ShrLtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrLtpaToken {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private byte[] creation;
    private Date creationDate;
    private byte[] digest;
    private byte[] expires;
    private Date expiresDate;
    private byte[] header;
    private String tokenStr;
    private byte[] rawToken;
    private byte[] user;

    public ShrLtpaToken() {
        this.init();
    }

    public ShrLtpaToken(String token) {
        int i;
        this.init();
        this.tokenStr = token;
        this.rawToken = BASE64Util.decodeAsBytes((String)token);
        this.user = new byte[this.rawToken.length - 60];
        for (i = 0; i < 4; ++i) {
            this.header[i] = this.rawToken[i];
        }
        for (i = 4; i < 12; ++i) {
            this.creation[i - 4] = this.rawToken[i];
        }
        for (i = 12; i < 20; ++i) {
            this.expires[i - 12] = this.rawToken[i];
        }
        String algorithm = ShrLtpaTokenManager.getAlgorithm();
        if ("SHA-256".equalsIgnoreCase(algorithm)) {
            int i2;
            this.user = new byte[this.rawToken.length - 84];
            this.digest = new byte[64];
            for (i2 = 20; i2 < this.rawToken.length - 64; ++i2) {
                this.user[i2 - 20] = this.rawToken[i2];
            }
            for (i2 = this.rawToken.length - 64; i2 < this.rawToken.length; ++i2) {
                this.digest[i2 - (this.rawToken.length - 64)] = this.rawToken[i2];
            }
        } else {
            int i3;
            this.user = new byte[this.rawToken.length - 60];
            for (i3 = 20; i3 < this.rawToken.length - 40; ++i3) {
                this.user[i3 - 20] = this.rawToken[i3];
            }
            for (i3 = this.rawToken.length - 40; i3 < this.rawToken.length; ++i3) {
                this.digest[i3 - (this.rawToken.length - 40)] = this.rawToken[i3];
            }
        }
        this.creationDate = new Date(Long.parseLong(new String(this.creation), 16) * 1000L);
        this.expiresDate = new Date(Long.parseLong(new String(this.expires), 16) * 1000L);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public MessageDigest getMessageDigest() {
        try {
            String algorithm = ShrLtpaTokenManager.getAlgorithm();
            if ("SHA-256".equalsIgnoreCase(algorithm)) {
                return MessageDigest.getInstance("SHA-256");
            }
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.log.error(nsae.getMessage(), (Object)"NoSuchAlgorithmException : {}");
            return null;
        }
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getUsername() {
        String userName = null;
        try {
            userName = new String(this.user, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    public String getUsername(String code) {
        String userName = null;
        try {
            userName = new String(this.user, code);
        }
        catch (UnsupportedEncodingException e) {
            userName = new String(this.user);
        }
        return userName;
    }

    private void init() {
        this.creation = new byte[8];
        this.digest = new byte[40];
        this.expires = new byte[8];
        this.header = new byte[4];
    }

    public boolean isValid(String secretKey) {
        boolean validDigest = false;
        boolean validDateRange = false;
        byte[] bytes = null;
        Date now = new Date();
        MessageDigest md = this.getMessageDigest();
        bytes = LMBCSUtil.concatenate(bytes, (byte[])this.header);
        bytes = LMBCSUtil.concatenate((byte[])bytes, (byte[])this.creation);
        bytes = LMBCSUtil.concatenate((byte[])bytes, (byte[])this.expires);
        bytes = LMBCSUtil.concatenate((byte[])bytes, (byte[])this.user);
        bytes = LMBCSUtil.concatenate((byte[])bytes, (byte[])BASE64Util.decodeAsBytes((String)secretKey));
        byte[] newDigest = md.digest(bytes);
        String di = ShrLtpaToken.byte2hex(newDigest);
        validDigest = MessageDigest.isEqual(this.digest, di.getBytes());
        this.log.info("valid message digest : {}", (Object)validDigest);
        validDateRange = now.before(this.expiresDate);
        return validDigest && validDateRange;
    }

    public static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs.toUpperCase();
    }

    public String toString() {
        return ShrLtpaToken.encodeToken(this.tokenStr);
    }

    public String toPlainString() {
        return this.tokenStr;
    }

    public byte[] getCreation() {
        return this.creation;
    }

    public void setCreation(byte[] creation) {
        this.creation = creation;
    }

    public byte[] getExpires() {
        return this.expires;
    }

    public void setExpires(byte[] expires) {
        this.expires = expires;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public void setExpiresDate(Date expiresDate) {
        this.expiresDate = expiresDate;
    }

    public void setUser(byte[] user) {
        this.user = user;
    }

    public byte[] getUser() {
        return this.user;
    }

    public String getTokenStr() {
        return ShrLtpaToken.encodeToken(this.tokenStr);
    }

    public static String encodeToken(String token) {
        try {
            return URLEncoder.encode(URLEncoder.encode(URLEncoder.encode(token, "UTF-8"), "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Token encode error[UnsupportedEncodingException]!");
            e.printStackTrace();
            return token;
        }
    }

    public static String decodeToken(String token) {
        if (token.indexOf("+") == -1) {
            try {
                String decodeToken1 = URLDecoder.decode(token, "UTF-8");
                if (decodeToken1.indexOf("+") == -1) {
                    String decodeToken2 = URLDecoder.decode(decodeToken1, "UTF-8");
                    if (decodeToken2.indexOf("+") == -1) {
                        return URLDecoder.decode(decodeToken2, "UTF-8");
                    }
                    return decodeToken2;
                }
                return decodeToken1;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return token;
    }
}

