/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorStateEnum;
import com.kingdee.eas.base.usermonitor.web.UserMonitorLoginHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.context.WebContextUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class UserMonitorFilter
implements Filter {
    protected static final Logger logger = Logger.getLogger(UserMonitorFilter.class);
    private static final String PORTAL_PROPERTIES = "portalMonitor.properties";
    private static final String ISLOGOUTED = "isLogouted";
    private static Set<String> timerURL = null;
    private static Set<String> ignoreUrlKeywords = null;
    private String logoutPage = null;
    private static final long sleepTimeInSeconds = 10L;
    private static final String USERMONITORSESSIONINFO_KEY = "userMonitorSessionInfo";

    private void addLogoutLog(String sessionID, Context ctx) {
        try {
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLoginLog(Context ctx, UserMonitorSessionInfo userMonitorSessionInfo, String ip) {
        UMRegistryInfo info = UserMonitorLoginHelper.createUMRegistryInfo((Context)ctx, (String)ctx.getContextID(), (String)ip);
        UserMonitorSessionInfo userMonitorSessionInfo2 = userMonitorSessionInfo;
        synchronized (userMonitorSessionInfo2) {
            if (!UserMonitorStateEnum.monitored.equals((Object)userMonitorSessionInfo.getUserMonitorState())) {
                userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.monitored);
                UserMonitorLoginHelper.saveUMRegistryInfo((UMRegistryInfo)info, (Context)ctx);
            }
        }
    }

    private boolean isExists(UserMonitorSessionInfo sessionInfo, Context ctx) {
        try {
            IObjectValue info = this.getValue(sessionInfo.getId());
            if (info != null) {
                return true;
            }
        }
        catch (IllegalSessionStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"checkUserBeTicked err!", (Throwable)e);
        }
        return false;
    }

    private boolean isNeedCheckUserBeTicked(Date date) {
        return this.isNeedUpdate(date);
    }

    private boolean isNeedUpdateLastOpTime(Date date) {
        return this.isNeedUpdate(date);
    }

    private boolean isNeedUpdate(Date date) {
        Date currentDate = new Date();
        return currentDate.getTime() - date.getTime() > 10L;
    }

    private boolean isLinkTopBar(HttpServletRequest request) {
        return request.getServletPath().equals("/logout.jsp");
    }

    public void destroy() {
    }

    private static String getIpAddr(HttpServletRequest request) {
        String portalIP = request.getHeader("nap_proxy_client_ip");
        if (portalIP != null && portalIP.trim().length() > 0) {
            return portalIP;
        }
        portalIP = request.getHeader("x-forwarded-for");
        if (portalIP != null && portalIP.trim().length() > 0) {
            try {
                if (portalIP.indexOf(",") != -1) {
                    portalIP = portalIP.substring(0, portalIP.indexOf(","));
                }
                return portalIP;
            }
            catch (Exception e) {
                logger.error((Object)"X_FORWARDED_FOR : Get Real IP Address  err!", (Throwable)e);
            }
        }
        if ((portalIP = request.getHeader("Proxy-Client-IP")) != null && portalIP.trim().length() > 0) {
            return portalIP;
        }
        return request.getRemoteAddr() == null ? "172.0.0.1" : request.getRemoteAddr();
    }

    private IObjectValue getValue(String sesssionID) throws EASBizException, Exception {
        IUserMonitor iUserMonitor = this.getInterface();
        IObjectValue info = iUserMonitor.getValue(sesssionID);
        return info;
    }

    private IUserMonitor getInterface() throws EASBizException, Exception {
        IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
        return iUserMonitor;
    }

    private void logout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            HttpSession httpSession = httpRequest.getSession(false);
            if (httpSession != null) {
                httpSession.setAttribute(ISLOGOUTED, (Object)"true");
            }
            httpResponse.sendRedirect("/shr/reloadtips.jsp");
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.debug((Object)"UserMonitorFilter enter doFilter!");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)httpRequest);
        String servletPath = StringUtils.cnulls((String)httpRequest.getServletPath());
        String ticked = request.getParameter("ticked");
        if (ctx == null || "true".equals(ticked) || servletPath.contains("reloadtips.jsp")) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        boolean hasbossession = SessionManager.getInstance().getSession(ctx.getContextID()) != null;
        String pathInfo = StringUtils.cnulls((String)httpRequest.getPathInfo());
        HttpSession httpSession = httpRequest.getSession();
        boolean issystemrequest = timerURL.contains(pathInfo) || timerURL.contains(servletPath) || this.isIgnoreUrl(httpRequest);
        request.setAttribute("ignoreUserMonitor", (Object)issystemrequest);
        if (LocaleUtils.locale_l1.getDisplayName().equalsIgnoreCase(ctx.getLocale().getDisplayName())) {
            try {
                ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getLocalInstance((Context)ctx);
                if (!iLicenseSrvAgent.isSHRMultilingual()) {
                    this.logout(httpRequest, httpResponse);
                    logger.error((Object)MessageFormat.format("local is : {0}, isSHRMultilingual : {1}, current page logout,if you want to use english language access s-HR ,please import s-HR Multi license ", LocaleUtils.locale_l1.getDisplayName(), iLicenseSrvAgent.isSHRMultilingual()));
                    return;
                }
            }
            catch (LicenseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
        }
        if (!StringUtils.isEmpty((String)pathInfo) || !StringUtils.isEmpty((String)servletPath)) {
            if (!hasbossession) {
                if ("/logout.do".equals(servletPath) || "/OTP2sso.jsp".equals(servletPath) || "/toGuiRelogin.jsp".equals(servletPath) || "/index2sso.jsp".equals(servletPath) || "/ssoWelcome".equals(servletPath) || "/switchToLogin.jsp".equals(servletPath) || servletPath.indexOf("/getSettingInfo.action") != -1 || servletPath.indexOf("/loginCheck.action") != -1) {
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    return;
                }
                if (issystemrequest) {
                    return;
                }
                this.logout(httpRequest, httpResponse);
                return;
            }
            if (issystemrequest) {
                try {
                    this.getInterface().updateTimerLastOperateTime(ctx.getContextID());
                }
                catch (Exception e) {
                    // empty catch block
                }
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
        }
        try {
            httpSession.getAttribute("test");
        }
        catch (IllegalStateException e) {
            return;
        }
        UserMonitorSessionInfo userMonitorSessionInfo = (UserMonitorSessionInfo)httpSession.getAttribute(USERMONITORSESSIONINFO_KEY);
        this.reAssociationUserMonitorSessionInfoToCurrentSession(httpRequest, ctx, userMonitorSessionInfo);
        UserMonitorStateEnum state = null;
        if (userMonitorSessionInfo != null) {
            state = userMonitorSessionInfo.getUserMonitorState();
            if (this.isNeedUpdateLastOpTime(userMonitorSessionInfo.getLastUpdateTime()) && this.isExists(userMonitorSessionInfo, ctx)) {
                userMonitorSessionInfo.setLastUpdateTime(new Date());
                try {
                    IUserMonitor iUserMonitor = this.getInterface();
                    iUserMonitor.updateLastOperateTime(ctx.getContextID());
                    iUserMonitor.updateTimerLastOperateTime(ctx.getContextID());
                }
                catch (Exception e) {
                    logger.error((Object)"updateLastOperate err!", (Throwable)e);
                }
            } else if (UserMonitorStateEnum.login.equals((Object)state)) {
                try {
                    IObjectValue info = this.getValue(ctx.getContextID());
                    if (info == null) {
                        String clientIp = UserMonitorFilter.getIpAddr(httpRequest);
                        this.addLoginLog(ctx, userMonitorSessionInfo, clientIp);
                        httpSession.setAttribute(ISLOGOUTED, (Object)"false");
                    }
                    userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.monitored);
                }
                catch (Exception e) {
                    logger.error((Object)"portal login err!", (Throwable)e);
                }
            }
            if (this.isLinkTopBar(httpRequest)) {
                String sessionID = ctx.getContextID();
                this.addLogoutLog(sessionID, ctx);
                try {
                    httpSession.getAttribute("xxxxxxxxxxxxx");
                    httpSession.invalidate();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    private void reAssociationUserMonitorSessionInfoToCurrentSession(HttpServletRequest httpRequest, Context ctx, UserMonitorSessionInfo userMonitorSessionInfo) {
        if (null == userMonitorSessionInfo) {
            try {
                if (null == ctx) {
                    return;
                }
                IObjectValue v = this.getValue(ctx.getContextID());
                if (v != null) {
                    Locale userLocale = ctx.getLocale();
                    HttpSession session = httpRequest.getSession();
                    userMonitorSessionInfo = new UserMonitorSessionInfo();
                    userMonitorSessionInfo.setId(ctx.getContextID());
                    userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.login);
                    userMonitorSessionInfo.setLastUpdateTime(new Date());
                    userMonitorSessionInfo.setLastCheckTickedTime(new Date());
                    session.setAttribute("org.apache.struts.action.LOCALE", (Object)userLocale);
                    session.setAttribute(USERMONITORSESSIONINFO_KEY, (Object)userMonitorSessionInfo);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private boolean isIgnoreUrl(HttpServletRequest request) {
        String url = request.getRequestURI();
        String queryString = request.getQueryString();
        for (String keyword : ignoreUrlKeywords) {
            if (url.contains(keyword)) {
                return true;
            }
            if (queryString == null || !queryString.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    private File getPortalMonitorFile(String fileName) throws IOException {
        String ctrlFilePath = new StringBuffer().append(System.getProperty("EAS_HOME")).append(File.separator).append("server").append(File.separator).append("properties").append(File.separator).append(fileName).toString();
        File file = new File(SHRCheck.checkFilePath((String)ctrlFilePath));
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValue(File file) throws IOException {
        FileInputStream fileInputStream = null;
        InputStream in = null;
        try {
            int i;
            fileInputStream = new FileInputStream(file);
            in = new BufferedInputStream(fileInputStream);
            Properties properties = new Properties();
            properties.load(in);
            if (timerURL == null) {
                timerURL = new HashSet<String>();
                String shrHeartbeatPath = "/heartbeat.do";
                timerURL.add(shrHeartbeatPath);
            }
            if (ignoreUrlKeywords == null) {
                ignoreUrlKeywords = new HashSet<String>();
            }
            if (!StringUtils.isEmpty((String)properties.getProperty("url"))) {
                String url = properties.getProperty("url");
                String[] timerPaths = url.split(",");
                for (i = 0; i < timerPaths.length; ++i) {
                    if (StringUtils.isEmpty((String)timerPaths[i])) continue;
                    timerURL.add(timerPaths[i]);
                }
            }
            if (!StringUtils.isEmpty((String)properties.getProperty("ignoreUrlKeywords"))) {
                String keywordsString = properties.getProperty("ignoreUrlKeywords");
                String[] keywords = keywordsString.split(",");
                for (i = 0; i < keywords.length; ++i) {
                    if (StringUtils.isEmpty((String)keywords[i])) continue;
                    ignoreUrlKeywords.add(keywords[i]);
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != in) {
                in.close();
            }
            if (null != fileInputStream) {
                fileInputStream.close();
            }
        }
    }

    public void init(FilterConfig filter) throws ServletException {
        String appRealPath = filter.getServletContext().getRealPath("");
        logger.info((Object)("application real path is:" + appRealPath));
        if (appRealPath.endsWith("shr_web.war")) {
            this.logoutPage = "/shr/shr_loginout/logout.do?ticked=true";
        }
        logger.info((Object)("application logoutPage is:" + this.logoutPage));
        try {
            File file = this.getPortalMonitorFile(PORTAL_PROPERTIES);
            this.loadValue(file);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)"UserMonitorFilter init!");
    }
}

