/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.web.controller;

import com.kingdee.eas.hr.emp.web.controller.PersonPhotoController;
import com.kingdee.util.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/personSquarePhoto"})
public class PersonSquarePhotoController
extends PersonPhotoController {
    private static final String DEFAULT_IMNAGE_TYPE = "JPEG";
    private static final int MIN_WIDTH = 50;

    @Override
    protected byte[] handleImageData(byte[] data, String imageType) throws IOException {
        BufferedImage read = ImageIO.read(new ByteArrayInputStream(data));
        int width = Math.min(read.getWidth(), read.getHeight());
        BufferedImage resultImage = read.getSubimage(0, 0, width, width);
        resultImage = this.reduceImage(resultImage, 50);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        if (imageType != null && imageType.contains("/")) {
            imageType = imageType.split("/")[1];
        }
        if (StringUtils.isEmpty((String)imageType)) {
            imageType = DEFAULT_IMNAGE_TYPE;
        }
        ImageIO.write((RenderedImage)resultImage, imageType, output);
        byte[] result = output.toByteArray();
        output.close();
        return result;
    }

    private BufferedImage reduceImage(BufferedImage resultImage, int newWidth) {
        if (resultImage.getWidth() > newWidth) {
            Image scaledInstance = resultImage.getScaledInstance(newWidth, newWidth, 4);
            BufferedImage newImage = new BufferedImage(newWidth, newWidth, 1);
            newImage.getGraphics().drawImage(scaledInstance, 0, 0, null);
            newImage.getGraphics().dispose();
            newImage.flush();
            resultImage = newImage;
        }
        return resultImage;
    }

    @Override
    protected void setResponseHeader(HttpServletRequest request, HttpServletResponse response, byte[] imageData) {
        if (!StringUtils.isEmpty((String)request.getParameter("timestamp"))) {
            Calendar now = Calendar.getInstance();
            Calendar newDate = Calendar.getInstance();
            response.setDateHeader("Date", now.getTimeInMillis());
            newDate.add(5, 1);
            response.setDateHeader("Expires", newDate.getTimeInMillis());
            response.addHeader("Cache-Control", "max-age=" + (newDate.getTimeInMillis() - now.getTimeInMillis()));
        }
    }
}

