/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.guilogin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.shr.base.syssetting.context.WebContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EASServiceHelper {
    private static final Logger logger = LoggerFactory.getLogger(EASServiceHelper.class);

    public boolean isAwokeAtUserReLogin(Context userCtx) {
        boolean flag = true;
        String paramkey = "isAwokeAtUserReLoginForPortal";
        try {
            String paravalue = ParamManager.getParamValue((Context)userCtx, null, (String)paramkey);
            flag = paravalue != null && "true".equalsIgnoreCase(paravalue);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("isAwokeAtUserReLogin error :", (Throwable)e);
        }
        return flag;
    }

    public boolean checkAllowUserRepeatLogin(Context ctx) {
        boolean allowRepeatLogin = true;
        try {
            UserInfo user = UserFactory.getRemoteInstance().getUserInfoByNumber(ctx.getUserName());
            if (user != null) {
                allowRepeatLogin = NotAllowRepeatLoginUserFactory.getRemoteInstance().isAllowRepeatLogin(user.getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("checkAllowUserRepeatLogin error:", (Throwable)e);
        }
        return allowRepeatLogin;
    }

    public boolean isReachUserLimitCount(Context ctx) {
        boolean flag = true;
        try {
            flag = UserMonitorFactory.getRemoteInstance().isOverLicenseCount(ctx.getUserName(), ctx.getAIS(), ctx.getContextID());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("isReachUserLimitCount error:", (Throwable)e);
        }
        return flag;
    }

    public boolean findHaveSamePortalUser(Context ctx, String sessionId) {
        boolean haveSameUser = false;
        try {
            haveSameUser = UserMonitorFactory.getRemoteInstance().isSameNamePortalUserExists(ctx.getAIS(), ctx.getUserName(), sessionId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            logger.error("findHaveSamePortalUser error:", (Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error("findHaveSamePortalUser error:", (Throwable)e);
        }
        return haveSameUser;
    }

    public List<UMRegistryInfo> findSameUsers(Context ctx) {
        List userList = new ArrayList();
        ArrayList<UMRegistryInfo> userList_rsp = new ArrayList<UMRegistryInfo>();
        try {
            List tempList = UserMonitorFactory.getLocalInstance((Context)ctx).findUsers(ctx.getAIS(), ctx.getUserName());
            if (tempList != null && !tempList.isEmpty()) {
                userList = tempList;
                for (UMRegistryInfo info : userList) {
                    String userInfoId = info.getGUIUserId() != null ? info.getGUIUserId() : info.getId();
                    if (userInfoId.equals(ctx.getContextID())) continue;
                    userList_rsp.add(info);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(" findSameUsers  error : ", (Throwable)e);
        }
        return userList_rsp;
    }

    public void deleteUserMonitorAllOtherPortalUser(String username, String dbcenter, String clientIP, String sessionId) {
        try {
            List userList = UserMonitorFactory.getRemoteInstance().findUsers(dbcenter, username);
            if (userList == null || userList.isEmpty()) {
                return;
            }
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            for (int i = 0; i < userList.size(); ++i) {
                UMRegistryInfo info = (UMRegistryInfo)userList.get(i);
                String id = info.getId();
                if (StringUtils.isEmpty((String)id) || id.equals(sessionId)) continue;
                String sessionID = id;
                if (sessionID == null) {
                    sessionID = info.getGUIUserId();
                }
                try {
                    ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
                    agent.releaseLicenseBySessionID(sessionID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteUserMonitor(HttpServletRequest request) {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            if (ctx != null) {
                String sessionId = ctx.getContextID();
                this.deleteUserMonitor(sessionId);
            } else {
                logger.error("easserviceimpl deleteUserMonitor ctx is null!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteUserMonitor(String sessionId) {
        try {
            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
            iUserMonitor.deleteSessionAndUserMonitorInfo(sessionId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map getSouceInfo(String sourceName, String kickIp, String beKickIp, String kickUserName, String beKickUserName, String kickTime) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            String msgBody = StringUtils.cnulls((String)ResourceBase.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource", (String)sourceName, (Locale)curLocal));
            String msg = msgBody.replaceAll("beKickUserName", beKickUserName).replaceAll("kickIp", kickIp).replaceAll("kickTime", kickTime).replaceAll("kickUserName", kickUserName);
            sourceMap.put(curLocal, msg);
        }
        return sourceMap;
    }

    private Map getSouceInfoBySet(String value) {
        HashMap<Locale, String> sourceMap = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocal = allLanguage[i].getLocale();
            sourceMap.put(curLocal, StringUtils.cnulls((String)value));
        }
        return sourceMap;
    }
}

