/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.guilogin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorStateEnum;
import com.kingdee.eas.base.usermonitor.web.UserMonitorLoginHelper;
import com.kingdee.eas.cp.eip.sso.otp.OTPManager;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.guilogin.web.wechart.WeChartUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHRLoginUtil {
    private static Logger logger = LoggerFactory.getLogger(SHRLoginUtil.class);

    public static Object login(HttpServletRequest request, String userAuthPattern, String userNumber, String token, String locale) {
        String newuser;
        String sucess;
        String errorMsg;
        HashMap<String, Object> result;
        long start;
        StringBuffer caller;
        block16: {
            caller = new StringBuffer();
            caller.append("request ip=" + SHRLoginUtil.getIpAddr(request)).append(" originuser=" + userNumber).append(" userAuthPattern=").append(userAuthPattern).append(" token=").append(token);
            start = System.currentTimeMillis();
            String easSessionId = Uuid.create().toString();
            result = new HashMap<String, Object>();
            String dataCenter = OTPManager.getAutoLoginDataCenter();
            DCInfo dcInfo = OTPManager.getDCInfo(dataCenter);
            if (StringUtils.isEmpty((String)locale)) {
                locale = "L2";
            }
            errorMsg = "";
            sucess = "true";
            newuser = null;
            try {
                newuser = WeChartUtil.authenWechart(request, userAuthPattern, userNumber, token, dataCenter, easSessionId, locale);
            }
            catch (BOSLoginException e) {
                errorMsg = e.getMessage();
                sucess = "false";
                e.printStackTrace();
            }
            if (StringUtils.isEmpty((String)errorMsg)) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("dbType", DbType.getName((int)dcInfo.getDBType()));
                attributes.put("dataCenter", "" + dcInfo.getNumber());
                attributes.put("solutionName", dcInfo.getSolutionName());
                attributes.put("locale", locale);
                attributes.put("loginFlow", "true");
                attributes.put("easSessionID", easSessionId);
                Context ctx = null;
                try {
                    ctx = LoginUtil.login((String)newuser, null, attributes);
                    if (StringUtils.isEmpty((String)ctx.getClientHostIP())) {
                        ctx.setClientHostIP(SHRLoginUtil.getIpAddr(request));
                        ctx.setClientHostName(request.getRemoteHost());
                    }
                    UserMonitorSessionInfo userMonitorSessionInfo = new UserMonitorSessionInfo();
                    userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.login);
                    userMonitorSessionInfo.setLastUpdateTime(new Date());
                    userMonitorSessionInfo.setLastCheckTickedTime(new Date());
                    userMonitorSessionInfo.setId(request.getSession().getId());
                    request.getSession().setAttribute("userMonitorSessionInfo", (Object)userMonitorSessionInfo);
                    userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.monitored);
                    UMRegistryInfo info = UserMonitorLoginHelper.createUMRegistryInfo((Context)ctx, (String)request.getSession().getId(), (String)SHRLoginUtil.getIpAddr(request));
                    UserMonitorLoginHelper.saveUMRegistryInfo((UMRegistryInfo)info, (Context)ctx);
                    if (ctx != null) {
                        HashMap<String, String> data;
                        block15: {
                            request.getSession().putValue("pureWebContext", (Object)ctx);
                            data = new HashMap<String, String>();
                            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                            data.put("userid", ctx.getCaller().toString());
                            data.put("username", user.getName());
                            data.put("usernumber", user.getNumber());
                            if (user.getPerson() != null) {
                                data.put("personnumber", user.getPerson().getName());
                                data.put("personname", user.getPerson().getNumber());
                                data.put("personid", user.getPerson().getId().toString());
                                String sql = "select FXtId from t_pm_easxtusermap   where FPersonId = ? ";
                                Object[] param = new Object[]{user.getPerson().getId().toString()};
                                try {
                                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                                    if (rowSet.next()) {
                                        data.put("openid", rowSet.getString("FXtId"));
                                        break block15;
                                    }
                                    data.put("openid", "");
                                }
                                catch (BOSException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                                catch (SQLException e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                }
                            } else {
                                data.put("personnumber", "");
                                data.put("personname", "");
                                data.put("personed", "");
                            }
                        }
                        result.put("data", data);
                        break block16;
                    }
                    sucess = "false";
                    errorMsg = "login failed";
                }
                catch (BOSLoginException e) {
                    sucess = "false";
                    errorMsg = e.getMessage();
                    e.printStackTrace();
                }
            } else {
                sucess = "false";
            }
        }
        long end = System.currentTimeMillis();
        result.put("sucess", sucess);
        result.put("errorMsg", errorMsg);
        result.put("cost", "" + (end - start));
        caller.append("user=").append(newuser).append(" sucess =" + result.get("sucess")).append(" errorMsg=" + result.get("errorMsg")).append(" cost=" + result.get("cost"));
        return result;
    }

    private static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("nap_proxy_client_ip");
        if (StringUtils.isEmpty((String)ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean isBaseDBUserAuthPatternByContext(Context ctx) {
        String userAuthPatternObj;
        boolean flag = false;
        if (null == ctx) {
            return flag;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (null == userInfo) {
            return flag;
        }
        String string = userAuthPatternObj = ctx.get((Object)"UserAuthPattern") == null ? "" : ctx.get((Object)"UserAuthPattern").toString();
        if (StringUtils.isEmpty((String)userAuthPatternObj) || "BaseDB".equalsIgnoreCase(String.valueOf(userAuthPatternObj)) && LoginAuthorWayEnum.NORMAL.equals((Object)userInfo.getLoginAuthorWay())) {
            flag = true;
        }
        return flag;
    }
}

