/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.guilogin.web.controller;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorStateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRUserCheckUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.util.AESUtil;
import com.kingdee.shr.guilogin.EASServiceHelper;
import com.kingdee.shr.guilogin.SHRLoginUtil;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.cache.MLCacheHelper;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/web_frame/easrpc/login"})
public class FrameLoginController
extends WebComponentController {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(params={"method=loginCheck"})
    public String loginCheck(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String redirectTo;
        Context ctx;
        if (SHRContext.getInstance() == null) {
            SHRContext.setInstance((SHRContext)((SHRContext)request.getSession().getAttribute("shr_context")));
        }
        if ((ctx = SHRContext.getInstance().getContext()) == null) {
            return "/shr/gui/logout";
        }
        boolean isCheckPasswordPolicy = SHRLoginUtil.isBaseDBUserAuthPatternByContext(ctx);
        if (isCheckPasswordPolicy && SHRUserCheckUtils.checkPasswordPolicy((Context)ctx, (HttpServletRequest)request)) {
            return "/shr/gui/passwordPolicyCheck";
        }
        String result = null;
        String isNotCheckRelogin = request.getParameter("isNotCheckRelogin");
        if (!"true".equals(isNotCheckRelogin)) {
            result = this.checkRelogin(request, ctx);
        }
        if (!StringUtils.isEmpty((String)(redirectTo = request.getParameter("redirectTo")))) {
            String contextPath = request.getContextPath();
            if (contextPath == null || contextPath.equals("/")) {
                contextPath = "";
            }
            redirectTo = redirectTo.replace("@", "&");
            String appServerName = DynamicUtil.getContextPath();
            if (redirectTo.startsWith(contextPath) || !redirectTo.startsWith(appServerName) && !redirectTo.startsWith("/easportal")) return "redirect:" + redirectTo;
            try {
                response.sendRedirect(SHRCheck.checkUrlParamsForSendRedirect((String)redirectTo));
            }
            catch (IOException e) {
                this.logger.error((Object)"sendRedirect error:", (Throwable)e);
            }
        } else {
            redirectTo = "redirect:/main.do";
        }
        if (result != null) {
            return result;
        }
        this.addUserMonitorInfo(ctx, request);
        return redirectTo;
    }

    private void addUserMonitorInfo(Context ctx, HttpServletRequest httpRequest) {
        Locale userLocale = null;
        UserMonitorSessionInfo userMonitorSessionInfo = new UserMonitorSessionInfo();
        if (ctx != null) {
            userLocale = ctx.getLocale();
            userMonitorSessionInfo.setId(ctx.getContextID());
        } else {
            String defaultLanguage = httpRequest.getSession().getServletContext().getInitParameter("com.kingdee.eas.portal.defaultLanguage");
            if (defaultLanguage == null || "".equals(defaultLanguage)) {
                defaultLanguage = "L2";
            }
            userLocale = new Locale(defaultLanguage);
        }
        userMonitorSessionInfo.setUserMonitorState(UserMonitorStateEnum.login);
        userMonitorSessionInfo.setLastUpdateTime(new Date());
        userMonitorSessionInfo.setLastCheckTickedTime(new Date());
        HttpSession session = httpRequest.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)userLocale);
        session.setAttribute("userMonitorSessionInfo", (Object)userMonitorSessionInfo);
    }

    private String checkRelogin(HttpServletRequest request, Context ctx) throws SHRWebException {
        EASServiceHelper easService = new EASServiceHelper();
        List<UMRegistryInfo> userList = easService.findSameUsers(ctx);
        this.logger.error((Object)("checkRelogin userList.size()===" + userList.size()));
        boolean findUser = false;
        if (!userList.isEmpty()) {
            String sessionId = ctx.getContextID();
            for (UMRegistryInfo info : userList) {
                String guiUserId = info.getGUIUserId();
                if (null == guiUserId || !guiUserId.equals(sessionId)) continue;
                return null;
            }
            for (UMRegistryInfo info : userList) {
                String id = info.getId();
                if (null == id || id.equals(sessionId)) continue;
                findUser = true;
                break;
            }
            this.logger.error((Object)("checkRelogin findUser===" + findUser));
            if (findUser) {
                boolean allowRelogin = easService.checkAllowUserRepeatLogin(ctx);
                this.logger.error((Object)("checkRelogin allowRelogin===" + allowRelogin));
                if (allowRelogin) {
                    boolean isReachUserLimitCount = easService.isReachUserLimitCount(ctx);
                    this.logger.error((Object)("checkRelogin isReachUserLimitCount===" + isReachUserLimitCount));
                    request.getSession().setAttribute("isReachUserLimitCount", (Object)String.valueOf(isReachUserLimitCount));
                    try {
                        Map m = MLCacheHelper.getResource((Context)ctx, (ResourceType)ResourceType.JSP, (String)"framework.jsp");
                        request.setAttribute("jspMultiLan", (Object)m);
                    }
                    catch (EASBizException e) {
                        request.setAttribute("jspMultiLan", (Object)Collections.EMPTY_MAP);
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        request.setAttribute("jspMultiLan", (Object)Collections.EMPTY_MAP);
                        e.printStackTrace();
                    }
                    if (isReachUserLimitCount) {
                        request.setAttribute("username", (Object)ctx.getUserName());
                        request.setAttribute("dbcenter", (Object)ctx.getAIS());
                        request.setAttribute("isReachUserLimitCount", (Object)isReachUserLimitCount);
                        return "/shr/gui/loginAgain";
                    }
                    boolean isAwoke = easService.isAwokeAtUserReLogin(ctx);
                    this.logger.error((Object)("checkRelogin isAwoke===" + isAwoke));
                    if (isAwoke) {
                        request.setAttribute("username", (Object)ctx.getUserName());
                        request.setAttribute("dbcenter", (Object)ctx.getAIS());
                        request.setAttribute("isReachUserLimitCount", (Object)isReachUserLimitCount);
                        return "/shr/gui/loginAgain";
                    }
                } else {
                    request.getSession().setAttribute("reloginNotAllow", (Object)"true");
                    return "/shr/gui/reloginNotAllow";
                }
            }
        }
        return null;
    }

    @RequestMapping(params={"method=showPasswordUI"})
    public String showPasswordUI(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        return "/shr/gui/passwordPolicyCheckContent";
    }

    @RequestMapping(params={"method=changePassword"})
    public void changePassword(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String str = "";
        try {
            String strOldPwd = AESUtil.aesDecrypt((String)request.getParameter("oldPassStr"), (String)"g5AJVI7fQGWZKrdZ");
            String strNewPwd = AESUtil.aesDecrypt((String)request.getParameter("newPassStr"), (String)"g5AJVI7fQGWZKrdZ");
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            strOldPwd = CryptoTean.encrypt((String)ctx.getUserName(), (String)strOldPwd);
            strNewPwd = CryptoTean.encrypt((String)ctx.getUserName(), (String)strNewPwd);
            this.updatePassword(ctx, strOldPwd, strNewPwd);
        }
        catch (Exception e) {
            if (e instanceof UserException) {
                UserException ue = (UserException)e;
                str = UserException.PASSWORD_NOT_MATCH.getCode().equals(ue.getSubCode()) ? "kingdee.portal.i18n.oldpassworderror" : e.getMessage();
            } else {
                str = e.getMessage();
            }
            this.logger.error((Object)"Change password error:", (Throwable)e);
        }
        this.writeAjaxData(true, null, str, response);
    }

    public void updatePassword(Context ctx, String oldPassword, String newPassword) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        iUser.updatePass(ctx.getCaller(), oldPassword, newPassword);
        ctx.put((Object)"encryptPassword", (Object)newPassword);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo userDb = iUser.getUser(user.getNumber());
        ctx.put((Object)"UserInfo", (Object)userDb);
    }

    protected void writeAjaxData(boolean success, LocalErr errinfo, Object result, HttpServletResponse response) {
        Object tempResult = result == null ? "" : result;
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", success);
        ajaxData.put("errinfo", errinfo);
        ajaxData.put("result", tempResult);
        this.writeObjectData(JSONUtil.getJson4Object(ajaxData), ResponseContentTypeEnum.JSON, response);
    }

    protected void writeObjectData(Object result, ResponseContentTypeEnum contentType, HttpServletResponse response) {
        try {
            String _contentType = null;
            byte[] _result = null;
            if (ResponseContentTypeEnum.JSON.equals((Object)contentType)) {
                _contentType = "text/json;charset=utf-8";
                _result = result instanceof String ? result.toString().getBytes("utf-8") : (result instanceof byte[] ? (byte[])result : (result instanceof Collection ? JSONUtil.getJson4List((Collection)((Collection)result)).toString().getBytes("utf-8") : JSONUtil.getJson4Object((Object)result).toString().getBytes("utf-8")));
            } else if (ResponseContentTypeEnum.HTML.equals((Object)contentType)) {
                _contentType = "text/html;charset=utf-8";
                _result = result instanceof String ? result.toString().getBytes("utf-8") : (result instanceof byte[] ? (byte[])result : result.toString().getBytes("utf-8"));
            }
            this.writeResponse(response, _contentType, _result);
        }
        catch (Exception ex) {
            this.logger.error((Object)"writeObjectData", (Throwable)ex);
        }
    }

    protected void writeResponse(HttpServletResponse response, String contentType, byte[] result) {
        try {
            response.setHeader("cache-control", "no-cache");
            response.setHeader("charset", "utf-8");
            if (!StringUtils.isEmpty((String)contentType)) {
                response.setContentType(contentType);
            }
            response.getOutputStream().write(result);
        }
        catch (Exception ex) {
            this.logger.error((Object)"writeResponse", (Throwable)ex);
        }
    }

    @RequestMapping(params={"method=getSettingInfo"})
    public String getSettingInfo(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        return "settingInfo";
    }

    @RequestMapping(params={"method=upgradeCheck"})
    public String upgradeCheck(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        return "/shr/gui/notUpgraded";
    }
}

